/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.support.types.StringToStringMap;

public class XPathComponent {
    private String namespace;
    private String prefix;
    private String localNameWithoutBraces;
    private String braces;

    public XPathComponent(String c, StringToStringMap prefixMap) {
        String localName;
        int ix = c.indexOf(58);
        if (ix >= 0) {
            this.prefix = c.substring(0, ix);
            localName = c.substring(ix + 1);
            this.namespace = (String)prefixMap.get(this.prefix);
        } else {
            this.prefix = null;
            localName = c;
            this.namespace = null;
        }
        ix = localName.indexOf(91);
        if (ix >= 0) {
            this.localNameWithoutBraces = localName.substring(0, ix);
            this.braces = localName.substring(ix);
        } else {
            this.localNameWithoutBraces = localName;
            this.braces = "";
        }
        assert (localName.equals(this.localNameWithoutBraces + this.braces)) : localName + " != " + this.localNameWithoutBraces + " + " + this.braces;
    }

    public String toString() {
        if (this.prefix != null) {
            return this.prefix + ":" + this.localNameWithoutBraces + this.braces;
        }
        return this.localNameWithoutBraces + this.braces;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            return "";
        }
        return this.prefix;
    }

    public String getLocalName() {
        return this.localNameWithoutBraces;
    }

    public String getBraces() {
        return this.braces;
    }

    public String getFullNameWithPrefix() {
        return this.getFullNameWithPrefix(this.localNameWithoutBraces);
    }

    public String getFullNameWithPrefix(String aLocalName) {
        return (String)(this.hasPrefix() ? this.getPrefix() + ":" : "") + aLocalName + this.getBraces();
    }
}

