/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting.js;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineFactory;
import com.eviware.soapui.support.scripting.SoapUIScriptGenerator;
import com.eviware.soapui.support.scripting.js.JsScriptEngine;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XPathData;

public class JsScriptEngineFactory
implements SoapUIScriptEngineFactory,
SoapUIScriptGenerator {
    public static final String ID = "Javascript";

    @Override
    public SoapUIScriptEngine createScriptEngine(ModelItem modelItem) {
        return new JsScriptEngine(SoapUI.class.getClassLoader());
    }

    @Override
    public SoapUIScriptGenerator createCodeGenerator(ModelItem modelItem) {
        return this;
    }

    @Override
    public String createContextExpansion(String name, PropertyExpansion expansion) {
        String exp = expansion.toString();
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < exp.length(); ++c) {
            char ch = exp.charAt(c);
            switch (ch) {
                case '\'': 
                case '\\': {
                    buf.append('\\');
                }
            }
            buf.append(ch);
        }
        return "var " + name + " = context.expand( \"" + buf.toString() + "\" );\n";
    }

    @Override
    public String createScriptAssertionForExists(XPathData xpathData) {
        Object script = "var holder = new com.eviware.soapui.support.XmlHolder( messageExchange.responseContentAsXml );\n";
        StringToStringMap nsMap = xpathData.getNamespaceMap();
        for (String ns : nsMap.keySet()) {
            script = (String)script + "holder.namespaces.put(\"" + (String)nsMap.get(ns) + "\", \"" + ns + "\" );\n";
        }
        script = (String)script + "var node = holder.getDomNode( \"" + xpathData.getPath() + "\" );\n";
        script = (String)script + "if( node == null )\n   throw new java.lang.Exception( \"Missing node\" );\n";
        return script;
    }
}

