/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting.js;

import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.types.StringToObjectMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsScriptEngine
implements SoapUIScriptEngine {
    private String scriptText;
    private StringToObjectMap properties = new StringToObjectMap();
    private final ClassLoader parentClassLoader;

    public JsScriptEngine(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() throws Exception {
        if (StringUtils.isNullOrEmpty(this.scriptText)) {
            return null;
        }
        Context context = ContextFactory.getGlobal().enterContext();
        context.setApplicationClassLoader(this.parentClassLoader);
        ScriptableObject scope = context.initStandardObjects();
        try {
            for (String name : this.properties.keySet()) {
                ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)Context.javaToJS(this.properties.get(name), (Scriptable)scope));
            }
            Script script = context.compileString(this.scriptText, "Script", 0, null);
            Object object = script.exec(context, (Scriptable)scope);
            return object;
        }
        finally {
            for (String name : this.properties.keySet()) {
                scope.delete(name);
            }
            Context.exit();
        }
    }

    @Override
    public synchronized void setScript(String scriptText) {
        if (scriptText != null && scriptText.equals(this.scriptText)) {
            return;
        }
        this.scriptText = scriptText;
    }

    @Override
    public void compile() throws Exception {
    }

    @Override
    public void setVariable(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public void clearVariables() {
        this.properties.clear();
    }

    @Override
    public void release() {
        this.clearVariables();
    }
}

