/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ResolveContext<T extends AbstractWsdlModelItem<?>> {
    private List<PathToResolve> pathsToResolve = new ArrayList<PathToResolve>();
    private final T modelItem;

    public ResolveContext(T modelItem) {
        this.modelItem = modelItem;
    }

    public T getModelItem() {
        return this.modelItem;
    }

    public PathToResolve addPathToResolve(AbstractWsdlModelItem<?> owner, String description, String path) {
        PathToResolve pathToResolve = new PathToResolve(owner, description, path);
        this.pathsToResolve.add(pathToResolve);
        return pathToResolve;
    }

    public PathToResolve addPathToResolve(AbstractWsdlModelItem<?> owner, String description, String path, Resolver resolver) {
        PathToResolve pathToResolve = new PathToResolve(owner, description, path);
        pathToResolve.addResolvers(resolver);
        this.pathsToResolve.add(pathToResolve);
        return pathToResolve;
    }

    public boolean isEmpty() {
        return this.pathsToResolve.isEmpty();
    }

    public List<PathToResolve> getPathsToResolve() {
        return this.pathsToResolve;
    }

    public int getUnresolvedCount() {
        int resultCnt = 0;
        for (PathToResolve ptr : this.pathsToResolve) {
            if (ptr.getResolver() != null && ptr.getResolver().isResolved()) continue;
            ++resultCnt;
        }
        return resultCnt;
    }

    public int apply() {
        int resultCnt = 0;
        for (PathToResolve ptr : this.pathsToResolve) {
            if (!ptr.resolve()) continue;
            ++resultCnt;
        }
        return resultCnt;
    }

    public boolean hasThisModelItem(AbstractWsdlModelItem<?> modelItem, String description, String pathName) {
        if (pathName == null) {
            return true;
        }
        PathToResolve pathToCheck = new PathToResolve(modelItem, description, pathName);
        for (PathToResolve path : this.pathsToResolve) {
            if (!path.equals(pathToCheck)) continue;
            return true;
        }
        return false;
    }

    public PathToResolve getPath(AbstractWsdlModelItem<?> modelItem, String description, String pathName) {
        PathToResolve pathToCheck = new PathToResolve(modelItem, description, pathName);
        for (PathToResolve path : this.pathsToResolve) {
            if (!path.equals(pathToCheck)) continue;
            return path;
        }
        return null;
    }

    public class PathToResolve {
        private final AbstractWsdlModelItem<?> owner;
        private final String description;
        private List<Resolver> resolvers = new ArrayList<Resolver>();
        private final String path;
        private Resolver resolver;
        private boolean resolved;

        public PathToResolve(AbstractWsdlModelItem<?> owner, String description, String path) {
            this.owner = owner;
            this.description = description;
            this.path = path;
        }

        public void addResolvers(Resolver ... resolvers) {
            for (Resolver res : resolvers) {
                this.resolvers.add(res);
            }
        }

        public AbstractWsdlModelItem<?> getOwner() {
            return this.owner;
        }

        public String getDescription() {
            return this.description;
        }

        public Resolver getResolver() {
            return this.resolver;
        }

        public String getPath() {
            return this.path;
        }

        public boolean resolve() {
            if (this.resolver != null) {
                this.resolved = this.resolver.resolve();
                return this.resolved;
            }
            return false;
        }

        public void setResolver(Object resolveOrDefaultAction) {
            this.resolver = (Resolver)resolveOrDefaultAction;
        }

        public ArrayList<Resolver> getResolvers() {
            return (ArrayList)this.resolvers;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathToResolve other = (PathToResolve)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        private ResolveContext getOuterType() {
            return ResolveContext.this;
        }

        public void setSolved(boolean solved) {
            this.resolved = solved;
        }

        public boolean update() {
            for (Resolver resolver : this.resolvers) {
                if (!resolver.isResolved()) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Resolver {
        public boolean resolve();

        public boolean isResolved();

        public String getResolvedPath();

        public Object getDescription();
    }

    public static abstract class DirectoryResolver
    implements Resolver {
        private String title;
        private String current;
        private File result;
        private boolean resolved;

        public DirectoryResolver(String title, String current) {
            this.title = title;
            this.current = current;
        }

        @Override
        public boolean isResolved() {
            return this.resolved;
        }

        @Override
        public String getResolvedPath() {
            return this.result == null ? null : this.result.getAbsolutePath();
        }

        public abstract boolean apply(File var1);

        @Override
        public boolean resolve() {
            this.result = UISupport.getFileDialogs().openDirectory(this, this.title, StringUtils.isNullOrEmpty(this.current) ? null : new File(this.current));
            if (this.result != null) {
                this.resolved = this.apply(this.result);
            }
            return this.resolved;
        }

        @Override
        public Object getDescription() {
            return this.title;
        }

        public String toString() {
            return (String)this.getDescription();
        }
    }

    public static abstract class FileResolver
    implements Resolver {
        private String title;
        private String extension;
        private String fileType;
        private String current;
        private File result;
        private boolean resolved;

        public FileResolver(String title, String extension, String fileType, String current) {
            this.title = title;
            this.extension = extension;
            this.fileType = fileType;
            this.current = current;
        }

        @Override
        public boolean isResolved() {
            return this.resolved;
        }

        @Override
        public String getResolvedPath() {
            return this.result == null ? null : this.result.getAbsolutePath();
        }

        public abstract boolean apply(File var1);

        @Override
        public boolean resolve() {
            this.result = UISupport.getFileDialogs().open(this, this.title, this.extension, this.fileType, this.current);
            if (this.result != null) {
                this.resolved = this.apply(this.result);
            }
            return this.resolved;
        }

        @Override
        public Object getDescription() {
            return this.title;
        }

        public String toString() {
            return (String)this.getDescription();
        }
    }
}

