/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.preferences;

import com.eviware.soapui.SoapUI;
import java.awt.Rectangle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    public static final String ROOT_NODE_NAME = SoapUI.class.getName();
    static final String WINDOW_X = "SoapUIWindowX";
    static final String WINDOW_Y = "SoapUIWindowY";
    static final String WINDOW_WIDTH = "SoapUIWindowWidth";
    static final String WINDOW_HEIGHT = "SoapUIWindowHeight";
    static final String EXTENDED_STATE = "SoapUIExtendedState";
    static final String INSTALLATION_TYPE = "SoapUIInstallationType";
    private static final Preferences unifiedPreferences = Preferences.userRoot().node("com.smartbear.ready.api.UBL");
    private Preferences preferences = Preferences.userRoot().node(ROOT_NODE_NAME);

    public void setSoapUIWindowBounds(Rectangle windowBounds) throws BackingStoreException {
        if (windowBounds == null) {
            this.clearAllProperties(WINDOW_X, WINDOW_Y, WINDOW_HEIGHT, WINDOW_WIDTH);
            return;
        }
        this.preferences.putInt(WINDOW_X, windowBounds.x);
        this.preferences.putInt(WINDOW_Y, windowBounds.y);
        this.preferences.putInt(WINDOW_WIDTH, windowBounds.width);
        this.preferences.putInt(WINDOW_HEIGHT, windowBounds.height);
        this.preferences.flush();
    }

    public Rectangle getSoapUIWindowBounds() {
        if (this.hasAllIntProperties(WINDOW_X, WINDOW_Y, WINDOW_WIDTH, WINDOW_HEIGHT)) {
            return new Rectangle(this.preferences.getInt(WINDOW_X, 0), this.preferences.getInt(WINDOW_Y, 0), this.preferences.getInt(WINDOW_WIDTH, 800), this.preferences.getInt(WINDOW_HEIGHT, 600));
        }
        return null;
    }

    public void setSoapUIExtendedState(int extendedState) throws BackingStoreException {
        this.preferences.putInt(EXTENDED_STATE, extendedState);
        this.preferences.flush();
    }

    public int getSoapUIExtendedState() {
        if (this.hasAllIntProperties(EXTENDED_STATE)) {
            return this.preferences.getInt(EXTENDED_STATE, 0);
        }
        return 0;
    }

    public void setInstallationType(int type) throws BackingStoreException {
        this.preferences.putInt(INSTALLATION_TYPE, type);
        this.preferences.flush();
    }

    public int getInstallationType() {
        if (this.hasAllIntProperties(INSTALLATION_TYPE)) {
            return this.preferences.getInt(INSTALLATION_TYPE, -1);
        }
        return -1;
    }

    private void clearAllProperties(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.preferences.remove(propertyName);
        }
    }

    private boolean hasAllIntProperties(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            if (this.preferences.getInt(propertyName, -1) != -1) continue;
            return false;
        }
        return true;
    }

    public void setAnalyticsUserId(String userId) {
        unifiedPreferences.put("UniqueUserAnalyticsId", userId);
    }

    public String getAnalyticsUserId() {
        return unifiedPreferences.get("UniqueUserAnalyticsId", "");
    }

    public static void main(String[] args) throws BackingStoreException {
        new UserPreferences().setSoapUIWindowBounds(null);
    }
}

