/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.log.Log4JMonitor;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.apache.logging.log4j.core.LogEvent;

public class TabbedLog4JMonitor
extends JTabbedPane
implements Log4JMonitor {
    private JLogList defaultLogArea;

    public TabbedLog4JMonitor() {
        super(3, 1);
    }

    @Override
    public JLogList addLogArea(String title, String loggerName, boolean isDefault) {
        JLogList logArea = new JLogList(title);
        logArea.addLogger(loggerName, !isDefault);
        this.addTab(title, logArea);
        if (isDefault) {
            this.defaultLogArea = logArea;
        }
        return logArea;
    }

    @Override
    public void logEvent(Object msg) {
        if (msg instanceof LogEvent) {
            LogEvent event = (LogEvent)msg;
            String loggerName = event.getLoggerName();
            for (int c = 0; c < this.getTabCount(); ++c) {
                JLogList logArea;
                Component tabComponent = this.getComponentAt(c);
                if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
                logArea.addLine(msg);
            }
        } else if (this.defaultLogArea != null) {
            this.defaultLogArea.addLine(msg);
        }
    }

    @Override
    public JLogList getLogArea(String title) {
        int ix = this.indexOfTab(title);
        return (JLogList)(ix == -1 ? null : this.getComponentAt(ix));
    }

    @Override
    public boolean hasLogArea(String loggerName) {
        for (int c = 0; c < this.getTabCount(); ++c) {
            JLogList logArea;
            Component tabComponent = this.getComponentAt(c);
            if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JLogList getCurrentLog() {
        int ix = this.getSelectedIndex();
        return ix == -1 ? null : this.getLogArea(this.getTitleAt(ix));
    }

    @Override
    public void setCurrentLog(JLogList lastLog) {
        for (int c = 0; c < this.getTabCount(); ++c) {
            Component tabComponent = this.getComponentAt(c);
            if (tabComponent != lastLog) continue;
            this.setSelectedComponent(tabComponent);
        }
    }

    @Override
    public boolean removeLogArea(String loggerName) {
        for (int c = 0; c < this.getTabCount(); ++c) {
            JLogList tabComponent = (JLogList)this.getComponentAt(c);
            if (tabComponent.getLogger(loggerName) == null) continue;
            this.removeTabAt(c);
            return true;
        }
        return false;
    }
}

