/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.wss;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.wss.AbstractWssInspector;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class WssInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "WSS";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockRequestWssInspector((WsdlMockResponse)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new RequestMessageExchangeWssInspector((MessageExchangeModelItem)modelItem);
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlRequest) {
            return new WsdlResponseWssInspector((WsdlRequest)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return new ResponseMessageExchangeWssInspector((MessageExchangeModelItem)modelItem);
        }
        return null;
    }

    public class WsdlMockRequestWssInspector
    extends AbstractWssInspector
    implements XmlInspector,
    PropertyChangeListener {
        private final WsdlMockResponse response;

        public WsdlMockRequestWssInspector(WsdlMockResponse response) {
            this.response = response;
            response.addPropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
        }

        @Override
        public Vector<?> getWssResults() {
            return this.response.getMockResult() == null ? null : ((WsdlMockResult)this.response.getMockResult()).getRequestWssResult();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        @Override
        public void release() {
            this.response.removePropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
        }
    }

    public class RequestMessageExchangeWssInspector
    extends AbstractWssInspector
    implements XmlInspector,
    PropertyChangeListener {
        private final MessageExchangeModelItem item;

        public RequestMessageExchangeWssInspector(MessageExchangeModelItem item) {
            this.item = item;
            item.addPropertyChangeListener("messageExchange", this);
        }

        @Override
        public Vector<?> getWssResults() {
            return this.item.getMessageExchange() instanceof WsdlMessageExchange ? ((WsdlMessageExchange)this.item.getMessageExchange()).getRequestWssResult() : null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        @Override
        public void release() {
            this.item.removePropertyChangeListener("messageExchange", this);
        }
    }

    public class WsdlResponseWssInspector
    extends AbstractWssInspector
    implements XmlInspector,
    PropertyChangeListener {
        private final WsdlRequest response;

        public WsdlResponseWssInspector(WsdlRequest response) {
            this.response = response;
            response.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
        }

        @Override
        public Vector<?> getWssResults() {
            return this.response.getResponse() == null ? null : this.response.getResponse().getWssResult();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        @Override
        public void release() {
            this.response.removePropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
        }
    }

    public class ResponseMessageExchangeWssInspector
    extends AbstractWssInspector
    implements XmlInspector,
    PropertyChangeListener {
        private final MessageExchangeModelItem item;

        public ResponseMessageExchangeWssInspector(MessageExchangeModelItem item) {
            this.item = item;
            item.addPropertyChangeListener("messageExchange", this);
        }

        @Override
        public Vector<?> getWssResults() {
            return this.item.getMessageExchange() instanceof WsdlMessageExchange ? ((WsdlMessageExchange)this.item.getMessageExchange()).getResponseWssResult() : null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        @Override
        public void release() {
            this.item.removePropertyChangeListener("messageExchange", this);
        }
    }
}

