/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.wsrm;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.editor.inspectors.wsrm.AbstractWsrmInspector;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class WsdlRequestWsrmPiggybackInspector
extends AbstractWsrmInspector
implements XmlInspector,
SubmitListener {
    private final WsdlRequest request;

    protected WsdlRequestWsrmPiggybackInspector(WsdlRequest request) {
        super(request);
        request.addSubmitListener(this);
        this.request = request;
    }

    @Override
    public void release() {
        super.release();
        this.request.removeSubmitListener(this);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        if (this.request.getWsrmConfig().isWsrmEnabled() && submit.getResponse() != null) {
            String content = submit.getResponse().getContentAsString();
            XmlOptions options = new XmlOptions();
            try {
                XmlObject xml = XmlUtils.createXmlObject(content);
                String namespaceDeclaration = "declare namespace wsrm='" + this.request.getWsrmConfig().getVersionNameSpace() + "';";
                XmlObject[] result = xml.selectPath(namespaceDeclaration + "//wsrm:AcknowledgementRange", options);
                if (result.length > 0) {
                    for (int i = 0; i < result.length; ++i) {
                        String upper = result[i].selectAttribute(null, "Upper").getDomNode().getNodeValue();
                        String lower = result[i].selectAttribute(null, "Lower").getDomNode().getNodeValue();
                        if (lower == upper) {
                            LogManager.getLogger((String)"wsrm").info("Acknowledgment for message " + upper + " received for identifier: " + this.request.getWsrmConfig().getSequenceIdentifier());
                            continue;
                        }
                        LogManager.getLogger((String)"wsrm").info("Acknowledgment for messages " + lower + " to " + upper + " received for identifier: " + this.request.getWsrmConfig().getSequenceIdentifier());
                    }
                }
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        return true;
    }
}

