/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.RefreshOAuthAccessTokenAction;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.auth.AbstractAuthenticationForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AccessTokenStatusChangeListener;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AccessTokenStatusChangeManager;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2AdvancedOptionsDialog;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2GetAccessTokenForm;
import com.eviware.soapui.support.editor.inspectors.auth.ProfileSelectionForm;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OAuth2Form
extends AbstractAuthenticationForm
implements OAuth2AccessTokenStatusChangeListener {
    public static final String ADVANCED_OPTIONS_BUTTON_NAME = "Advanced...";
    public static final String REFRESH_ACCESS_TOKEN_BUTTON_NAME = "refreshAccessTokenButton";
    private static final int ACCESS_TOKEN_DIALOG_HORIZONTAL_OFFSET = 120;
    private static final Dimension HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW = new Dimension(5, 0);
    private static final String ACCESS_TOKEN_LABEL = "Access Token";
    private static final Insets ACCESS_TOKEN_FIELD_INSETS = new Insets(5, 5, 5, 5);
    private static final float ACCESS_TOKEN_STATUS_TEXT_FONT_SCALE = 0.95f;
    private static final int ACCESS_TOKEN_STATUS_TEXT_WIDTH = 100;
    private static final String GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL = "Get Token";
    private static final String GET_ACCESS_TOKEN_BUTTON_RESUME_LABEL = "Get Token (Resume)";
    private final Color DEFAULT_COLOR = Color.WHITE;
    private final Color SUCCESS_COLOR = new Color(0xCCFFCB);
    private final Color FAIL_COLOR = new Color(0xFFCCCC);
    static final ImageIcon SUCCESS_ICON = UISupport.createImageIcon("/check.png");
    static final ImageIcon WAIT_ICON = UISupport.createImageIcon("/waiting-spinner.gif");
    static final ImageIcon FAIL_ICON = UISupport.createImageIcon("/alert.png");
    private final AbstractXmlInspector inspector;
    private final OAuth2AccessTokenStatusChangeManager statusChangeManager;
    private OAuth2Profile profile;
    private JPanel formPanel;
    private boolean disclosureButtonDisabled;
    private boolean isMouseOnDisclosureLabel;
    private SimpleBindingForm oAuth2Form;
    private JTextField accessTokenField;
    private JLabel accessTokenStatusIcon;
    private JLabel accessTokenStatusText;
    private JLabel disclosureButton;
    private OAuth2GetAccessTokenForm accessTokenForm;
    private SoapUIMainWindowFocusListener mainWindowFocusListener;

    public OAuth2Form(OAuth2Profile profile, AbstractXmlInspector inspector) {
        this.profile = profile;
        this.inspector = inspector;
        this.statusChangeManager = new OAuth2AccessTokenStatusChangeManager(this);
    }

    void release() {
        SoapUI.getFrame().removeWindowFocusListener(this.mainWindowFocusListener);
        this.accessTokenForm.release();
        this.oAuth2Form.getPresentationModel().release();
        this.statusChangeManager.unregister();
    }

    @Override
    public void onAccessTokenStatusChanged(@Nonnull OAuth2Profile.AccessTokenStatus status) {
        this.setAccessTokenStatusFeedback(status);
    }

    @Override
    @Nonnull
    public OAuth2Profile getProfile() {
        return this.profile;
    }

    @Override
    protected JPanel buildUI() {
        this.oAuth2Form = new SimpleBindingForm(new PresentationModel((Object)this.profile));
        this.addOAuth2Panel(this.oAuth2Form);
        this.statusChangeManager.register();
        if (this.profile.getAccessTokenStatus() != OAuth2Profile.AccessTokenStatus.RETRIEVAL_CANCELED) {
            this.profile.resetAccessTokenStatusToStartingStatus();
        }
        this.setAccessTokenStatusFeedback(this.profile.getAccessTokenStatus());
        return this.formPanel;
    }

    private void addOAuth2Panel(SimpleBindingForm oAuth2Form) {
        this.populateOAuth2Form(oAuth2Form);
        this.formPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = oAuth2Form.getPanel();
        this.setBackgroundColorOnPanel(centerPanel);
        JPanel southPanel = new JPanel(new FlowLayout(0));
        JLabel oAuthDocumentationLink = UISupport.createLabelLink("/OAuth/oauth2-overview.html", "Learn about OAuth 2");
        southPanel.add(oAuthDocumentationLink);
        southPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, CARD_BORDER_COLOR));
        this.setBackgroundColorOnPanel(southPanel);
        this.formPanel.add((Component)centerPanel, "Center");
        this.formPanel.add((Component)southPanel, "South");
        this.setBorderOnPanel(this.formPanel);
    }

    private void populateOAuth2Form(SimpleBindingForm oAuth2Form) {
        this.initForm(oAuth2Form);
        oAuth2Form.addSpace(10);
        JTextField accessTokenField = this.createAccessTokenField();
        JLabel accessTokenStatusIcon = this.createAccessTokenStatusIcon();
        JLabel accessTokenStatusText = this.createAccessTokenStatusText();
        final JButton refreshAccessTokenButton = this.createRefreshButton();
        JPanel accessTokenRowPanel = this.createAccessTokenRowPanel(accessTokenField, accessTokenStatusIcon, accessTokenStatusText, refreshAccessTokenButton);
        oAuth2Form.append(ACCESS_TOKEN_LABEL, accessTokenRowPanel);
        oAuth2Form.addInputFieldHintText("Enter existing access token, or use \"Get Token\" below.");
        this.disclosureButton = new JLabel(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-open.png"));
        this.disclosureButton.setName("oAuth2DisclosureButton");
        oAuth2Form.addComponentWithoutLabel(this.disclosureButton);
        this.accessTokenForm = new OAuth2GetAccessTokenForm(this.profile);
        JDialog accessTokenFormDialog = this.accessTokenForm.getComponent();
        this.disclosureButton.addMouseListener(new DisclosureButtonMouseListener(accessTokenFormDialog, this.disclosureButton));
        accessTokenFormDialog.addWindowFocusListener(new AccessTokenFormDialogWindowListener(accessTokenFormDialog));
        JButton advancedOptionsButton = oAuth2Form.addButtonWithoutLabelToTheRight(ADVANCED_OPTIONS_BUTTON_NAME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OAuth2AdvancedOptionsDialog(OAuth2Form.this.profile, refreshAccessTokenButton);
            }
        });
        advancedOptionsButton.setName(ADVANCED_OPTIONS_BUTTON_NAME);
        this.mainWindowFocusListener = new SoapUIMainWindowFocusListener(accessTokenFormDialog);
        SoapUI.getFrame().addWindowFocusListener(this.mainWindowFocusListener);
    }

    private JTextField createAccessTokenField() {
        this.accessTokenField = new JTextField();
        this.accessTokenField.setName("accessToken");
        this.accessTokenField.setColumns(30);
        this.accessTokenField.setMargin(ACCESS_TOKEN_FIELD_INSETS);
        Bindings.bind((JTextField)this.accessTokenField, (ValueModel)this.oAuth2Form.getPresentationModel().getModel("accessToken"));
        return this.accessTokenField;
    }

    private JLabel createAccessTokenStatusIcon() {
        this.accessTokenStatusIcon = new JLabel();
        this.accessTokenStatusIcon.setVisible(false);
        return this.accessTokenStatusIcon;
    }

    private JLabel createAccessTokenStatusText() {
        this.accessTokenStatusText = new JLabel();
        this.accessTokenStatusText.setFont(this.scaledFont(this.accessTokenStatusText, 0.95f));
        this.accessTokenStatusText.setVisible(false);
        this.accessTokenStatusText.setAlignmentX(0.5f);
        return this.accessTokenStatusText;
    }

    private JButton createRefreshButton() {
        JButton refreshAccessTokenButton = new JButton("Refresh");
        refreshAccessTokenButton.setName(REFRESH_ACCESS_TOKEN_BUTTON_NAME);
        refreshAccessTokenButton.addActionListener(new RefreshOAuthAccessTokenAction(this.profile));
        boolean enabled = this.profile.getRefreshAccessTokenMethod().equals((Object)OAuth2Profile.RefreshAccessTokenMethods.MANUAL) && !StringUtils.isNullOrEmpty(this.profile.getRefreshToken());
        refreshAccessTokenButton.setVisible(enabled);
        return refreshAccessTokenButton;
    }

    private JPanel createAccessTokenRowPanel(JTextField accessTokenField, JLabel accessTokenStatusIcon, JLabel accessTokenStatusText, JButton refreshAccessTokenButton) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(CARD_BACKGROUND_COLOR);
        panel.add(accessTokenField);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        panel.add(accessTokenStatusIcon);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        panel.add(accessTokenStatusText);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        panel.add(refreshAccessTokenButton);
        return panel;
    }

    private Font scaledFont(JComponent component, float scale) {
        Font currentFont = component.getFont();
        return currentFont.deriveFont((float)currentFont.getSize() * scale);
    }

    private String setWrappedText(String text) {
        return String.format("<html><div WIDTH=%d>%s</div><html>", 100, text);
    }

    private void setAccessTokenFormDialogBoundsBelowTheButton(Point disclosureButtonLocation, JDialog accessTokenFormDialog, int disclosureButtonHeight) {
        accessTokenFormDialog.setLocation((int)disclosureButtonLocation.getX() - 120, (int)disclosureButtonLocation.getY() + disclosureButtonHeight);
    }

    private void setAccessTokenFormDialogBoundsAboveTheButton(Point disclosureButtonLocation, JDialog accessTokenFormDialog) {
        accessTokenFormDialog.setLocation((int)disclosureButtonLocation.getX() - 120, (int)disclosureButtonLocation.getY() - accessTokenFormDialog.getHeight());
    }

    private void setAccessTokenStatusFeedback(OAuth2Profile.AccessTokenStatus status) {
        switch (status) {
            case UNKNOWN: {
                this.setDefaultFeedback();
                break;
            }
            case ENTERED_MANUALLY: {
                this.setEnteredManuallyFeedback(status);
                break;
            }
            case RETRIEVED_FROM_SERVER: {
                this.setSucessfulFeedback(status);
                break;
            }
            case RETRIEVAL_CANCELED: {
                this.setCanceledFeedback();
                break;
            }
            case EXPIRED: {
                this.setFailedFeedback(status);
            }
        }
    }

    private void setEnteredManuallyFeedback(OAuth2Profile.AccessTokenStatus status) {
        this.accessTokenField.setBackground(this.DEFAULT_COLOR);
        this.accessTokenStatusIcon.setIcon(null);
        this.accessTokenStatusIcon.setVisible(false);
        this.accessTokenStatusText.setText("");
        this.accessTokenStatusText.setVisible(false);
        this.disclosureButton.setText(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setSucessfulFeedback(OAuth2Profile.AccessTokenStatus status) {
        this.accessTokenField.setBackground(this.SUCCESS_COLOR);
        this.accessTokenStatusIcon.setIcon(SUCCESS_ICON);
        this.accessTokenStatusIcon.setVisible(true);
        this.accessTokenStatusText.setText(this.setWrappedText(status.toString()));
        this.accessTokenStatusText.setVisible(true);
        this.disclosureButton.setText(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setFailedFeedback(OAuth2Profile.AccessTokenStatus status) {
        this.accessTokenField.setBackground(this.FAIL_COLOR);
        this.accessTokenStatusIcon.setIcon(FAIL_ICON);
        this.accessTokenStatusIcon.setVisible(true);
        this.accessTokenStatusText.setText(this.setWrappedText(status.toString()));
        this.accessTokenStatusText.setVisible(true);
        this.disclosureButton.setText(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.inspector.setIcon(FAIL_ICON);
    }

    private void setCanceledFeedback() {
        this.setAccessTokenStatusFeedback(this.profile.getAccessTokenStartingStatus());
        this.disclosureButton.setText(GET_ACCESS_TOKEN_BUTTON_RESUME_LABEL);
    }

    private void setDefaultFeedback() {
        this.accessTokenField.setBackground(this.DEFAULT_COLOR);
        this.accessTokenStatusIcon.setIcon(null);
        this.accessTokenStatusIcon.setVisible(false);
        this.accessTokenStatusText.setText("");
        this.accessTokenStatusText.setVisible(false);
        this.disclosureButton.setText(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void hideAccessTokenFormDialogAndEnableDisclosureButton(JDialog accessTokenFormDialog) {
        accessTokenFormDialog.setVisible(false);
        this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-open.png"));
        if (!this.isMouseOnDisclosureLabel) {
            this.disclosureButtonDisabled = false;
        }
    }

    private class SoapUIMainWindowFocusListener
    extends WindowAdapter {
        private final JDialog accessTokenFormDialog;

        public SoapUIMainWindowFocusListener(JDialog accessTokenFormDialog) {
            this.accessTokenFormDialog = accessTokenFormDialog;
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            if (this.accessTokenFormDialog.isVisible()) {
                OAuth2Form.this.hideAccessTokenFormDialogAndEnableDisclosureButton(this.accessTokenFormDialog);
            }
        }
    }

    private class DisclosureButtonMouseListener
    extends MouseAdapter {
        private final JDialog accessTokenFormDialog;
        private final JLabel disclosureButton;

        public DisclosureButtonMouseListener(JDialog accessTokenFormDialog, JLabel disclosureButton) {
            this.accessTokenFormDialog = accessTokenFormDialog;
            this.disclosureButton = disclosureButton;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OAuth2Form.this.disclosureButtonDisabled) {
                OAuth2Form.this.disclosureButtonDisabled = false;
                return;
            }
            JLabel source = (JLabel)e.getSource();
            Point disclosureButtonLocation = source.getLocationOnScreen();
            this.accessTokenFormDialog.pack();
            this.accessTokenFormDialog.setVisible(true);
            this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-close.png"));
            if (UISupport.isEnoughSpaceAvailableBelowComponent(disclosureButtonLocation, this.accessTokenFormDialog.getHeight(), source.getHeight())) {
                OAuth2Form.this.setAccessTokenFormDialogBoundsBelowTheButton(disclosureButtonLocation, this.accessTokenFormDialog, source.getHeight());
            } else {
                OAuth2Form.this.setAccessTokenFormDialogBoundsAboveTheButton(disclosureButtonLocation, this.accessTokenFormDialog);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            OAuth2Form.this.isMouseOnDisclosureLabel = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            OAuth2Form.this.isMouseOnDisclosureLabel = false;
        }
    }

    private class AccessTokenFormDialogWindowListener
    implements WindowFocusListener {
        private final JDialog accessTokenFormDialog;

        public AccessTokenFormDialogWindowListener(JDialog accessTokenFormDialog) {
            this.accessTokenFormDialog = accessTokenFormDialog;
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            OAuth2Form.this.disclosureButtonDisabled = true;
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            if (this.isMouseOnComponent(SoapUI.getFrame()) && !this.isMouseOnComponent(this.accessTokenFormDialog)) {
                OAuth2Form.this.hideAccessTokenFormDialogAndEnableDisclosureButton(this.accessTokenFormDialog);
            }
        }

        private boolean isMouseOnComponent(Component component) {
            if (!component.isShowing()) {
                return false;
            }
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            Point componentLocationOnScreen = component.getLocationOnScreen();
            return component.contains(mouseLocation.x - componentLocationOnScreen.x, mouseLocation.y - componentLocationOnScreen.y);
        }
    }
}

