/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.impl.rest.actions.oauth.GetOAuth1TokenAction;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.components.PropertyComponent;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1TokenStatusChangeListener;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1TokenStatusChangeManager;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth2Form;
import com.jgoodies.binding.PresentationModel;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class OAuth1GetTokenForm
implements OAuth1TokenStatusChangeListener {
    protected static final String GET_ACCESS_TOKEN_FORM_LAYOUT = "7dlu:none,left:pref,10dlu,left:pref,10dlu,left:MAX(112dlu;pref),7dlu";
    protected static final Color CARD_BORDER_COLOR = new Color(121, 121, 121);
    static final ImageIcon DEFAULT_ICON = null;
    private static final MessageSupport messages = MessageSupport.getMessages(OAuth1GetTokenForm.class);
    public static final String CONSUMER_KEY_TITLE = messages.get("OAuth1GetTokenForm.ConsumerKey.Title");
    public static final String CONSUMER_SECRET_TITLE = messages.get("OAuth1GetTokenForm.ConsumerSecret.Title");
    public static final String TEMPORARY_TOKEN_URI_TITLE = messages.get("OAuth1GetTokenForm.TemporaryTokenURI.Title");
    public static final String ACCESS_TOKEN_URI_TITLE = messages.get("OAuth1GetTokenForm.AccessTokenURI.Title");
    public static final String AUTHORIZATION_URI_TITLE = messages.get("OAuth1GetTokenForm.AuthorizationURI.Title");
    public static final String REDIRECT_URI_TITLE = messages.get("OAuth1GetTokenForm.RedirectURI.Title");
    private static final String DIALOG_DESCRIPTION = messages.get("OAuth1GetTokenForm.RedirectURI.Description");
    private static final int GROUP_SPACING = 20;
    private static final int BOARDER_SPACING = 15;
    private static final int NORMAL_SPACING = 10;
    private static final String ACCESS_TOKEN_FORM_DIALOG_NAME = "getAccessTokenFormDialog";
    private static final String GET_ACCESS_TOKEN_BUTTON_NAME = "getAccessTokenButtonName";
    private static final String GET_ACCESS_BUTTON_LABEL = messages.get("OAuth1GetTokenForm.GetButton.Title");
    protected JLabel accessTokenStatusText;
    protected JDialog accessTokenDialog;
    protected OAuth1Profile profile;
    protected OAuth1TokenStatusChangeManager statusChangeManager;

    public OAuth1GetTokenForm(OAuth1Profile profile) {
        this.profile = profile;
    }

    @Override
    public void onAccessTokenStatusChanged(@Nonnull AccessTokenStatusConfig.Enum status) {
        this.setOAuth1StatusFeedback(status);
    }

    @Override
    public void onTokenSecretStatusChanged(@Nonnull AccessTokenStatusConfig.Enum status) {
        this.setOAuth1StatusFeedback(status);
    }

    @Override
    @Nonnull
    public OAuth1Profile getProfile() {
        return this.profile;
    }

    protected void closeGetAccessTokenDialog() {
        if (this.accessTokenDialog != null) {
            this.accessTokenDialog.setVisible(false);
            this.accessTokenDialog.dispose();
        }
    }

    protected void initStatusChangeManager() {
        this.statusChangeManager = new OAuth1TokenStatusChangeManager(this);
        this.statusChangeManager.register();
    }

    protected void initTokenStatus() {
        if (this.profile.getAccessTokenStatus() != AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.profile.resetAccessTokenStatusToStartingStatus();
        }
        if (this.profile.getTokenSecretStatus() != AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.profile.resetTokenSecretStatusToStartingStatus();
        }
    }

    void release() {
        this.statusChangeManager.unregister();
    }

    public JDialog getComponent() {
        this.initStatusChangeManager();
        SimpleBindingForm accessTokenForm = this.createSimpleBindingForm(this.getProfile());
        this.populateGetAccessTokenForm(accessTokenForm);
        this.initTokenStatus();
        this.setOAuth1StatusFeedback(this.getTokenStatus());
        this.accessTokenDialog = this.createGetAccessTokenDialog(accessTokenForm.getPanel());
        return this.accessTokenDialog;
    }

    protected AccessTokenStatusConfig.Enum getTokenStatus() {
        return this.profile.getAccessTokenStatus();
    }

    protected void populateGetAccessTokenForm(SimpleBindingForm accessTokenForm) {
        accessTokenForm.addSpace(15);
        accessTokenForm.appendHeading(DIALOG_DESCRIPTION);
        accessTokenForm.addSpace(10);
        accessTokenForm.appendTextField("consumerKey", CONSUMER_KEY_TITLE, "");
        this.appendClientSecretField(accessTokenForm);
        accessTokenForm.addSpace(20);
        accessTokenForm.appendTextField("temporaryTokenURI", TEMPORARY_TOKEN_URI_TITLE, "");
        accessTokenForm.appendTextField("authorizationURI", AUTHORIZATION_URI_TITLE, "");
        this.appendAccessTokenUriField(accessTokenForm);
        accessTokenForm.appendTextField("redirectURI", REDIRECT_URI_TITLE, "");
        accessTokenForm.addSpace(20);
        accessTokenForm.appendComponentsInOneRow(this.createGetAccessTokenButton(), this.createAccessTokenStatusText());
        accessTokenForm.addSpace(20);
        accessTokenForm.addSpace(15);
    }

    private JTextField appendClientSecretField(SimpleBindingForm accessTokenForm) {
        JTextField clientSecretField = accessTokenForm.appendTextField("consumerSecret", CONSUMER_SECRET_TITLE, "");
        return clientSecretField;
    }

    private JTextField appendAccessTokenUriField(SimpleBindingForm accessTokenForm) {
        JTextField accessTokenUriField = accessTokenForm.appendTextField("accessTokenURI", ACCESS_TOKEN_URI_TITLE, "");
        return accessTokenUriField;
    }

    protected PropertyComponent createGetAccessTokenButton() {
        JButton getAccessTokenButton = new JButton(new GetOAuth1TokenAction(this.profile, GET_ACCESS_BUTTON_LABEL));
        getAccessTokenButton.setName(GET_ACCESS_TOKEN_BUTTON_NAME);
        return new PropertyComponent(getAccessTokenButton);
    }

    private PropertyComponent createAccessTokenStatusText() {
        this.accessTokenStatusText = new JLabel();
        return new PropertyComponent(this.accessTokenStatusText);
    }

    private JDialog createGetAccessTokenDialog(JPanel accessTokenFormPanel) {
        JDialog accessTokenFormDialog = new JDialog();
        accessTokenFormDialog.setName(this.getFormDialogName());
        accessTokenFormDialog.setTitle(this.getFormDialogTitle());
        accessTokenFormDialog.setIconImages(SoapUI.getFrameIcons());
        accessTokenFormDialog.setUndecorated(true);
        accessTokenFormDialog.getContentPane().add(accessTokenFormPanel);
        return accessTokenFormDialog;
    }

    private SimpleBindingForm createSimpleBindingForm(OAuth1Profile profile) {
        PresentationModel presentationModel = new PresentationModel((Object)profile);
        String columnsSpecs = GET_ACCESS_TOKEN_FORM_LAYOUT;
        Border border = BorderFactory.createLineBorder(CARD_BORDER_COLOR, 1);
        return new SimpleBindingForm(presentationModel, columnsSpecs, border);
    }

    private String getFormDialogName() {
        return ACCESS_TOKEN_FORM_DIALOG_NAME;
    }

    private String getFormDialogTitle() {
        return messages.get("OAuth1GetTokenForm.Dialog.Title");
    }

    private void setOAuth1StatusFeedback(AccessTokenStatusConfig.Enum status) {
        if (status == null) {
            this.setDefaultFeedback();
        } else if (status == AccessTokenStatusConfig.WAITING_FOR_AUTHORIZATION || status == AccessTokenStatusConfig.RECEIVED_AUTHORIZATION_CODE) {
            this.setWaitingFeedback();
        } else if (status == AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.setCanceledFeedback();
        } else if (status == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER) {
            this.setSuccessfulFeedback();
        } else if (status == AccessTokenStatusConfig.ENTERED_MANUALLY) {
            this.setEnteredManuallyFeedback();
        } else {
            this.setDefaultFeedback();
        }
    }

    private void setCanceledFeedback() {
        this.accessTokenStatusText.setText(messages.get("OAuth1GetTokenForm.CancelledFeedback"));
        this.accessTokenStatusText.setIcon(OAuth2Form.FAIL_ICON);
    }

    private void setWaitingFeedback() {
        this.accessTokenStatusText.setText(messages.get("OAuth1GetTokenForm.WaitingFeedback"));
        this.accessTokenStatusText.setIcon(OAuth2Form.WAIT_ICON);
    }

    private void setDefaultFeedback() {
        this.accessTokenStatusText.setText("");
        this.accessTokenStatusText.setIcon(DEFAULT_ICON);
    }

    private void setEnteredManuallyFeedback() {
        this.accessTokenStatusText.setText(messages.get("OAuth1GetTokenForm.EnteredManuallyFeedback"));
        this.accessTokenStatusText.setIcon(DEFAULT_ICON);
    }

    private void setSuccessfulFeedback() {
        this.accessTokenStatusText.setText(messages.get("OAuth1GetTokenForm.RetrievedFeedback"));
        this.accessTokenStatusText.setIcon(OAuth2Form.SUCCESS_ICON);
    }
}

