/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.PropertyChangeNotifier;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.swing.JTableFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.PropertyUtils;
import org.jdesktop.swingx.JXTable;

public class JDebugPropertiesTable<T> {
    public static final Object[] BOOLEAN_OPTIONS = new Object[]{Boolean.TRUE, Boolean.FALSE};
    private PropertiesTableModel<T> tableModel;
    private JXTable table;

    public JDebugPropertiesTable(T propertyObject) {
        this.tableModel = new PropertiesTableModel<T>(propertyObject);
        this.table = new PTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Property");
        this.table.getColumnModel().getColumn(1).setHeaderValue("Value");
        this.table.getColumnModel().getColumn(0).setCellRenderer(new PropertiesTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new PropertiesTableCellRenderer());
        this.table.setBackground(Color.WHITE);
    }

    public void removeNotify() {
        this.getTableModel().release();
        this.table.removeNotify();
    }

    public void addNotify() {
        this.getTableModel().attach();
        this.table.addNotify();
    }

    public void setPropertyObject(T propertyObject) {
        this.tableModel.setPropertyObject(propertyObject);
    }

    public PropertiesTableModel<?> getTableModel() {
        return this.tableModel;
    }

    public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name) {
        return this.addProperty(caption, name, false);
    }

    public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name, boolean editable) {
        return this.addProperty(caption, name, editable, null);
    }

    public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name, boolean editable, JPropertiesTable.PropertyFormatter formatter) {
        return this.tableModel.addProperty(caption, name, editable, formatter);
    }

    public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name, Object[] options) {
        return this.tableModel.addProperty(caption, name, options);
    }

    public JPropertiesTable.PropertyDescriptor addPropertyShadow(String caption, String name, boolean editable) {
        return this.tableModel.addPropertyShadow(caption, name, editable);
    }

    public JTable getTable() {
        return this.table;
    }

    public static final class PropertiesTableModel<T>
    extends AbstractTableModel
    implements PropertyChangeListener {
        private List<JPropertiesTable.PropertyDescriptor> properties = new ArrayList<JPropertiesTable.PropertyDescriptor>();
        private T propertyObject;
        private boolean attached;

        public PropertiesTableModel(T propertyObject) {
            this.propertyObject = propertyObject;
        }

        public void attach() {
            if (!this.attached && this.propertyObject instanceof PropertyChangeNotifier) {
                ((PropertyChangeNotifier)this.propertyObject).addPropertyChangeListener(this);
                this.attached = true;
            }
        }

        public void setPropertyObject(T propertyObject) {
            this.release();
            this.propertyObject = propertyObject;
            this.attach();
            this.fireTableDataChanged();
        }

        public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name, boolean editable, JPropertiesTable.PropertyFormatter formatter) {
            JPropertiesTable.PropertyDescriptor propertyDescriptor = new JPropertiesTable.PropertyDescriptor(caption, name, editable, formatter);
            this.properties.add(propertyDescriptor);
            return propertyDescriptor;
        }

        public JPropertiesTable.PropertyDescriptor addProperty(String caption, String name, Object[] options) {
            JPropertiesTable.PropertyDescriptor propertyDescriptor = new JPropertiesTable.PropertyDescriptor(caption, name, options);
            this.properties.add(propertyDescriptor);
            this.fireTableStructureChanged();
            return propertyDescriptor;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.propertyObject == null) {
                return null;
            }
            try {
                JPropertiesTable.PropertyDescriptor propertyDescriptor = this.properties.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return propertyDescriptor.getCaption();
                    }
                    case 1: {
                        Object value = PropertyUtils.getSimpleProperty(this.propertyObject, (String)propertyDescriptor.getName());
                        return propertyDescriptor.getFormatter().format(propertyDescriptor.getName(), value);
                    }
                }
            }
            catch (IllegalAccessException e) {
                SoapUI.logError(e);
            }
            catch (InvocationTargetException e) {
                SoapUI.logError(e);
            }
            catch (NoSuchMethodException e) {
                SoapUI.logError(e);
            }
            return null;
        }

        public JPropertiesTable.PropertyDescriptor getPropertyDescriptorAt(int row) {
            return this.properties.get(row);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireTableDataChanged();
        }

        public void release() {
            if (this.propertyObject instanceof PropertyChangeNotifier && this.attached) {
                ((PropertyChangeNotifier)this.propertyObject).removePropertyChangeListener(this);
                this.attached = false;
            }
        }

        public JPropertiesTable.PropertyDescriptor addPropertyShadow(String caption, String name, boolean editable) {
            JPropertiesTable.PropertyDescriptor propertyDescriptor = new JPropertiesTable.PropertyDescriptor(caption, name, editable);
            this.properties.add(propertyDescriptor);
            return propertyDescriptor;
        }
    }

    private class PTable
    extends JXTable {
        public PTable(TableModel tableModel) {
            super(tableModel);
            if (UISupport.isMac()) {
                JTableFactory.setGridAttributes((JTable)((Object)this));
            }
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return super.getCellEditor(row, column);
            }
            return JDebugPropertiesTable.this.tableModel.getPropertyDescriptorAt(row).getCellEditor();
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component defaultRenderer = super.prepareRenderer(renderer, row, column);
            JTableFactory.applyStripesToRenderer(row, defaultRenderer);
            return defaultRenderer;
        }

        public boolean getShowVerticalLines() {
            return UISupport.isMac() ? false : super.getShowVerticalLines();
        }
    }

    private class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        private PropertiesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setToolTipText(value.toString());
            Font newLabelFont = new Font(component.getFont().getName(), 1, component.getFont().getSize());
            component.setFont(newLabelFont);
            return component;
        }
    }
}

