/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFormComponent;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DirectoryFormComponent
extends JPanel
implements JFormComponent {
    private JTextField textField;
    private String initialFolder;

    public DirectoryFormComponent(String tooltip) {
        ButtonBarBuilder builder = new ButtonBarBuilder((JPanel)this);
        this.textField = new JTextField(30);
        this.textField.setToolTipText(tooltip);
        builder.addGriddedGrowing((JComponent)this.textField);
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new SelectDirectoryAction()));
    }

    @Override
    public void setValue(String value) {
        this.textField.setText(value);
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    public JTextComponent getTextField() {
        return this.textField;
    }

    public void setInitialFolder(String initialFolder) {
        this.initialFolder = initialFolder;
    }

    public class SelectDirectoryAction
    extends AbstractAction {
        public SelectDirectoryAction() {
            super("Browse...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            File currentDirectory;
            File file2 = currentDirectory = StringUtils.hasContent(DirectoryFormComponent.this.initialFolder) ? new File(DirectoryFormComponent.this.initialFolder) : null;
            if (DirectoryFormComponent.this.textField.getText().length() > 0) {
                currentDirectory = new File(DirectoryFormComponent.this.textField.getText());
            }
            if ((file = UISupport.getFileDialogs().openDirectory(this, "Select directory", currentDirectory)) != null) {
                DirectoryFormComponent.this.textField.setText(file.getAbsolutePath());
            }
        }
    }
}

