/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateObjectSerializer
extends JsonSerializer<Date> {
    private static final Logger log = LoggerFactory.getLogger(DateObjectSerializer.class);
    private Set<String> exclusions = Sets.newHashSet((Object[])new String[]{"metaClass", "class", "declaringClass"});

    public void serialize(Date date, JsonGenerator gen, SerializerProvider provider) throws IOException {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)date);
        gen.writeStartObject();
        Arrays.stream(propertyDescriptors).forEach(propertyDescriptor -> {
            try {
                String name = propertyDescriptor.getName();
                if (!this.exclusions.contains(name)) {
                    Object value = PropertyUtils.getProperty((Object)date, (String)name);
                    if (value instanceof Integer) {
                        gen.writeNumberField(name, ((Integer)value).intValue());
                    } else {
                        gen.writeNumberField(name, ((Long)value).longValue());
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        });
        gen.writeEndObject();
    }

    public Class<Date> handledType() {
        return Date.class;
    }
}

