/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ProgressBarSecurityTestStepAdapter {
    private JProgressBar progressBar;
    private TestStep testStep;
    private SecurityTest securityTest;
    private InternalTestRunListener internalTestRunListener;
    private JTree tree;
    private DefaultMutableTreeNode node;
    private JLabel counterLabel;
    private static final Color OK_COLOR = new Color(0, 204, 102);
    private static final Color FAILED_COLOR = new Color(255, 102, 0);
    private static final Color MISSING_ASSERTION_COLOR = new Color(204, 153, 255);
    private static final Color UNKNOWN_COLOR = new Color(240, 240, 240);
    private static final String STATE_RUN = "In progress";
    private static final String STATE_DONE = "Done";
    private static final String STATE_CANCEL = "Canceled";
    private static final String STATE_MISSING_ASSERTIONS = "Missing Assertions";
    private static final String STATE_MISSING_PARAMETERS = "Missing Parameters";

    public ProgressBarSecurityTestStepAdapter(JTree tree, DefaultMutableTreeNode node, JProgressBar progressBar, SecurityTest securityTest, WsdlTestStep testStep, JLabel cntLabel) {
        this.tree = tree;
        this.node = node;
        this.progressBar = progressBar;
        this.testStep = testStep;
        this.securityTest = securityTest;
        this.counterLabel = cntLabel;
        this.internalTestRunListener = new InternalTestRunListener();
        if (progressBar != null && cntLabel != null) {
            this.counterLabel.setPreferredSize(new Dimension(50, 18));
            this.counterLabel.setHorizontalTextPosition(0);
            this.counterLabel.setHorizontalAlignment(0);
            this.securityTest.addSecurityTestRunListener(this.internalTestRunListener);
        }
    }

    public void release() {
        this.securityTest.removeSecurityTestRunListener(this.internalTestRunListener);
        this.securityTest = null;
        this.testStep = null;
    }

    public class InternalTestRunListener
    extends SecurityTestRunListenerAdapter {
        private int totalAlertsCounter;

        @Override
        public void beforeStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, TestStepResult tsr) {
            if (tsr.getTestStep().getId().equals(ProgressBarSecurityTestStepAdapter.this.testStep.getId())) {
                int count = ProgressBarSecurityTestStepAdapter.this.securityTest.getStepSecurityApplicableScansCount(tsr);
                ProgressBarSecurityTestStepAdapter.this.progressBar.getModel().setMaximum(count);
                if (ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityScansMap().get(ProgressBarSecurityTestStepAdapter.this.testStep.getId()) != null && ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityScansMap().get(ProgressBarSecurityTestStepAdapter.this.testStep.getId()).size() > 0) {
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_RUN);
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(OK_COLOR);
                }
                ProgressBarSecurityTestStepAdapter.this.progressBar.setBackground(Color.white);
                ProgressBarSecurityTestStepAdapter.this.progressBar.setValue(0);
                ProgressBarSecurityTestStepAdapter.this.counterLabel.setText("");
                ProgressBarSecurityTestStepAdapter.this.counterLabel.setOpaque(false);
                ((DefaultTreeModel)ProgressBarSecurityTestStepAdapter.this.tree.getModel()).nodeChanged(ProgressBarSecurityTestStepAdapter.this.node);
            }
        }

        @Override
        public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            ProgressBarSecurityTestStepAdapter.this.progressBar.setString("");
            ProgressBarSecurityTestStepAdapter.this.progressBar.setValue(0);
            ProgressBarSecurityTestStepAdapter.this.counterLabel.setText("");
            ProgressBarSecurityTestStepAdapter.this.counterLabel.setOpaque(false);
            this.totalAlertsCounter = 0;
            ((DefaultTreeModel)ProgressBarSecurityTestStepAdapter.this.tree.getModel()).nodeChanged(ProgressBarSecurityTestStepAdapter.this.node);
            if (ProgressBarSecurityTestStepAdapter.this.progressBar != null) {
                ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(UNKNOWN_COLOR);
                ProgressBarSecurityTestStepAdapter.this.progressBar.setBackground(UNKNOWN_COLOR);
            }
        }

        @Override
        public void afterStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
            if (runContext.getCurrentStep().getId().equals(ProgressBarSecurityTestStepAdapter.this.testStep.getId())) {
                if (!(ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestStepAdapter.STATE_CANCEL) || ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestStepAdapter.STATE_MISSING_ASSERTIONS) || ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestStepAdapter.STATE_MISSING_PARAMETERS) || ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityTestStepResultMap().get(ProgressBarSecurityTestStepAdapter.this.testStep) == null)) {
                    SecurityTestStepResult results = ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityTestStepResultMap().get(ProgressBarSecurityTestStepAdapter.this.testStep);
                    boolean skipped = results.getSecurityScanResultList().size() > 0;
                    for (SecurityScanResult res : results.getSecurityScanResultList()) {
                        if (res.getStatus() == SecurityResult.ResultStatus.SKIPPED) continue;
                        skipped = false;
                        break;
                    }
                    if (skipped) {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setString("SKIPPED");
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(UNKNOWN_COLOR);
                    } else {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_DONE);
                    }
                }
            } else {
                ProgressBarSecurityTestStepAdapter.this.progressBar.setBackground(UNKNOWN_COLOR);
            }
            ProgressBarSecurityTestStepAdapter.this.progressBar.setValue(ProgressBarSecurityTestStepAdapter.this.progressBar.getMaximum() == 0 ? 1 : ProgressBarSecurityTestStepAdapter.this.progressBar.getMaximum());
            ((DefaultTreeModel)ProgressBarSecurityTestStepAdapter.this.tree.getModel()).nodeChanged(ProgressBarSecurityTestStepAdapter.this.node);
        }

        @Override
        public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityScan) {
            if (securityScan.getTestStep().getId().equals(ProgressBarSecurityTestStepAdapter.this.testStep.getId())) {
                if (securityScan.getSecurityScanResult() != null && securityScan.getSecurityScanResult().getStatus() != SecurityResult.ResultStatus.CANCELED && ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals("") && ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityScansMap().get(ProgressBarSecurityTestStepAdapter.this.testStep.getId()) != null && ProgressBarSecurityTestStepAdapter.this.securityTest.getSecurityScansMap().get(ProgressBarSecurityTestStepAdapter.this.testStep.getId()).size() > 0) {
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_RUN);
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(OK_COLOR);
                }
                if (securityScan.getAssertionCount() == 0) {
                    if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                    }
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_MISSING_ASSERTIONS);
                }
                if (securityScan instanceof AbstractSecurityScanWithProperties && ((AbstractSecurityScanWithProperties)securityScan).getParameterHolder().getParameterList().size() == 0) {
                    if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                    }
                    if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestStepAdapter.STATE_MISSING_ASSERTIONS)) {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_MISSING_PARAMETERS);
                    }
                }
            }
        }

        @Override
        public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityCheckResult) {
            if (securityCheckResult.getSecurityScan().getTestStep().getId().equals(ProgressBarSecurityTestStepAdapter.this.testStep.getId())) {
                if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.CANCELED) {
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_CANCEL);
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setBackground(UNKNOWN_COLOR);
                } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                    ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(FAILED_COLOR);
                } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.OK) {
                    SecurityScan securityScan = securityCheckResult.getSecurityScan();
                    if (securityScan.getAssertionCount() == 0) {
                        if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                            ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                        }
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_MISSING_ASSERTIONS);
                    }
                    if (securityScan instanceof AbstractSecurityScanWithProperties && ((AbstractSecurityScanWithProperties)securityScan).getParameterHolder().getParameterList().size() == 0) {
                        if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                            ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(MISSING_ASSERTION_COLOR);
                        }
                        if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestStepAdapter.STATE_MISSING_ASSERTIONS)) {
                            ProgressBarSecurityTestStepAdapter.this.progressBar.setString(ProgressBarSecurityTestStepAdapter.STATE_MISSING_PARAMETERS);
                        }
                    }
                    if (!ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(FAILED_COLOR) && !ProgressBarSecurityTestStepAdapter.this.progressBar.getForeground().equals(MISSING_ASSERTION_COLOR)) {
                        ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(OK_COLOR);
                    }
                }
                ProgressBarSecurityTestStepAdapter.this.progressBar.setValue(runContext.getCurrentScanIndex() + 1);
                ((DefaultTreeModel)ProgressBarSecurityTestStepAdapter.this.tree.getModel()).nodeChanged(ProgressBarSecurityTestStepAdapter.this.node);
            }
        }

        @Override
        public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityCheckReqResult) {
            if (securityCheckReqResult.getSecurityScan().getTestStep().getId().equals(ProgressBarSecurityTestStepAdapter.this.testStep.getId()) && securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                ProgressBarSecurityTestStepAdapter.this.counterLabel.setOpaque(true);
                ProgressBarSecurityTestStepAdapter.this.counterLabel.setBackground(FAILED_COLOR);
                ++this.totalAlertsCounter;
                ProgressBarSecurityTestStepAdapter.this.counterLabel.setText(" " + this.totalAlertsCounter + " ");
                ((DefaultTreeModel)ProgressBarSecurityTestStepAdapter.this.tree.getModel()).nodeChanged(ProgressBarSecurityTestStepAdapter.this.node);
                ProgressBarSecurityTestStepAdapter.this.progressBar.setForeground(FAILED_COLOR);
            }
        }
    }
}

