/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.SensitiveInformationConfig;
import com.eviware.soapui.model.security.SensitiveInformationTableModel;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.SensitiveInformationPropertyHolder;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.JTableFactory;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.xmlbeans.XmlObject;
import org.jdesktop.swingx.JXTable;

public class ProjectSensitiveInformationPanel {
    private JPanel mainpanel;
    private SensitiveInformationConfig config;
    private List<String> projectSpecificExposureList;
    public static final String PROJECT_SPECIFIC_EXPOSURE_LIST = "ProjectSpecificExposureList";
    private SensitiveInformationTableModel sensitiveInformationTableModel;
    private JXTable tokenTable;

    public ProjectSensitiveInformationPanel(ProjectConfig projectConfig) {
        this.config = projectConfig.getSensitiveInformation();
        if (this.config == null) {
            this.config = SensitiveInformationConfig.Factory.newInstance();
            projectConfig.addNewSensitiveInformation();
            projectConfig.setSensitiveInformation(this.config);
        }
        this.init();
    }

    private void init() {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.config);
        this.projectSpecificExposureList = StringUtils.toStringList(reader.readStrings(PROJECT_SPECIFIC_EXPOSURE_LIST));
        this.extractTokenTable();
    }

    private void extractTokenTable() {
        SensitiveInformationPropertyHolder siph = new SensitiveInformationPropertyHolder();
        for (String str : this.projectSpecificExposureList) {
            String[] tokens = str.split("###");
            if (tokens.length == 2) {
                siph.setPropertyValue(tokens[0], tokens[1]);
                continue;
            }
            siph.setPropertyValue(tokens[0], "");
        }
        this.sensitiveInformationTableModel = new SensitiveInformationTableModel(siph, "Sensitive Information Token");
    }

    public Component getMainPanel() {
        if (this.mainpanel == null) {
            this.mainpanel = new JPanel(new BorderLayout());
            JXToolBar toolbar = UISupport.createToolbar();
            toolbar.add(UISupport.createToolbarButton(new AddTokenAction()));
            toolbar.add(UISupport.createToolbarButton(new RemoveTokenAction()));
            this.tokenTable = JTableFactory.getInstance().makeJXTable(this.sensitiveInformationTableModel);
            this.mainpanel.add((Component)toolbar, "North");
            this.mainpanel.add((Component)new JScrollPane((Component)this.tokenTable), "Center");
        }
        return this.mainpanel;
    }

    public void save() {
        this.projectSpecificExposureList = this.createListFromTable();
        this.setConfiguration(this.createConfiguration());
    }

    private List<String> createListFromTable() {
        ArrayList<String> temp = new ArrayList<String>();
        for (TestProperty tp : this.sensitiveInformationTableModel.getHolder().getPropertyList()) {
            String tokenPlusDescription = tp.getName() + "###" + tp.getValue();
            temp.add(tokenPlusDescription);
        }
        return temp;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(PROJECT_SPECIFIC_EXPOSURE_LIST, this.projectSpecificExposureList.toArray(new String[this.projectSpecificExposureList.size()]));
        return builder.finish();
    }

    public void setConfiguration(XmlObject configuration) {
        this.config.set(configuration);
    }

    public void release() {
    }

    class AddTokenAction
    extends AbstractAction {
        public AddTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a token to assertion");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String newToken = "";
            newToken = UISupport.prompt("Enter token", "New Token", newToken);
            String newValue = "";
            newValue = UISupport.prompt("Enter description", "New Description", newValue);
            ProjectSensitiveInformationPanel.this.sensitiveInformationTableModel.addToken(newToken, newValue);
            ProjectSensitiveInformationPanel.this.save();
        }
    }

    class RemoveTokenAction
    extends AbstractAction {
        public RemoveTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes token from assertion");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ProjectSensitiveInformationPanel.this.sensitiveInformationTableModel.removeRows(ProjectSensitiveInformationPanel.this.tokenTable.getSelectedRows());
            ProjectSensitiveInformationPanel.this.save();
        }
    }
}

