/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.log;

import com.eviware.soapui.impl.wsdl.testcase.TestCaseLogItem;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.log.SecurityTestLogModel;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JHyperlinkLabel;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSecurityTestRunLog
extends JPanel {
    private SecurityTestLogModel logListModel;
    private JList testLogList;
    private boolean errorsOnly = false;
    private final Settings settings;
    private Set<String> boldTexts = new HashSet<String>();
    private boolean follow = true;
    protected int selectedIndex;
    private XFormDialog optionsDialog;
    private Logger log = LogManager.getLogger(JSecurityTestRunLog.class);

    public JSecurityTestRunLog(SecurityTest securityTest) {
        super(new BorderLayout());
        this.settings = securityTest.getSettings();
        this.logListModel = new SecurityTestLogModel();
        this.errorsOnly = this.settings.getBoolean(OptionsForm.class.getName() + "@errors_only");
        this.buildUI();
    }

    private void buildUI() {
        this.logListModel = new SecurityTestLogModel();
        this.logListModel.setMaxSize((int)this.settings.getLong(OptionsForm.class.getName() + "@max_rows", 1000L));
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new SecurityTestLogCellRenderer());
        this.testLogList.addMouseListener(new LogListMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.testLogList);
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addToolbarButtons(toolbar);
        return toolbar;
    }

    protected JList getTestLogList() {
        return this.testLogList;
    }

    public boolean isErrorsOnly() {
        return this.errorsOnly;
    }

    public boolean isFollow() {
        return this.follow;
    }

    protected void addToolbarButtons(JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(new ClearLogAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new SetLogOptionsAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new ExportLogAction()));
    }

    public synchronized void clear() {
        this.logListModel.clear();
        this.boldTexts.clear();
    }

    public synchronized void locateSecurityScan(SecurityScan check) {
        try {
            int idx = this.logListModel.getIndexOfSecurityScan(check);
            if (idx != -1) {
                this.testLogList.ensureIndexIsVisible(idx);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public synchronized boolean addSecurityTestStepResult(TestStep testStep) {
        boolean added = this.logListModel.addSecurityTestStepResult(testStep);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage());
            }
        }
        return added;
    }

    public synchronized void updateSecurityTestStepResult(SecurityTestStepResult testStepResult, boolean hasChecksToProcess, boolean startStepLogEntryAdded) {
        this.logListModel.updateSecurityTestStepResult(testStepResult, this.errorsOnly, hasChecksToProcess, startStepLogEntryAdded);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public synchronized void addSecurityScanResult(SecurityScan securityCheck) {
        this.logListModel.addSecurityScanResult(securityCheck);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public synchronized void updateSecurityScanResult(SecurityScanResult checkResult) {
        this.logListModel.updateSecurityScanResult(checkResult, this.errorsOnly);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public synchronized void addSecurityScanRequestResult(SecurityScanRequestResult checkRequestResult) {
        if (this.errorsOnly && checkRequestResult.getStatus() != SecurityResult.ResultStatus.FAILED) {
            return;
        }
        this.logListModel.addSecurityScanRequestResult(checkRequestResult);
        if (this.follow) {
            try {
                this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage());
            }
        }
    }

    public void release() {
        if (this.optionsDialog != null) {
            this.optionsDialog.release();
            this.optionsDialog = null;
        }
    }

    public void printLog(PrintWriter out) {
        for (int c = 0; c < this.logListModel.getSize(); ++c) {
            Object value = this.logListModel.getElementAt(c);
            if (!(value instanceof String)) continue;
            out.println(value.toString());
        }
    }

    public synchronized void addText(String string) {
        this.logListModel.addText(string);
        if (this.follow) {
            this.testLogList.ensureIndexIsVisible(this.logListModel.getSize() - 1);
        }
    }

    @AForm(name="Log Options", description="Set options for the run log below", helpUrl="/Security/security-scans-overview.html")
    private static interface OptionsForm {
        @AField(name="Max Rows", description="Sets the maximum number of rows to keep in the log", type=AField.AFieldType.INT)
        public static final String MAXROWS = "Max Rows";
        @AField(name="Warnings Only", description="Logs only TestStep warnings in the log", type=AField.AFieldType.BOOLEAN)
        public static final String ERRORSONLY = "Warnings Only";
        @AField(name="Follow", description="Follow log content", type=AField.AFieldType.BOOLEAN)
        public static final String FOLLOW = "Follow";
    }

    private final class SecurityTestLogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font boldFont;
        private Font normalFont;
        private JHyperlinkLabel hyperlinkLabel = new JHyperlinkLabel("");

        public SecurityTestLogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setIcon(null);
            this.boldFont = this.getFont().deriveFont(1);
            this.normalFont = this.getFont();
            this.hyperlinkLabel.setOpaque(true);
            this.hyperlinkLabel.setForeground(Color.BLUE.darker().darker().darker());
            this.hyperlinkLabel.setUnderlineColor(Color.GRAY);
            this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof String) {
                this.setText(value.toString());
            } else if (value instanceof TestCaseLogItem) {
                TestCaseLogItem logItem = (TestCaseLogItem)value;
                String msg = logItem.getMsg();
                this.setText(msg == null ? "" : msg);
            }
            SecurityResult result = JSecurityTestRunLog.this.logListModel.getTestStepResultAt(index);
            if (result != null) {
                if (result.getResultType().equals("SecurityScanRequestResult")) {
                    this.hyperlinkLabel.setText(this.getText());
                    this.hyperlinkLabel.setBackground(this.getBackground());
                    this.hyperlinkLabel.setEnabled(list.isEnabled());
                    this.hyperlinkLabel.setUnderlineColor(Color.WHITE);
                    this.hyperlinkLabel.setIcon(null);
                    this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 24, 3, 3));
                } else if (result.getResultType().equals("SecurityScanResult")) {
                    this.hyperlinkLabel.setText(this.getText());
                    this.hyperlinkLabel.setBackground(this.getBackground());
                    this.hyperlinkLabel.setEnabled(list.isEnabled());
                    this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 16, 3, 3));
                    this.hyperlinkLabel.setUnderlineColor(Color.WHITE);
                    this.hyperlinkLabel.setIcon(null);
                    this.hyperlinkLabel.setUnderlineColor(Color.GRAY);
                    this.setStatusIcon(result);
                } else if (result.getResultType().equals("SecurityTestStepResult")) {
                    SecurityTestStepResult securitytestStepresult = (SecurityTestStepResult)result;
                    this.hyperlinkLabel.setText(this.getText());
                    this.hyperlinkLabel.setBackground(this.getBackground());
                    this.hyperlinkLabel.setEnabled(list.isEnabled());
                    this.hyperlinkLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 3, 3));
                    this.hyperlinkLabel.setUnderlineColor(Color.GRAY);
                    this.setStatusIcon(securitytestStepresult);
                }
                return this.hyperlinkLabel;
            }
            this.setEnabled(list.isEnabled());
            if (JSecurityTestRunLog.this.boldTexts.contains(this.getText())) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.normalFont);
            }
            return this;
        }

        private void setStatusIcon(SecurityResult securityResult) {
            if (securityResult.getLogIconStatus() == SecurityResult.ResultStatus.OK) {
                this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
            } else if (securityResult.getLogIconStatus() == SecurityResult.ResultStatus.FAILED) {
                this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
            } else if (securityResult.getLogIconStatus() == SecurityResult.ResultStatus.MISSING_ASSERTIONS || securityResult.getLogIconStatus() == SecurityResult.ResultStatus.MISSING_PARAMETERS) {
                this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/missing_assertion.gif"));
            } else {
                this.hyperlinkLabel.setIcon(UISupport.createImageIcon("/unknown_assertion.png"));
            }
        }
    }

    private final class LogListMouseListener
    extends MouseAdapter {
        private LogListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SecurityResult result;
            int index = JSecurityTestRunLog.this.testLogList.getSelectedIndex();
            if (index != -1 && (index == JSecurityTestRunLog.this.selectedIndex || e.getClickCount() > 1) && (result = JSecurityTestRunLog.this.logListModel.getTestStepResultAt(index)) != null && result.getActions() != null) {
                result.getActions().performDefaultAction(new ActionEvent(this, 0, null));
            }
            JSecurityTestRunLog.this.selectedIndex = index;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            SecurityResult result;
            int row = JSecurityTestRunLog.this.testLogList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            if (JSecurityTestRunLog.this.testLogList.getSelectedIndex() != row) {
                JSecurityTestRunLog.this.testLogList.setSelectedIndex(row);
            }
            if ((result = JSecurityTestRunLog.this.logListModel.getTestStepResultAt(row)) == null) {
                return;
            }
            ActionList actions = result.getActions();
            if (actions == null || actions.getActionCount() == 0) {
                return;
            }
            JPopupMenu popup = ActionSupport.buildPopup(actions);
            UISupport.showPopup(popup, JSecurityTestRunLog.this.testLogList, e.getPoint());
        }
    }

    private class ClearLogAction
    extends AbstractAction {
        public ClearLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear.png"));
            this.putValue("ShortDescription", "Clears the log");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSecurityTestRunLog.this.logListModel.clear();
        }
    }

    private class SetLogOptionsAction
    extends AbstractAction {
        public SetLogOptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/preferences.png"));
            this.putValue("ShortDescription", "Sets TestCase Log Options");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSecurityTestRunLog.this.optionsDialog == null) {
                JSecurityTestRunLog.this.optionsDialog = ADialogBuilder.buildDialog(OptionsForm.class);
            }
            JSecurityTestRunLog.this.optionsDialog.setIntValue("Max Rows", (int)JSecurityTestRunLog.this.settings.getLong(OptionsForm.class.getName() + "@max_rows", 1000L));
            JSecurityTestRunLog.this.optionsDialog.setBooleanValue("Warnings Only", JSecurityTestRunLog.this.settings.getBoolean(OptionsForm.class.getName() + "@errors_only"));
            JSecurityTestRunLog.this.optionsDialog.setBooleanValue("Follow", JSecurityTestRunLog.this.follow);
            if (JSecurityTestRunLog.this.optionsDialog.show()) {
                int maxRows = JSecurityTestRunLog.this.optionsDialog.getIntValue("Max Rows", 1000);
                JSecurityTestRunLog.this.logListModel.setMaxSize(maxRows);
                JSecurityTestRunLog.this.settings.setLong(OptionsForm.class.getName() + "@max_rows", maxRows);
                JSecurityTestRunLog.this.errorsOnly = JSecurityTestRunLog.this.optionsDialog.getBooleanValue("Warnings Only");
                JSecurityTestRunLog.this.settings.setBoolean(OptionsForm.class.getName() + "@errors_only", JSecurityTestRunLog.this.errorsOnly);
                JSecurityTestRunLog.this.follow = JSecurityTestRunLog.this.optionsDialog.getBooleanValue("Follow");
            }
        }
    }

    private class ExportLogAction
    extends AbstractAction {
        public ExportLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/export.png"));
            this.putValue("ShortDescription", "Exports this log to a file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().saveAs(this, "Save Log");
            if (file != null) {
                try {
                    PrintWriter out = new PrintWriter(file);
                    JSecurityTestRunLog.this.printLog(out);
                    out.close();
                }
                catch (FileNotFoundException e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }
}

