/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.config.TestStepSecurityTestConfig;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTestListener;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.registry.SecurityScanFactory;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.support.SecurityTestRunListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;

public class SecurityTest
extends AbstractTestPropertyHolderWsdlModelItem<SecurityTestConfig>
implements TestModelItem,
TestRunnable {
    public static final String STARTUP_SCRIPT_PROPERTY = SecurityTest.class.getName() + "@startupScript";
    public static final String TEARDOWN_SCRIPT_PROPERTY = SecurityTest.class.getName() + "@tearDownScript";
    public static final String FAIL_ON_SCANS_ERRORS_PROPERTY = SecurityTest.class.getName() + "@failOnScansErrors";
    public static final String FAIL_ON_ERROR_PROPERTY = SecurityTest.class.getName() + "@failOnError";
    public static final String SKIP_DATASOURCE_LOOP_PROPERTY = SecurityTest.class.getName() + "@skipDataSourceLoop";
    public static final String ICON_NAME = "/security_test.gif";
    private WsdlTestCase testCase;
    private Set<SecurityTestRunListener> securityTestRunListeners = Collections.synchronizedSet(new HashSet());
    private Map<TestStep, Set<SecurityTestRunListener>> securityTestStepRunListeners = new HashMap<TestStep, Set<SecurityTestRunListener>>();
    private Map<TestStep, SecurityTestStepResult> securityTestStepResultMap;
    private HashMap<String, List<SecurityScan>> securityScansMap = new HashMap();
    private ArrayList<SecurityTestListener> securityTestListeners = new ArrayList();
    private SecurityTestRunnerImpl runner;
    private SoapUIScriptEngine startupScriptEngine;
    private SoapUIScriptEngine tearDownScriptEngine;

    public SecurityTest(WsdlTestCase testCase, SecurityTestConfig config) {
        super(config, testCase, ICON_NAME);
        this.testCase = testCase;
        if (!((SecurityTestConfig)this.getConfig()).isSetProperties()) {
            ((SecurityTestConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(((SecurityTestConfig)this.getConfig()).getProperties());
        this.securityTestStepResultMap = new LinkedHashMap<TestStep, SecurityTestStepResult>();
        for (SecurityTestRunListener listener : SoapUI.getListenerRegistry().getListeners(SecurityTestRunListener.class)) {
            this.addSecurityTestRunListener(listener);
        }
    }

    @Override
    public void release() {
        super.release();
        this.securityTestRunListeners.clear();
        if (this.securityTestStepResultMap != null) {
            this.securityTestStepResultMap.clear();
        }
        this.securityScansMap.clear();
        this.securityTestListeners.clear();
    }

    public SecurityScan addNewSecurityScan(TestStep testStep, String securityScanName) {
        SecurityScanFactory factory = SoapUI.getSoapUICore().getSecurityScanRegistry().getFactoryByName(securityScanName);
        SecurityScanConfig newScanConfig = factory.createNewSecurityScan(securityScanName);
        return this.addSecurityScan(testStep, factory, newScanConfig);
    }

    public SecurityScan addSecurityScan(TestStep testStep, SecurityScanFactory factory, SecurityScanConfig newScanConfig) {
        SecurityScan newSecScan = null;
        boolean hasScans = false;
        List<TestStepSecurityTestConfig> testStepSecurityTestList = ((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList();
        if (!testStepSecurityTestList.isEmpty()) {
            for (int i = 0; i < testStepSecurityTestList.size(); ++i) {
                TestStepSecurityTestConfig testStepSecurityTest = testStepSecurityTestList.get(i);
                if (!testStepSecurityTest.getTestStepId().equals(testStep.getId())) continue;
                newSecScan = this.buildSecurityScan(factory, newScanConfig, testStepSecurityTest, testStep);
                hasScans = true;
                break;
            }
        }
        if (!hasScans) {
            TestStepSecurityTestConfig testStepSecurityTest = ((SecurityTestConfig)this.getConfig()).addNewTestStepSecurityTest();
            testStepSecurityTest.setTestStepId(testStep.getId());
            newSecScan = this.buildSecurityScan(factory, newScanConfig, testStepSecurityTest, testStep);
        }
        this.addSecurityScanToMapByTestStepId(testStep.getId(), newSecScan);
        return newSecScan;
    }

    private SecurityScan buildSecurityScan(SecurityScanFactory factory, SecurityScanConfig newSecScanConfig, TestStepSecurityTestConfig testStepSecurityTestConfig, TestStep testStep) {
        SecurityScanConfig newSecurityScan = testStepSecurityTestConfig.addNewTestStepSecurityScan();
        newSecurityScan.setType(newSecScanConfig.getType());
        newSecurityScan.setName(newSecScanConfig.getName());
        newSecurityScan.setConfig(newSecScanConfig.getConfig());
        newSecurityScan.setAssertionArray(newSecScanConfig.getAssertionList().toArray(new TestAssertionConfig[0]));
        newSecurityScan.setTestStep(newSecScanConfig.getTestStep());
        newSecurityScan.setCheckedParameters(newSecScanConfig.getCheckedParameters());
        newSecurityScan.setExecutionStrategy(newSecScanConfig.getExecutionStrategy());
        return factory.buildSecurityScan(testStep, newSecurityScan, this);
    }

    private void addSecurityScanToMapByTestStepId(String testStepId, SecurityScan newSecScan) {
        if (this.securityScansMap.containsKey(testStepId)) {
            if (!this.securityScansMap.get(testStepId).contains(newSecScan)) {
                this.securityScansMap.get(testStepId).add(newSecScan);
            }
        } else {
            ArrayList<SecurityScan> list = new ArrayList<SecurityScan>();
            list.add(newSecScan);
            this.securityScansMap.put(testStepId, list);
        }
        this.fireSecurityScanAdded(newSecScan);
    }

    private void fireSecurityScanAdded(SecurityScan newSecScan) {
        for (SecurityTestListener listener : this.securityTestListeners) {
            listener.securityScanAdded(newSecScan);
        }
    }

    private void fireSecurityScanRemoved(SecurityScan newSecScan) {
        for (SecurityTestListener listener : this.securityTestListeners) {
            listener.securityScanRemoved(newSecScan);
        }
    }

    public void removeSecurityScan(TestStep testStep, SecurityScan securityScan) {
        if (this.isRunning()) {
            return;
        }
        List<TestStepSecurityTestConfig> testStepSecurityTestList = ((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList();
        if (!testStepSecurityTestList.isEmpty()) {
            for (int i = 0; i < testStepSecurityTestList.size(); ++i) {
                TestStepSecurityTestConfig testStepSecurityTest = testStepSecurityTestList.get(i);
                if (!testStepSecurityTest.getTestStepId().equals(testStep.getId())) continue;
                List<SecurityScanConfig> securityScanList = testStepSecurityTest.getTestStepSecurityScanList();
                Iterator<SecurityScanConfig> secListIterator = securityScanList.iterator();
                while (secListIterator.hasNext()) {
                    SecurityScanConfig current = secListIterator.next();
                    if (!current.getName().equals(securityScan.getName())) continue;
                    secListIterator.remove();
                    break;
                }
                if (!securityScanList.isEmpty()) continue;
                ((SecurityTestConfig)this.getConfig()).removeTestStepSecurityTest(i);
            }
        }
        this.removeSecurityScanFromMapByTestStepId(testStep.getId(), securityScan);
    }

    public void removeSecurityScanWhenRemoveTestStep(TestStep testStep, SecurityScan securityScan) {
        List<TestStepSecurityTestConfig> testStepSecurityTestList = ((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList();
        if (!testStepSecurityTestList.isEmpty()) {
            for (int i = 0; i < testStepSecurityTestList.size(); ++i) {
                TestStepSecurityTestConfig testStepSecurityTest = testStepSecurityTestList.get(i);
                if (!testStepSecurityTest.getTestStepId().equals(testStep.getId())) continue;
                List<SecurityScanConfig> securityScanList = testStepSecurityTest.getTestStepSecurityScanList();
                Iterator<SecurityScanConfig> secListIterator = securityScanList.iterator();
                while (secListIterator.hasNext()) {
                    SecurityScanConfig current = secListIterator.next();
                    if (!current.getName().equals(securityScan.getName())) continue;
                    secListIterator.remove();
                    break;
                }
                if (!securityScanList.isEmpty()) continue;
                ((SecurityTestConfig)this.getConfig()).removeTestStepSecurityTest(i);
            }
        }
    }

    private void removeSecurityScanFromMapByTestStepId(String testStepId, SecurityScan securityScan) {
        if (this.securityScansMap.containsKey(testStepId) && this.securityScansMap.get(testStepId).contains(securityScan)) {
            this.securityScansMap.get(testStepId).remove(securityScan);
            this.fireSecurityScanRemoved(securityScan);
            securityScan.release();
        }
    }

    public HashMap<String, List<SecurityScan>> getSecurityScansMap() {
        if (!this.securityScansMap.isEmpty()) {
            return this.securityScansMap;
        }
        return this.createSecurityScansMap();
    }

    public int getSecurityScanCount() {
        Iterator<List<SecurityScan>> scannedSteps = this.getSecurityScansMap().values().iterator();
        int count = 0;
        while (scannedSteps.hasNext()) {
            List<SecurityScan> scanList = scannedSteps.next();
            count += scanList.size();
        }
        return count;
    }

    public int getStepSecurityApplicableScansCount(TestStepResult tsr) {
        Iterator<List<SecurityScan>> scannedSteps = this.getSecurityScansMap().values().iterator();
        int count = 0;
        while (scannedSteps.hasNext()) {
            List<SecurityScan> scanList = scannedSteps.next();
            for (SecurityScan securityScan : scanList) {
                if (!securityScan.getTestStep().getId().equals(tsr.getTestStep().getId()) || tsr.getStatus() == TestStepResult.TestStepStatus.FAILED && !securityScan.isApplyForFailedStep()) continue;
                ++count;
            }
        }
        return count;
    }

    private HashMap<String, List<SecurityScan>> createSecurityScansMap() {
        if (this.getConfig() != null && !((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList().isEmpty()) {
            for (TestStepSecurityTestConfig testStepSecurityTestListConfig : ((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList()) {
                ArrayList<SecurityScan> scanList = new ArrayList<SecurityScan>();
                if (testStepSecurityTestListConfig != null && !testStepSecurityTestListConfig.getTestStepSecurityScanList().isEmpty()) {
                    for (SecurityScanConfig secScanConfig : testStepSecurityTestListConfig.getTestStepSecurityScanList()) {
                        TestStep testStep = null;
                        for (TestStep ts : this.testCase.getTestSteps().values()) {
                            if (!testStepSecurityTestListConfig.getTestStepId().equals(ts.getId())) continue;
                            testStep = ts;
                            SecurityScan securityScan = SoapUI.getSoapUICore().getSecurityScanRegistry().getFactory(secScanConfig.getType()).buildSecurityScan(testStep, secScanConfig, this);
                            scanList.add(securityScan);
                        }
                    }
                }
                if (scanList.isEmpty()) continue;
                this.securityScansMap.put(testStepSecurityTestListConfig.getTestStepId(), scanList);
            }
        }
        return this.securityScansMap;
    }

    public Map<TestStep, SecurityTestStepResult> getSecurityTestStepResultMap() {
        return this.securityTestStepResultMap;
    }

    public void clearSecurityTestStepResultMap() {
        this.securityTestStepResultMap.clear();
    }

    public void putSecurityTestStepResult(TestStep testStep, SecurityTestStepResult securityTestStepResult) {
        this.securityTestStepResultMap.put(testStep, securityTestStepResult);
    }

    public WsdlTestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public SecurityTestRunner run(StringToObjectMap context, boolean async) {
        if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
            return null;
        }
        this.runner = new SecurityTestRunnerImpl(this, context);
        this.runner.start(async);
        return this.runner;
    }

    public void setStartupScript(String script) {
        String oldScript = this.getStartupScript();
        if (!((SecurityTestConfig)this.getConfig()).isSetSetupScript()) {
            ((SecurityTestConfig)this.getConfig()).addNewSetupScript();
        }
        ((SecurityTestConfig)this.getConfig()).getSetupScript().setStringValue(script);
        if (this.startupScriptEngine != null) {
            this.startupScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(STARTUP_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getStartupScript() {
        return this.getConfig() != null ? (((SecurityTestConfig)this.getConfig()).isSetSetupScript() ? ((SecurityTestConfig)this.getConfig()).getSetupScript().getStringValue() : "") : "";
    }

    public Object runStartupScript(SecurityTestRunContext runContext, SecurityTestRunner runner) throws Exception {
        String script = this.getStartupScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.startupScriptEngine == null) {
            this.startupScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.startupScriptEngine.setScript(script);
        }
        this.startupScriptEngine.setVariable("context", runContext);
        this.startupScriptEngine.setVariable("securityTestRunner", runner);
        this.startupScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.startupScriptEngine.run();
    }

    public void setTearDownScript(String script) {
        String oldScript = this.getTearDownScript();
        if (!((SecurityTestConfig)this.getConfig()).isSetTearDownScript()) {
            ((SecurityTestConfig)this.getConfig()).addNewTearDownScript();
        }
        ((SecurityTestConfig)this.getConfig()).getTearDownScript().setStringValue(script);
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(TEARDOWN_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getTearDownScript() {
        return this.getConfig() != null ? (((SecurityTestConfig)this.getConfig()).isSetTearDownScript() ? ((SecurityTestConfig)this.getConfig()).getTearDownScript().getStringValue() : "") : "";
    }

    public Object runTearDownScript(SecurityTestRunContext runContext, SecurityTestRunner runner) throws Exception {
        String script = this.getTearDownScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.tearDownScriptEngine == null) {
            this.tearDownScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.tearDownScriptEngine.setScript(script);
        }
        this.tearDownScriptEngine.setVariable("context", runContext);
        this.tearDownScriptEngine.setVariable("securityTestRunner", runner);
        this.tearDownScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.tearDownScriptEngine.run();
    }

    public List<SecurityScan> getTestStepSecurityScans(String testStepId) {
        return this.getSecurityScansMap().get(testStepId) != null ? this.getSecurityScansMap().get(testStepId) : new ArrayList<SecurityScan>();
    }

    public SecurityScan getTestStepSecurityScanByName(String testStepId, String securityScanName) {
        List<SecurityScan> securityScansList = this.getTestStepSecurityScans(testStepId);
        for (int c = 0; c < securityScansList.size(); ++c) {
            SecurityScan securityScan = this.getTestStepSecurityScanAt(testStepId, c);
            if (!securityScanName.equals(securityScan.getName())) continue;
            return securityScan;
        }
        return null;
    }

    public <T extends SecurityScan> List<T> getTestStepSecurityScanByType(String testStepId, Class<T> securityScanType) {
        ArrayList<SecurityScan> result = new ArrayList<SecurityScan>();
        for (SecurityScan scan : this.getTestStepSecurityScans(testStepId)) {
            if (!securityScanType.isAssignableFrom(scan.getClass())) continue;
            result.add(scan);
        }
        return result;
    }

    public SecurityScan getTestStepSecurityScanAt(String testStepId, int index) {
        List<SecurityScan> securityScansList = this.getTestStepSecurityScans(testStepId);
        return securityScansList.get(index);
    }

    public int getTestStepSecurityScansCount(String testStepId) {
        if (this.getSecurityScansMap().isEmpty()) {
            return 0;
        }
        if (this.getSecurityScansMap().get(testStepId) != null) {
            return this.getSecurityScansMap().get(testStepId).size();
        }
        return 0;
    }

    public SecurityScan moveTestStepSecurityScan(TestStep testStep, SecurityScan securityScan, int index, int offset) {
        List<TestStepSecurityTestConfig> testStepSecurityTestList = ((SecurityTestConfig)this.getConfig()).getTestStepSecurityTestList();
        if (!testStepSecurityTestList.isEmpty()) {
            for (TestStepSecurityTestConfig testStepSecurityTest : testStepSecurityTestList) {
                if (!testStepSecurityTest.getTestStepId().equals(testStep.getId())) continue;
                List<SecurityScanConfig> securityScanList = testStepSecurityTest.getTestStepSecurityScanList();
                SecurityScanFactory factory = SoapUI.getSoapUICore().getSecurityScanRegistry().getFactory(securityScan.getType());
                SecurityScanConfig newSecScanConfig = (SecurityScanConfig)securityScan.getConfig().copy();
                SecurityScan newSecScan = factory.buildSecurityScan(testStep, newSecScanConfig, this);
                securityScanList.remove(securityScan.getConfig());
                securityScanList.add(index + offset, newSecScanConfig);
                SecurityScanConfig[] cc = new SecurityScanConfig[securityScanList.size()];
                for (int i = 0; i < securityScanList.size(); ++i) {
                    cc[i] = securityScanList.get(i);
                }
                testStepSecurityTest.setTestStepSecurityScanArray(cc);
                TestStepSecurityTestConfig[] vv = new TestStepSecurityTestConfig[testStepSecurityTestList.size()];
                for (int i = 0; i < testStepSecurityTestList.size(); ++i) {
                    vv[i] = testStepSecurityTestList.get(i);
                }
                ((SecurityTestConfig)this.getConfig()).setTestStepSecurityTestArray(vv);
                return newSecScan;
            }
        }
        return null;
    }

    public String findTestStepScanUniqueName(String testStepId, String type) {
        Object name = type;
        int numNames = 0;
        List<SecurityScan> securityScansList = this.getTestStepSecurityScans(testStepId);
        if (securityScansList != null && !securityScansList.isEmpty()) {
            for (SecurityScan existingScan : securityScansList) {
                if (!existingScan.getType().equals(name)) continue;
                ++numNames;
            }
        }
        if (numNames != 0) {
            name = (String)name + " " + numNames;
        }
        return name;
    }

    public void addSecurityTestRunListener(SecurityTestRunListener listener) {
        if (listener == null) {
            throw new RuntimeException("listener must not be null");
        }
        this.securityTestRunListeners.add(listener);
    }

    public void removeSecurityTestRunListener(SecurityTestRunListener listener) {
        this.securityTestRunListeners.remove(listener);
    }

    public SecurityTestRunListener[] getSecurityTestRunListeners() {
        return this.securityTestRunListeners.toArray(new SecurityTestRunListener[this.securityTestRunListeners.size()]);
    }

    public boolean getFailSecurityTestOnScanErrors() {
        return ((SecurityTestConfig)this.getConfig()).getFailSecurityTestOnScanErrors();
    }

    public void setFailSecurityTestOnScanErrors(boolean failSecurityTestOnErrors) {
        boolean old = this.getFailSecurityTestOnScanErrors();
        if (old != failSecurityTestOnErrors) {
            ((SecurityTestConfig)this.getConfig()).setFailSecurityTestOnScanErrors(failSecurityTestOnErrors);
            this.notifyPropertyChanged(FAIL_ON_SCANS_ERRORS_PROPERTY, old, failSecurityTestOnErrors);
        }
    }

    public boolean getFailOnError() {
        return ((SecurityTestConfig)this.getConfig()).getFailOnError();
    }

    public void setFailOnError(boolean failOnError) {
        boolean old = this.getFailOnError();
        if (old != failOnError) {
            ((SecurityTestConfig)this.getConfig()).setFailOnError(failOnError);
            this.notifyPropertyChanged(FAIL_ON_ERROR_PROPERTY, old, failOnError);
        }
    }

    public boolean getSkipDataSourceLoops() {
        return ((SecurityTestConfig)this.getConfig()).getSkipDataSourceLoops();
    }

    public void setSkipDataSourceLoops(boolean skipDataSourceLoops) {
        boolean old = this.getSkipDataSourceLoops();
        if (old != skipDataSourceLoops) {
            ((SecurityTestConfig)this.getConfig()).setSkipDataSourceLoops(skipDataSourceLoops);
            this.notifyPropertyChanged(SKIP_DATASOURCE_LOOP_PROPERTY, old, skipDataSourceLoops);
        }
    }

    public void addTestStepRunListener(TestStep testStep, SecurityTestRunListener listener) {
        if (listener == null) {
            throw new RuntimeException("listener must not be null");
        }
        if (this.securityTestStepRunListeners.containsKey(testStep)) {
            this.securityTestStepRunListeners.get(testStep).add(listener);
        } else {
            HashSet<SecurityTestRunListener> listeners = new HashSet<SecurityTestRunListener>();
            listeners.add(listener);
            this.securityTestStepRunListeners.put(testStep, listeners);
        }
    }

    public void removeTestStepRunListener(TestStep testStep, SecurityTestRunListener listener) {
        this.securityTestStepRunListeners.remove(this.securityTestStepRunListeners.get(testStep));
    }

    public SecurityTestRunListener[] getTestStepRunListeners(TestStep testStep) {
        if (this.securityTestStepRunListeners.containsKey(testStep)) {
            Set<SecurityTestRunListener> listeners = this.securityTestStepRunListeners.get(testStep);
            return listeners.toArray(new SecurityTestRunListener[listeners.size()]);
        }
        return new SecurityTestRunListener[0];
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        ArrayList<SecurityScan> result = new ArrayList<SecurityScan>();
        Set<String> testStepIds = this.getSecurityScansMap().keySet();
        for (String testStepId : testStepIds) {
            List<SecurityScan> t = this.getSecurityScansMap().get(testStepId);
            for (int i = 0; i < t.size(); ++i) {
                SecurityScan scan = t.get(i);
                result.add(scan);
            }
        }
        return result;
    }

    public void resetConfigOnMove(SecurityTestConfig securityTestConfig) {
        this.setConfig(securityTestConfig);
        if (securityTestConfig != null && !securityTestConfig.getTestStepSecurityTestList().isEmpty()) {
            for (TestStepSecurityTestConfig testStepSecurityTestListConfig : securityTestConfig.getTestStepSecurityTestList()) {
                List<SecurityScan> scanList = this.getSecurityScansMap().get(testStepSecurityTestListConfig.getTestStepId());
                for (int i = 0; i < scanList.size(); ++i) {
                    scanList.get(i).updateSecurityConfig(testStepSecurityTestListConfig.getTestStepSecurityScanList().get(i));
                }
            }
        }
    }

    public boolean canAddSecurityScan(TestStep testStep, String securityScanName) {
        boolean hasScansOfType = false;
        String securityScanType = SoapUI.getSoapUICore().getSecurityScanRegistry().getSecurityScanTypeForName(securityScanName);
        for (SecurityScan scan : this.getTestStepSecurityScans(testStep.getId())) {
            if (!securityScanType.equals(scan.getType())) continue;
            hasScansOfType = true;
            break;
        }
        return !hasScansOfType;
    }

    public String[] getAvailableSecurityScanNames(TestStep testStep, String[] securityScanNames) {
        ArrayList<String> availableNames = new ArrayList<String>();
        for (int i = 0; i < securityScanNames.length; ++i) {
            String name = securityScanNames[i];
            if (!this.canAddSecurityScan(testStep, name)) continue;
            availableNames.add(name);
        }
        return availableNames.toArray(new String[availableNames.size()]);
    }

    public boolean importSecurityScan(TestStep targetTestStep, SecurityScan securityScanToClone, boolean overwrite2) {
        boolean targetStepHasScans;
        XmlObject newConfig = securityScanToClone.getConfig().copy();
        SecurityScanConfig newScanConfig = SecurityScanConfig.Factory.newInstance();
        newScanConfig.set(newConfig);
        SecurityScanFactory factory = SoapUI.getSoapUICore().getSecurityScanRegistry().getFactory(newScanConfig.getType());
        boolean bl = targetStepHasScans = this.getTestStepSecurityScansCount(targetTestStep.getId()) > 0;
        if (targetStepHasScans) {
            boolean targetHasScanOfSameType = false;
            for (SecurityScan oldScan : this.getTestStepSecurityScans(targetTestStep.getId())) {
                if (!oldScan.getType().equals(securityScanToClone.getType())) continue;
                targetHasScanOfSameType = true;
                if (overwrite2) {
                    this.removeSecurityScan(targetTestStep, oldScan);
                    this.addSecurityScan(targetTestStep, factory, newScanConfig);
                    break;
                }
                return false;
            }
            if (!targetHasScanOfSameType) {
                this.addSecurityScan(targetTestStep, factory, newScanConfig);
            }
        } else {
            this.addSecurityScan(targetTestStep, factory, newScanConfig);
        }
        return true;
    }

    public void addSecurityTestListener(SecurityTestListener listener) {
        this.securityTestListeners.add(listener);
    }

    public void removeSecurityTestListener(SecurityTestListener listener) {
        this.securityTestListeners.remove(listener);
    }

    public boolean isRunning() {
        if (this.runner == null) {
            return false;
        }
        return this.runner.isRunning();
    }

    protected boolean skipTest(TestStep testStep) {
        return false;
    }

    public void resetAllScansSkipFurtherRunning() {
        for (String testStepId : this.getSecurityScansMap().keySet()) {
            for (SecurityScan scan : this.getTestStepSecurityScans(testStepId)) {
                scan.setSkipFurtherRunning(false);
            }
        }
    }
}

