/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    private final int majorVersion;
    private final int minorVersion;
    private final String patchVersion;

    public Version(int majorVersion, int minorVersion, String patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public static Version fromString(String versionString) {
        if (versionString == null) {
            return new Version(0, 0, null);
        }
        try {
            String[] parts = versionString.split("\\.");
            String patchVersion = parts.length == 3 ? parts[2] : null;
            return new Version(parts.length > 0 ? Integer.parseInt(parts[0]) : 0, parts.length > 1 ? Integer.parseInt(parts[1]) : 0, patchVersion);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(versionString + " is not a valid version string");
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getPatchVersion() {
        return this.patchVersion;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion + (String)(this.patchVersion == null ? "" : "." + this.patchVersion);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion && StringUtils.equals((String)this.patchVersion, (String)that.patchVersion);
    }

    public int hashCode() {
        int result = this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.patchVersion == null ? 0 : this.patchVersion.hashCode());
        return result;
    }

    @Override
    public int compareTo(Version other) {
        if (this.majorVersion != other.majorVersion) {
            return this.majorVersion - other.majorVersion;
        }
        if (this.minorVersion != other.minorVersion) {
            return this.minorVersion - other.minorVersion;
        }
        return this.normalizePatchVersion(this.patchVersion).compareTo(this.normalizePatchVersion(other.patchVersion));
    }

    private String normalizePatchVersion(String patchVersion) {
        return patchVersion == null ? "0" : patchVersion;
    }
}

