/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.RenameableTestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlString;

public class DefaultTestStepProperty
implements TestStepProperty,
RenameableTestProperty {
    private String name;
    private boolean isReadOnly;
    private String description;
    private PropertyHandler handler;
    private final WsdlTestStep testStep;
    private boolean requestPart;

    public DefaultTestStepProperty(String name, boolean isReadOnly, PropertyHandler handler, WsdlTestStep testStep) {
        this.name = name;
        this.isReadOnly = isReadOnly;
        this.handler = handler;
        this.testStep = testStep;
    }

    public DefaultTestStepProperty(String name, boolean isReadOnly, PropertyHandler handler, WsdlTestStep testStep, boolean requestPart) {
        this.name = name;
        this.isReadOnly = isReadOnly;
        this.handler = handler;
        this.testStep = testStep;
        this.requestPart = requestPart;
    }

    public DefaultTestStepProperty(String name, WsdlTestStep testStep) {
        this(name, false, new SimplePropertyHandler(), testStep);
    }

    public DefaultTestStepProperty(String name, boolean isReadOnly, WsdlTestStep testStep) {
        this(name, isReadOnly, new SimplePropertyHandler(), testStep);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setPropertyHandler(PropertyHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getValue() {
        return this.handler == null ? null : this.handler.getValue(this);
    }

    @Override
    public void setValue(String value) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Trying to set read-only property [" + this.getName() + "]");
        }
        if (this.handler != null) {
            this.handler.setValue(this, value);
        }
    }

    @Override
    public TestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public QName getType() {
        return XmlString.type.getName();
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public boolean isRequestPart() {
        return this.requestPart;
    }

    @Override
    public SchemaType getSchemaType() {
        return XmlString.type;
    }

    public static interface PropertyHandler {
        public String getValue(DefaultTestStepProperty var1);

        public void setValue(DefaultTestStepProperty var1, String var2);
    }

    public static class SimplePropertyHandler
    implements PropertyHandler {
        private String value;

        @Override
        public String getValue(DefaultTestStepProperty property) {
            return this.value;
        }

        @Override
        public void setValue(DefaultTestStepProperty property, String value) {
            this.value = value;
        }
    }

    public static class PropertyHandlerAdapter
    implements PropertyHandler {
        @Override
        public String getValue(DefaultTestStepProperty property) {
            return null;
        }

        @Override
        public void setValue(DefaultTestStepProperty property, String value) {
        }
    }
}

