/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion.resolvers.providers;

import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.resolvers.DynamicPropertyResolver;
import com.eviware.soapui.model.support.ModelSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ProjectDirProvider
implements DynamicPropertyResolver.ValueProvider {
    @Override
    public String getValue(PropertyExpansionContext context) {
        Project project = ModelSupport.getModelItemProject(context.getModelItem());
        if (project != null) {
            return ProjectDirProvider.getProjectFolder(project);
        }
        return null;
    }

    public static String getProjectFolder(Project project) {
        if (project.getPath() != null) {
            File file = new File(project.getPath());
            if (file.exists()) {
                return new File(file.getAbsolutePath()).getParent();
            }
            try {
                URL url = new URL(project.getPath());
                String str = url.getProtocol() + "://" + url.getHost() + (String)(url.getPort() != -1 ? ":" + url.getPort() : "") + url.getPath();
                int ix = str.lastIndexOf(47);
                if (ix != -1) {
                    return str.substring(0, ix);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

