/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.RestParameterConfig;
import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.monitor.WsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.validators.RequiredValidator;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;

public class HttpRequestStepFactory
extends WsdlTestStepFactory {
    private static final String HTTPREQUEST = "httprequest";
    public static final String HTTPREQUEST_TYPE = "httprequest";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(HttpRequestStepFactory.class);
    private XmlBeansRestParamsTestPropertyHolder params;
    private RestParamsTable paramsTable;

    public HttpRequestStepFactory() {
        super("httprequest", "HTTP Request", "Submits a HTTP Request and validates its response", "/http_request_step.png");
    }

    @Override
    public WsdlTestStep buildTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        return new HttpTestRequestStep(testCase, config, forLoadTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepConfig createNewTestStep(WsdlTestCase testCase, String name) {
        if (this.dialog == null) {
            this.buildDialog();
        } else {
            this.dialog.setValue(Form.ENDPOINT, "");
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(testCase, RestParametersConfig.Factory.newInstance());
        this.paramsTable = new RestParamsTable(this.params, false, NewRestResourceActionBase.ParamLocation.RESOURCE, true, false);
        this.dialog.getFormField(Form.PARAMSTABLE).setProperty("component", this.paramsTable);
        this.dialog.setValue(Form.STEPNAME, name);
        try {
            if (this.dialog.show()) {
                HttpRequestConfig httpRequest = HttpRequestConfig.Factory.newInstance();
                httpRequest.setEndpoint(HttpUtils.completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(this.dialog.getValue(Form.ENDPOINT)));
                httpRequest.setMethod(this.dialog.getValue(Form.HTTPMETHOD));
                XmlBeansRestParamsTestPropertyHolder tempParams = new XmlBeansRestParamsTestPropertyHolder(testCase, httpRequest.addNewParameters());
                tempParams.addParameters(this.params);
                tempParams.release();
                TestStepConfig testStep = TestStepConfig.Factory.newInstance();
                testStep.setType("httprequest");
                testStep.setConfig(httpRequest);
                testStep.setName(this.dialog.getValue(Form.STEPNAME));
                TestStepConfig testStepConfig = testStep;
                return testStepConfig;
            }
            TestStepConfig testStepConfig = null;
            return testStepConfig;
        }
        finally {
            this.paramsTable.release();
            this.paramsTable = null;
            this.params = null;
            this.dialog.getFormField(Form.PARAMSTABLE).setProperty("component", this.paramsTable);
        }
    }

    public TestStepConfig createNewTestStep(WsdlTestCase testCase, String name, String endpoint, String method) {
        RestParametersConfig restParamConf = RestParametersConfig.Factory.newInstance();
        this.params = new XmlBeansRestParamsTestPropertyHolder(testCase, restParamConf);
        HttpRequestConfig httpRequest = HttpRequestConfig.Factory.newInstance();
        httpRequest.setMethod(method);
        endpoint = RestUtils.extractParams(endpoint, this.params, true);
        XmlBeansRestParamsTestPropertyHolder tempParams = new XmlBeansRestParamsTestPropertyHolder(testCase, httpRequest.addNewParameters());
        tempParams.addParameters(this.params);
        httpRequest.setEndpoint(HttpUtils.completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(endpoint));
        TestStepConfig testStep = TestStepConfig.Factory.newInstance();
        testStep.setType("httprequest");
        testStep.setConfig(httpRequest);
        testStep.setName(name);
        return testStep;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean promptForName() {
        return false;
    }

    private void buildDialog() {
        this.dialog = ADialogBuilder.buildDialog(Form.class);
        this.dialog.getFormField(Form.STEPNAME).addFormFieldValidator(new RequiredValidator());
        this.dialog.getFormField(Form.EXTRACTPARAMS).setProperty("action", new ExtractParamsAction());
        ((XFormOptionsField)this.dialog.getFormField(Form.HTTPMETHOD)).setOptions((Object[])RestRequestInterface.HttpMethod.getMethods());
    }

    public TestStepConfig createConfig(WsdlMonitorMessageExchange me, String stepName) {
        HttpRequestConfig testRequestConfig = HttpRequestConfig.Factory.newInstance();
        testRequestConfig.setName(stepName);
        testRequestConfig.setEncoding("UTF-8");
        testRequestConfig.setEndpoint(me.getEndpoint());
        testRequestConfig.setMethod(me.getRequestMethod());
        RestParametersConfig parametersConfig = testRequestConfig.addNewParameters();
        Map<String, String> parametersMap = me.getHttpRequestParameters();
        ArrayList<RestParameterConfig> parameterConfigList = new ArrayList<RestParameterConfig>();
        for (String name : parametersMap.keySet()) {
            RestParameterConfig parameterConf = RestParameterConfig.Factory.newInstance();
            parameterConf.setName(name);
            parameterConf.setValue(parametersMap.get(name));
            parameterConfigList.add(parameterConf);
        }
        parametersConfig.setParameterArray(parameterConfigList.toArray(new RestParameterConfig[parametersMap.size()]));
        testRequestConfig.setParameters(parametersConfig);
        TestStepConfig testStep = TestStepConfig.Factory.newInstance();
        testStep.setType("httprequest");
        testStep.setConfig(testRequestConfig);
        testStep.setName(stepName);
        return testStep;
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="/functional-testing/teststep-reference/http-request/http-request.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.TestStepName.Description", type=AField.AFieldType.STRING)
        public static final String STEPNAME = messages.get("Form.TestStepName.Label");
        @AField(description="Form.Endpoint.Description", type=AField.AFieldType.STRING)
        public static final String ENDPOINT = messages.get("Form.Endpoint.Label");
        @AField(description="Form.ExtractParams.Description", type=AField.AFieldType.ACTION)
        public static final String EXTRACTPARAMS = messages.get("Form.ExtractParams.Label");
        @AField(description="Form.ParamsTable.Description", type=AField.AFieldType.COMPONENT)
        public static final String PARAMSTABLE = messages.get("Form.ParamsTable.Label");
        @AField(description="Form.HttpMethod.Description", type=AField.AFieldType.ENUMERATION)
        public static final String HTTPMETHOD = messages.get("Form.HttpMethod.Label");
    }

    private class ExtractParamsAction
    extends AbstractAction {
        public ExtractParamsAction() {
            super("Extract Params");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String path = RestUtils.extractParams(HttpRequestStepFactory.this.dialog.getValue(Form.ENDPOINT), HttpRequestStepFactory.this.params, true);
                HttpRequestStepFactory.this.dialog.setValue(Form.ENDPOINT, path);
                if (StringUtils.isNullOrEmpty(HttpRequestStepFactory.this.dialog.getValue(Form.STEPNAME))) {
                    this.setNameFromPath(path);
                }
                HttpRequestStepFactory.this.paramsTable.refresh();
            }
            catch (Exception e1) {
                UISupport.showInfoMessage("No parameters to extract!");
            }
        }

        private void setNameFromPath(String path) {
            String[] items = path.split("/");
            if (items.length > 0) {
                HttpRequestStepFactory.this.dialog.setValue(Form.STEPNAME, items[items.length - 1]);
            }
        }
    }
}

