/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.jdbc;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.StringUtils;

public class JdbcTimeoutAssertion
extends WsdlMessageAssertion
implements ResponseAssertion,
RequestAssertion {
    public static final String ID = "JDBC Timeout";
    public static final String LABEL = "JDBC Timeout";
    public static final String DESCRIPTION = "Validates that the JDBC statement of the target TestStep did not take longer than the specified duration. Applicable to JDBC TestSteps only.";
    private static long DEFAULT_QUERY_TIEMOUT = 100L;

    public JdbcTimeoutAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, false, false, true);
    }

    public void setQueryTimeoutProperty(String queryTimeoutProperty) {
        ((JdbcRequestTestStep)this.getAssertable().getModelItem()).setQueryTimeout(queryTimeoutProperty);
    }

    public Long getQueryTimeoutProperty() {
        String queryTimeoutProperty = ((JdbcRequestTestStep)this.getAssertable().getModelItem()).getQueryTimeout();
        if (StringUtils.isNullOrEmpty(queryTimeoutProperty)) {
            return DEFAULT_QUERY_TIEMOUT;
        }
        return Long.parseLong(queryTimeoutProperty);
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (context.getProperty("JDBC_TIMEOUT") != null) {
            Long timeout = Long.valueOf(context.getProperty("JDBC_TIMEOUT").toString());
            throw new AssertionException(new AssertionError("JDBC Request timeout error! Query not executed in " + timeout + " ms."));
        }
        return "JDBC Timeout OK";
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return "JDBC Timeout OK";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("JDBC Timeout", "JDBC Timeout", JdbcTimeoutAssertion.class, WsdlRequest.class);
        }

        @Override
        public String getCategory() {
            return "JDBC";
        }

        @Override
        public boolean canAssert(Assertable assertable) {
            return assertable instanceof JdbcRequestTestStep;
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return JdbcTimeoutAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("JDBC Timeout", "JDBC Timeout", JdbcTimeoutAssertion.DESCRIPTION);
        }
    }
}

