/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AMFRequestTestStepConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFSubmit;
import com.eviware.soapui.impl.wsdl.support.AMFMessageExchange;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.AMFTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.SamplerTestStep;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AMFRequestTestStep
extends WsdlTestStepWithProperties
implements Assertable,
MutableTestPropertyHolder,
PropertyChangeListener,
SamplerTestStep {
    private static final Logger log = LogManager.getLogger(WsdlTestRequestStep.class);
    protected AMFRequestTestStepConfig amfRequestTestStepConfig = ((TestStepConfig)this.getConfig()).getConfig() != null ? (AMFRequestTestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(AMFRequestTestStepConfig.type) : (AMFRequestTestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(AMFRequestTestStepConfig.type);
    public static final String amfREQUEST = AMFRequestTestStep.class.getName() + "@amfrequest";
    public static final String STATUS_PROPERTY = WsdlTestRequest.class.getName() + "@status";
    public static final String RESPONSE_PROPERTY = "response";
    public static final String REQUEST_PROPERTY = "request";
    public static final String HTTP_HEADERS_PROPERTY = AMFRequest.class.getName() + "@request-headers";
    public static final String AMF_HEADERS_PROPERTY = AMFRequest.class.getName() + "@amfrequest-amfheaders";
    private AMFSubmit submit;
    private SoapUIScriptEngine scriptEngine;
    private AssertionsSupport assertionsSupport;
    private PropertyChangeNotifier notifier;
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private AMFRequest amfRequest;

    public AMFRequestTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (this.amfRequestTestStepConfig.getProperties() == null) {
            this.amfRequestTestStepConfig.addNewProperties();
        }
        this.amfRequest = new AMFRequest(this, forLoadTest);
        this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(this, this.amfRequestTestStepConfig.getProperties());
        this.addResponseAsXmlVirtualProperty();
        this.initAssertions();
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
        this.scriptEngine.setScript(this.getScript());
        if (forLoadTest && !this.isDisabled()) {
            try {
                this.scriptEngine.compile();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    private void addResponseAsXmlVirtualProperty() {
        TestStepBeanProperty responseProperty = new TestStepBeanProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, false, this.amfRequest, "responseContent", this){

            @Override
            public String getDefaultValue() {
                return "";
            }
        };
        this.propertyHolderSupport.addVirtualProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, responseProperty);
    }

    public AMFRequestTestStepConfig getAMFRequestTestStepConfig() {
        return this.amfRequestTestStepConfig;
    }

    @Override
    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        AMFRequestTestStep result = (AMFRequestTestStep)targetTestCase.addTestStep(config);
        return result;
    }

    @Override
    public void release() {
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        AMFTestStepResult testStepResult = new AMFTestStepResult(this);
        testStepResult.startTimer();
        runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
        try {
            if (!this.initAmfRequest(runContext)) {
                throw new Request.SubmitException("AMF request is not initialised properly !");
            }
            this.submit = this.amfRequest.submit(runContext, false);
            AMFResponse response = this.submit.getResponse();
            if (this.submit.getStatus() != Submit.Status.CANCELED) {
                if (this.submit.getStatus() == Submit.Status.ERROR) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage(this.submit.getError().toString());
                    this.amfRequest.setResponse(null);
                } else if (response == null) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage("Request is missing response");
                    this.amfRequest.setResponse(null);
                } else {
                    runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
                    this.amfRequest.setResponse(response);
                    testStepResult.setTimeTaken(response.getTimeTaken());
                    testStepResult.setSize(response.getContentLength());
                    switch (this.amfRequest.getAssertionStatus()) {
                        case FAILED: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case VALID: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        case UNKNOWN: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                    testStepResult.setResponse(response, testStepResult.getStatus() != TestStepResult.TestStepStatus.FAILED);
                }
            } else {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
            } else {
                testStepResult.setRequestContent(this.amfRequest.getRequestContent());
            }
            testStepResult.stopTimer();
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
            testStepResult.stopTimer();
        }
        finally {
            this.submit = null;
        }
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            this.assertResponse(runContext);
            Assertable.AssertionStatus assertionStatus = this.amfRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        TestAssertion assertion = this.getAssertionAt(c);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.amfRequest.setResponse(null);
        }
        this.firePropertyValueChanged("ResponseAsXml", null, testStepResult.getResponseContentAsXml());
        return testStepResult;
    }

    @Override
    public boolean cancel() {
        if (this.submit == null) {
            return false;
        }
        this.submit.cancel();
        return true;
    }

    @Override
    public String getDefaultSourcePropertyName() {
        return "Response";
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return AMFRequestTestStep.this.getAMFRequestTestStepConfig().addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return AMFRequestTestStep.this.getAMFRequestTestStepConfig().getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                AMFRequestTestStep.this.getAMFRequestTestStepConfig().removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = AMFRequestTestStep.this.getAMFRequestTestStepConfig().insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public TestAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionLabel);
            if (assertion == null) {
                return null;
            }
            if (this.getAMFRequest().getResponse() != null) {
                assertion.assertResponse(new AMFMessageExchange(this, this.getAMFRequest().getResponse()), new WsdlTestRunContext(this));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getAssertableContent();
    }

    @Override
    public String getAssertableContent() {
        return this.getAMFRequest().getResponse() == null ? null : this.getAMFRequest().getResponse().getContentAsString();
    }

    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.RESPONSE;
    }

    @Override
    public TestAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if ((arg0.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || arg0.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) && this.getAMFRequest().getResponse() != null) {
            this.assertResponse(new WsdlTestRunContext(this));
        }
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return null;
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.amfRequest.getAssertionStatus();
    }

    @Override
    public ImageIcon getIcon() {
        return this.amfRequest.getIcon();
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        TestAssertion assertion = this.getAssertionAt(ix);
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    public void assertResponse(SubmitContext context) {
        try {
            if (this.notifier == null) {
                this.notifier = new PropertyChangeNotifier();
            }
            AMFMessageExchange messageExchange = new AMFMessageExchange(this, this.getAMFRequest().getResponse());
            for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                assertion.assertResponse(messageExchange, context);
            }
            this.notifier.notifyChange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.propertyHolderSupport.addProperty(name);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.propertyHolderSupport.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return PropertyExpansionUtils.renameProperty(this.propertyHolderSupport.getProperty(name), newName, this.getTestCase()) != null;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    public void setPropertyValue(String name, Object value) {
        this.setPropertyValue(name, String.valueOf(value));
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.propertyHolderSupport.moveProperty(propertyName, targetIndex);
    }

    public AMFRequest getAMFRequest() {
        return this.amfRequest;
    }

    public void setResponse(AMFResponse response, SubmitContext context) {
        AMFResponse oldResponse = this.amfRequest.getResponse();
        this.amfRequest.setResponse(response);
        this.notifyPropertyChanged(RESPONSE_PROPERTY, oldResponse, response);
        this.assertResponse(context);
    }

    public String getScript() {
        return this.amfRequestTestStepConfig.getScript() != null ? this.amfRequestTestStepConfig.getScript().getStringValue() : "";
    }

    public void setScript(String script) {
        String old = this.getScript();
        this.scriptEngine.setScript(script);
        if (this.amfRequestTestStepConfig.getScript() == null) {
            this.amfRequestTestStepConfig.addNewScript();
        }
        this.amfRequestTestStepConfig.getScript().setStringValue(script);
        this.notifyPropertyChanged("script", old, script);
    }

    public String getAmfCall() {
        return this.amfRequestTestStepConfig.getAmfCall();
    }

    public void setAmfCall(String amfCall) {
        String old = this.getAmfCall();
        this.amfRequestTestStepConfig.setAmfCall(amfCall);
        this.notifyPropertyChanged("amfCall", old, amfCall);
    }

    public String getEndpoint() {
        return this.amfRequestTestStepConfig.getEndpoint();
    }

    public void setEndpoint(String endpoint) {
        String old = this.getEndpoint();
        this.amfRequestTestStepConfig.setEndpoint(endpoint);
        this.notifyPropertyChanged("endpoint", old, endpoint);
    }

    public boolean initAmfRequest(SubmitContext submitContext) {
        this.amfRequest.setScriptEngine(this.scriptEngine);
        this.amfRequest.setAmfCall(PropertyExpander.expandProperties(submitContext, this.getAmfCall()));
        this.amfRequest.setEndpoint(PropertyExpander.expandProperties(submitContext, this.getEndpoint()));
        this.amfRequest.setScript(this.getScript());
        this.amfRequest.setPropertyNames(this.getPropertyNames());
        this.amfRequest.setPropertyMap((HashMap)this.getProperties());
        this.amfRequest.setHttpHeaders(this.getHttpHeaders());
        this.amfRequest.setAmfHeadersString(this.getAmfHeaders());
        return this.amfRequest.executeAmfScript(submitContext);
    }

    public void setHttpHeaders(StringToStringsMap httpHeaders) {
        StringToStringsMap old = this.getHttpHeaders();
        this.getSettings().setString(HTTP_HEADERS_PROPERTY, httpHeaders.toXml());
        this.notifyPropertyChanged(HTTP_HEADERS_PROPERTY, old, httpHeaders);
    }

    public StringToStringsMap getHttpHeaders() {
        return StringToStringsMap.fromXml(this.getSettings().getString(HTTP_HEADERS_PROPERTY, null));
    }

    public void setAmfHeaders(StringToStringMap amfHeaders) {
        StringToStringMap old = this.getAmfHeaders();
        this.getSettings().setString(AMF_HEADERS_PROPERTY, amfHeaders.toXml());
        this.notifyPropertyChanged(AMF_HEADERS_PROPERTY, old, amfHeaders);
    }

    public StringToStringMap getAmfHeaders() {
        return StringToStringMap.fromXml(this.getSettings().getString(AMF_HEADERS_PROPERTY, null));
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.amfRequestTestStepConfig = (AMFRequestTestStepConfig)config.getConfig().changeType(AMFRequestTestStepConfig.type);
        this.propertyHolderSupport.resetPropertiesConfig(this.amfRequestTestStepConfig.getProperties());
        this.assertionsSupport.refresh();
    }

    public XmlBeansPropertiesTestPropertyHolder getPropertyHolderSupport() {
        return this.propertyHolderSupport;
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    public boolean isDiscardResponse() {
        return this.amfRequest.isDiscardResponse();
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.amfRequest.setDiscardResponse(discardResponse);
    }

    @Override
    public TestRequest getTestRequest() {
        return this.amfRequest;
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = AMFRequestTestStep.this.getAssertionStatus();
            this.oldIcon = AMFRequestTestStep.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = AMFRequestTestStep.this.getAssertionStatus();
            ImageIcon newIcon = AMFRequestTestStep.this.getIcon();
            if (this.oldStatus != newStatus) {
                AMFRequestTestStep.this.notifyPropertyChanged(STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                AMFRequestTestStep.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, AMFRequestTestStep.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

