/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.support.AbstractTestRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunContext;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WsdlTestSuiteRunner
extends AbstractTestRunner<WsdlTestSuite, WsdlTestSuiteRunContext>
implements TestSuiteRunner {
    private TestSuiteRunListener[] listeners;
    private Set<TestCaseRunner> finishedRunners = new HashSet<TestCaseRunner>();
    private Set<TestCaseRunner> activeRunners = new HashSet<TestCaseRunner>();
    private int currentTestCaseIndex;
    private WsdlTestCase currentTestCase;
    private TestRunListener parallellTestRunListener = new ParallellTestRunListener();

    public WsdlTestSuiteRunner(WsdlTestSuite testSuite, StringToObjectMap properties) {
        super(testSuite, properties);
    }

    @Override
    public WsdlTestSuiteRunContext createContext(StringToObjectMap properties) {
        return new WsdlTestSuiteRunContext(this, properties);
    }

    @Override
    public void onCancel(String reason) {
        for (TestCaseRunner runner : this.activeRunners.toArray(new TestCaseRunner[this.activeRunners.size()])) {
            runner.cancel(reason);
        }
    }

    @Override
    public void onFail(String reason) {
        for (TestCaseRunner runner : this.activeRunners.toArray(new TestCaseRunner[this.activeRunners.size()])) {
            runner.fail(reason);
        }
    }

    @Override
    public void internalRun(WsdlTestSuiteRunContext runContext) throws Exception {
        WsdlTestSuite testSuite = (WsdlTestSuite)this.getTestRunnable();
        this.listeners = testSuite.getTestSuiteRunListeners();
        testSuite.runSetupScript(runContext, this);
        if (!this.isRunning()) {
            return;
        }
        if (testSuite.getTimeout() > 0L) {
            this.startTimeoutTimer(testSuite.getTimeout());
        }
        this.notifyBeforeRun();
        if (!this.isRunning()) {
            return;
        }
        if (testSuite.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
            this.runSequential(testSuite, runContext);
        } else if (testSuite.getRunType() == TestSuite.TestSuiteRunType.PARALLEL) {
            this.runParallel(testSuite, runContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runParallel(WsdlTestSuite testSuite, WsdlTestSuiteRunContext runContext) {
        this.currentTestCaseIndex = -1;
        this.currentTestCase = null;
        for (TestCase testCase : testSuite.getTestCaseList()) {
            if (testCase.isDisabled()) continue;
            testCase.addTestRunListener(this.parallellTestRunListener);
            this.notifyBeforeRunTestCase(testCase);
            this.runTestCase((WsdlTestCase)testCase, true);
        }
        try {
            Set<TestCaseRunner> set = this.activeRunners;
            synchronized (set) {
                this.activeRunners.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void runSequential(WsdlTestSuite testSuite, WsdlTestSuiteRunContext runContext) {
        this.currentTestCaseIndex = 0;
        while (this.isRunning() && this.currentTestCaseIndex < testSuite.getTestCaseCount()) {
            this.currentTestCase = testSuite.getTestCaseAt(this.currentTestCaseIndex);
            if (!this.currentTestCase.isDisabled()) {
                this.notifyBeforeRunTestCase(this.currentTestCase);
                TestCaseRunner testCaseRunner = this.runTestCase(this.currentTestCase, false);
                this.activeRunners.remove(testCaseRunner);
                this.finishedRunners.add(testCaseRunner);
                this.notifyAfterRunTestCase(testCaseRunner);
            }
            ++this.currentTestCaseIndex;
        }
        this.updateStatus();
    }

    private void updateStatus() {
        for (TestCaseRunner runner : this.finishedRunners) {
            if (runner.getStatus() != TestRunner.Status.FAILED) continue;
            this.setStatus(TestRunner.Status.FAILED);
            break;
        }
    }

    private TestCaseRunner runTestCase(WsdlTestCase testCaseAt, boolean async) {
        DefaultPropertyExpansionContext properties = (DefaultPropertyExpansionContext)((WsdlTestSuiteRunContext)this.getRunContext()).getProperties();
        properties.put("#TestSuiteRunner#", this);
        WsdlTestCaseRunner currentRunner = testCaseAt.run(properties, true);
        this.activeRunners.add(currentRunner);
        if (!async) {
            currentRunner.waitUntilFinished();
        }
        return currentRunner;
    }

    @Override
    protected void internalFinally(WsdlTestSuiteRunContext runContext) {
        WsdlTestSuite testSuite = (WsdlTestSuite)this.getTestRunnable();
        try {
            testSuite.runTearDownScript(runContext, this);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.notifyAfterRun();
        runContext.clear();
        this.listeners = null;
    }

    private void notifyAfterRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterRun(this, (TestSuiteRunContext)this.getRunContext());
        }
    }

    private void notifyBeforeRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeRun(this, (TestSuiteRunContext)this.getRunContext());
        }
    }

    private void notifyAfterRunTestCase(TestCaseRunner testCaseRunner) {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterTestCase(this, (TestSuiteRunContext)this.getRunContext(), testCaseRunner);
        }
    }

    private void notifyBeforeRunTestCase(TestCase testCase) {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeTestCase(this, (TestSuiteRunContext)this.getRunContext(), testCase);
        }
    }

    @Override
    public TestSuite getTestSuite() {
        return (TestSuite)this.getTestRunnable();
    }

    @Override
    public List<TestCaseRunner> getResults() {
        return Arrays.asList(this.finishedRunners.toArray(new TestCaseRunner[this.finishedRunners.size()]));
    }

    public int getCurrentTestCaseIndex() {
        return this.currentTestCaseIndex;
    }

    public WsdlTestCase getCurrentTestCase() {
        return this.currentTestCase;
    }

    private class ParallellTestRunListener
    extends TestRunListenerAdapter {
        private ParallellTestRunListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlTestSuiteRunner.this.notifyAfterRunTestCase(testRunner);
            WsdlTestSuiteRunner.this.activeRunners.remove(testRunner);
            WsdlTestSuiteRunner.this.finishedRunners.add(testRunner);
            testRunner.getTestCase().removeTestRunListener(WsdlTestSuiteRunner.this.parallellTestRunListener);
            if (WsdlTestSuiteRunner.this.activeRunners.isEmpty()) {
                WsdlTestSuiteRunner.this.updateStatus();
                Set set = WsdlTestSuiteRunner.this.activeRunners;
                synchronized (set) {
                    WsdlTestSuiteRunner.this.activeRunners.notify();
                }
            }
        }
    }
}

