/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.IncomingWssConfig;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.codec.binary.Base64;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IncomingWss {
    private IncomingWssConfig wssConfig;
    private final WssContainer container;

    public IncomingWss(IncomingWssConfig wssConfig, WssContainer container) {
        this.wssConfig = wssConfig;
        this.container = container;
    }

    public WssContainer getWssContainer() {
        return this.container;
    }

    public String getDecryptCrypto() {
        return this.wssConfig.getDecryptCrypto();
    }

    public String getDecryptPassword() {
        return this.wssConfig.getDecryptPassword();
    }

    public String getName() {
        return this.wssConfig.getName();
    }

    public String getSignatureCrypto() {
        return this.wssConfig.getSignatureCrypto();
    }

    public void setDecryptCrypto(String arg0) {
        this.wssConfig.setDecryptCrypto(arg0);
    }

    public void setDecryptPassword(String arg0) {
        this.wssConfig.setDecryptPassword(arg0);
    }

    public void setName(String arg0) {
        this.wssConfig.setName(arg0);
    }

    public void setSignatureCrypto(String arg0) {
        this.wssConfig.setSignatureCrypto(arg0);
    }

    public Vector<Object> processIncoming(Document soapDocument, PropertyExpansionContext context) throws WSSecurityException {
        Element header = WSSecurityUtil.findWsseSecurityHeaderBlock((Document)soapDocument, (Element)soapDocument.getDocumentElement(), (boolean)false);
        if (header == null) {
            return null;
        }
        try {
            Crypto dec;
            WSSecurityEngine wssecurityEngine = new WSSecurityEngine();
            WssCrypto signatureCrypto = this.getWssContainer().getCryptoByName(this.getSignatureCrypto());
            WssCrypto decryptCrypto = this.getWssContainer().getCryptoByName(this.getDecryptCrypto());
            Crypto sig = signatureCrypto == null ? null : signatureCrypto.getCrypto();
            Crypto crypto = dec = decryptCrypto == null ? null : decryptCrypto.getCrypto();
            if (sig == null && dec == null) {
                throw new WSSecurityException("Missing cryptos");
            }
            if (sig == null) {
                sig = dec;
            } else if (dec == null) {
                dec = sig;
            }
            List incomingResult = wssecurityEngine.processSecurityHeader(soapDocument, (String)null, (CallbackHandler)new WSSCallbackHandler(dec), sig, dec);
            Vector<Object> wssResult = new Vector<Object>();
            wssResult.setSize(incomingResult.size());
            Collections.copy(wssResult, incomingResult);
            return wssResult;
        }
        catch (WSSecurityException e) {
            SoapUI.logError(e);
            throw e;
        }
    }

    public void updateConfig(IncomingWssConfig config) {
        this.wssConfig = config;
    }

    public void resolve(ResolveContext<?> context) {
    }

    public class WSSCallbackHandler
    implements CallbackHandler {
        private final Crypto dec;

        public WSSCallbackHandler(Crypto dec) {
            this.dec = dec;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof WSPasswordCallback)) continue;
                WSPasswordCallback cb = (WSPasswordCallback)callback;
                if (StringUtils.hasContent(IncomingWss.this.getDecryptPassword())) {
                    cb.setPassword(IncomingWss.this.getDecryptPassword());
                } else {
                    cb.setPassword(new String(UISupport.promptPassword("Password required for WSS processing", "Specify Password")));
                }
                if (cb.getUsage() != 8) continue;
                byte[] byArray = Base64.decodeBase64((byte[])cb.getIdentifier().getBytes());
            }
        }
    }
}

