/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.smartbear.soapui.core.Logging;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.Args;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public class SoapUIWire {
    private final Logger log;
    private static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("^[POST|GET|PUT|DELETE|PATCH|HEAD|OPTIONS|TRACE].* HTTP\\/1\\.[0|1]");
    private static final Pattern RESPONSE_LINE_PATTERN = Pattern.compile("^HTTP\\/1\\.[0|1] \\d{3} ");

    public SoapUIWire(Logger log) {
        this.log = log;
    }

    private void wire(boolean request, InputStream instream) throws IOException {
        String line;
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = instream.read()) != -1) {
            if (ch == 13) continue;
            if (ch == 10) {
                line = buffer.toString();
                this.log.debug(this.appendMarkerIfNeeded(request, line), line);
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            line = buffer.toString();
            this.log.debug(this.appendMarkerIfNeeded(request, line), line);
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output");
        this.wire(true, outstream);
    }

    public void input(InputStream instream) throws IOException {
        Args.notNull((Object)instream, (String)"Input");
        this.wire(false, instream);
    }

    public void output(byte[] b, int off, int len) throws IOException {
        Args.notNull((Object)b, (String)"Output");
        this.wire(true, new ByteArrayInputStream(b, off, len));
    }

    public void input(byte[] b, int off, int len) throws IOException {
        Args.notNull((Object)b, (String)"Input");
        this.wire(false, new ByteArrayInputStream(b, off, len));
    }

    public void output(byte[] b) throws IOException {
        Args.notNull((Object)b, (String)"Output");
        this.wire(true, new ByteArrayInputStream(b));
    }

    public void input(byte[] b) throws IOException {
        Args.notNull((Object)b, (String)"Input");
        this.wire(false, new ByteArrayInputStream(b));
    }

    public void output(int b) throws IOException {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) throws IOException {
        this.input(new byte[]{(byte)b});
    }

    public void output(String s) throws IOException {
        Args.notNull((Object)s, (String)"Output");
        this.output(s.getBytes());
    }

    public void input(String s) throws IOException {
        Args.notNull((Object)s, (String)"Input");
        this.input(s.getBytes());
    }

    private Marker appendMarkerIfNeeded(boolean request, String line) {
        if (request) {
            Matcher matcher = REQUEST_LINE_PATTERN.matcher(line);
            if (matcher.find()) {
                return Logging.HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_OUTGOING;
            }
        } else {
            Matcher matcher = RESPONSE_LINE_PATTERN.matcher(line);
            if (matcher.find()) {
                return Logging.HTTP_CLIENT_WIRE_LOG_TIMESTAMP_MARKER_INCOMING;
            }
        }
        return null;
    }
}

