/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.model.iface.SubmitContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WsaRequestFilter
extends AbstractRequestFilter {
    public static final Logger log = LogManager.getLogger(WsaRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        if (!(wsdlRequest instanceof WsdlRequest) || !((WsdlRequest)wsdlRequest).isWsAddressing()) {
            return;
        }
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn("Missing request content in context, skipping ws-addressing");
        } else {
            ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)context.getProperty("httpMethod");
            WsdlOperation operation = ((WsdlRequest)wsdlRequest).getOperation();
            SoapVersion soapVersion = operation.getInterface().getSoapVersion();
            if ((content = new WsaUtils(content, soapVersion, operation, context).addWSAddressingRequest((WsdlRequest)wsdlRequest, httpMethod)) != null) {
                context.setProperty("requestContent", content);
            }
        }
    }
}

