/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StripWhitespacesRequestFilter
extends AbstractRequestFilter {
    private static final Logger log = LogManager.getLogger(StripWhitespacesRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        if (!wsdlRequest.isStripWhitespaces()) {
            return;
        }
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn("Missing request content in context, skipping stripWhitespaces");
        } else {
            content = XmlUtils.stripWhitespaces(content);
            context.setProperty("requestContent", content);
        }
    }
}

