/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.RequestFilterFactory;
import com.eviware.soapui.impl.wsdl.submit.RequestTransport;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportFactory;
import com.eviware.soapui.impl.wsdl.submit.filters.EndpointRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.EndpointStrategyRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.GlobalHttpHeadersRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpCompressionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpPackagingResponseFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpSettingsRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.OAuth2RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PostPackagingRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.RemoveEmptyContentRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.RestRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.SoapHeadersRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.StripWhitespacesRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsaRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsdlPackagingRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsrmRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WssAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WssRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpClientRequestTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestTransport;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestTransportRegistry {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String JMS = "jms";
    private static Map<String, RequestTransport> transports = new HashMap<String, RequestTransport>();
    private static Map<String, List<RequestFilter>> addedCustomRequestFilters = new HashMap<String, List<RequestFilter>>();
    private static WsdlPackagingRequestFilter wsdlPackagingRequestFilter;

    private static void addListenerRequestFilters(RequestTransport transport) {
        for (RequestFilter filter : SoapUI.getListenerRegistry().getListeners(RequestFilter.class)) {
            transport.addRequestFilter(filter);
        }
    }

    private static void initCustomTransports(List<RequestFilterFactory> filterFactories) {
        for (RequestTransportFactory factory : SoapUI.getFactoryRegistry().getFactories(RequestTransportFactory.class)) {
            RequestTransport transport = factory.newRequestTransport();
            String protocol = factory.getProtocol();
            for (RequestFilterFactory filterFactory : filterFactories) {
                if (!filterFactory.getProtocol().equals(protocol)) continue;
                RequestFilter requestFilter = filterFactory.createRequestFilter();
                transport.addRequestFilter(requestFilter);
                RequestTransportRegistry.addToCustomRequestFilters(protocol, requestFilter);
            }
            transports.put(protocol, transport);
        }
    }

    private static void addToCustomRequestFilters(String protocol, RequestFilter requestFilter) {
        if (!addedCustomRequestFilters.containsKey(protocol)) {
            addedCustomRequestFilters.put(protocol, new ArrayList());
        }
        addedCustomRequestFilters.get(protocol).add(requestFilter);
    }

    public static void removeRequestFilterFactory(RequestFilterFactory factory) {
        String protocol = factory.getProtocol();
        if (addedCustomRequestFilters.containsKey(protocol)) {
            for (RequestFilter filter : addedCustomRequestFilters.get(protocol)) {
                for (RequestTransport transport : transports.values()) {
                    transport.removeRequestFilter(filter);
                }
            }
            addedCustomRequestFilters.remove(protocol);
        }
    }

    public static synchronized RequestTransport getTransport(String endpoint, SubmitContext submitContext) throws MissingTransportException, CannotResolveJmsTypeException {
        int ix = endpoint.indexOf("://");
        if (ix == -1) {
            throw new MissingTransportException("Missing protocol in endpoint [" + endpoint + "]");
        }
        String protocol = endpoint.substring(0, ix).toLowerCase();
        RequestTransport transport = transports.get(protocol);
        if (transport == null) {
            throw new MissingTransportException("Missing transport for protocol [" + protocol + "]");
        }
        return transport;
    }

    public static synchronized RequestTransport getTransport(String protocol) throws MissingTransportException {
        RequestTransport transport = transports.get(protocol);
        if (transport == null) {
            throw new MissingTransportException("Missing transport for protocol [" + protocol + "]");
        }
        return transport;
    }

    public static void addTransport(String key, RequestTransport rt) {
        transports.put(key, rt);
    }

    public static void removeFactory(RequestTransportFactory factory) {
        RequestTransport transport = factory.newRequestTransport();
        for (Map.Entry<String, RequestTransport> transportEntry : transports.entrySet()) {
            if (!transportEntry.getValue().getClass().equals(transport.getClass())) continue;
            transports.remove(transportEntry.getKey());
            break;
        }
    }

    static {
        HttpClientRequestTransport httpTransport = new HttpClientRequestTransport();
        HermesJmsRequestTransport jmsTransport = new HermesJmsRequestTransport();
        List<RequestFilterFactory> filterFactories = SoapUI.getFactoryRegistry().getFactories(RequestFilterFactory.class);
        httpTransport.addRequestFilter(new EndpointRequestFilter());
        httpTransport.addRequestFilter(new HttpSettingsRequestFilter());
        httpTransport.addRequestFilter(new RestRequestFilter());
        httpTransport.addRequestFilter(new SoapHeadersRequestFilter());
        httpTransport.addRequestFilter(new HttpAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new WssAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new PropertyExpansionRequestFilter());
        httpTransport.addRequestFilter(new RemoveEmptyContentRequestFilter());
        httpTransport.addRequestFilter(new StripWhitespacesRequestFilter());
        httpTransport.addRequestFilter(new EndpointStrategyRequestFilter());
        httpTransport.addRequestFilter(new WsaRequestFilter());
        httpTransport.addRequestFilter(new WsrmRequestFilter());
        httpTransport.addRequestFilter(new WssRequestFilter());
        httpTransport.addRequestFilter(new OAuth2RequestFilter());
        httpTransport.addRequestFilter(new GlobalHttpHeadersRequestFilter());
        RequestTransportRegistry.addListenerRequestFilters(httpTransport);
        for (RequestFilterFactory factory : filterFactories) {
            String protocol = factory.getProtocol();
            if (!protocol.equals(HTTP) && !protocol.equals(HTTPS)) continue;
            RequestFilter requestFilter = factory.createRequestFilter();
            httpTransport.addRequestFilter(requestFilter);
            RequestTransportRegistry.addToCustomRequestFilters(protocol, requestFilter);
        }
        wsdlPackagingRequestFilter = new WsdlPackagingRequestFilter();
        httpTransport.addRequestFilter(wsdlPackagingRequestFilter);
        httpTransport.addRequestFilter(new HttpCompressionRequestFilter());
        httpTransport.addRequestFilter(new HttpPackagingResponseFilter());
        httpTransport.addRequestFilter(new PostPackagingRequestFilter());
        transports.put(HTTP, httpTransport);
        transports.put(HTTPS, httpTransport);
        jmsTransport.addRequestFilter(new WssAuthenticationRequestFilter());
        jmsTransport.addRequestFilter(new PropertyExpansionRequestFilter());
        jmsTransport.addRequestFilter(new RemoveEmptyContentRequestFilter());
        jmsTransport.addRequestFilter(new StripWhitespacesRequestFilter());
        jmsTransport.addRequestFilter(new WsaRequestFilter());
        jmsTransport.addRequestFilter(new WssRequestFilter());
        RequestTransportRegistry.addListenerRequestFilters(jmsTransport);
        for (RequestFilterFactory factory : filterFactories) {
            if (!factory.getProtocol().equals(JMS)) continue;
            RequestFilter requestFilter = factory.createRequestFilter();
            jmsTransport.addRequestFilter(requestFilter);
            RequestTransportRegistry.addToCustomRequestFilters(JMS, requestFilter);
        }
        transports.put(JMS, jmsTransport);
        RequestTransportRegistry.initCustomTransports(filterFactories);
        SoapUI.getFactoryRegistry().addFactoryRegistryListener(new SoapUIFactoryRegistryListener(){

            @Override
            public void factoryAdded(Class<?> factoryType, Object factory) {
                if (factory instanceof RequestTransportFactory) {
                    RequestTransportFactory transportFactory = (RequestTransportFactory)factory;
                    RequestTransportRegistry.addTransport(transportFactory.getProtocol(), transportFactory.newRequestTransport());
                }
                if (factory instanceof RequestFilterFactory) {
                    RequestFilterFactory requestFilterFactory = (RequestFilterFactory)factory;
                    RequestFilter filter = requestFilterFactory.createRequestFilter();
                    String protocol = requestFilterFactory.getProtocol();
                    if (protocol.startsWith(RequestTransportRegistry.HTTP)) {
                        RequestTransport transport = (RequestTransport)transports.get(RequestTransportRegistry.HTTP);
                        transport.insertRequestFilter(filter, wsdlPackagingRequestFilter);
                    } else {
                        RequestTransport transport = (RequestTransport)transports.get(protocol);
                        if (transport != null) {
                            transport.addRequestFilter(filter);
                        }
                    }
                    RequestTransportRegistry.addToCustomRequestFilters(protocol, filter);
                }
            }

            @Override
            public void factoryRemoved(Class<?> factoryType, Object factory) {
                if (factory instanceof RequestTransportFactory) {
                    RequestTransportRegistry.removeFactory((RequestTransportFactory)factory);
                }
                if (factory instanceof RequestFilterFactory) {
                    RequestTransportRegistry.removeRequestFilterFactory((RequestFilterFactory)factory);
                }
            }
        });
    }

    public static class MissingTransportException
    extends Exception {
        public MissingTransportException(String msg) {
            super(msg);
        }
    }

    public static class CannotResolveJmsTypeException
    extends Exception {
        public CannotResolveJmsTypeException(String msg) {
            super(msg);
        }
    }
}

