/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testsuite;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestSuiteRunner;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestRunLogTestRunListener;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.panels.testsuite.JTestSuiteTestCaseList;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunner;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JFocusableComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.ui.support.KeySensitiveModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class WsdlTestSuiteDesktopPanel
extends KeySensitiveModelItemDesktopPanel<WsdlTestSuite> {
    private JProgressBar progressBar;
    private JTestSuiteTestCaseList testCaseList;
    private RunAction runAction = new RunAction();
    private CancelAction cancelAction = new CancelAction();
    private JToggleButton sequentialButton;
    private JToggleButton parallellButton;
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private final InternalTestSuiteRunListener testSuiteRunListener = new InternalTestSuiteRunListener();
    private JTextArea descriptionArea;
    private PropertyHolderTable propertiesTable;
    private JTestRunLog testRunLog;
    private GroovyEditorComponent tearDownGroovyEditor;
    private GroovyEditorComponent setupGroovyEditor;
    private JInspectorPanel testCaseListInspectorPanel;
    private JInspectorPanel inspectorPanel;
    private WsdlTestSuiteRunner testSuiteRunner;

    public WsdlTestSuiteDesktopPanel(WsdlTestSuite testSuite) {
        super(testSuite);
        this.buildUI();
        testSuite.addTestSuiteListener(this.testSuiteListener);
        testSuite.addTestSuiteRunListener(this.testSuiteRunListener);
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
        this.setPreferredSize(new Dimension(500, 500));
    }

    private JComponent buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildTabs());
        this.inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildRunLog(), "TestSuite Log", "Log of executed TestCases and TestSteps", true));
        if (StringUtils.hasContent(((WsdlTestSuite)this.getModelItem()).getDescription()) && ((WsdlTestSuite)this.getModelItem()).getSettings().getBoolean(UISettings.SHOW_DESCRIPTIONS)) {
            this.testCaseListInspectorPanel.setCurrentInspector("Description");
        }
        return this.inspectorPanel.getComponent();
    }

    private JComponent buildRunLog() {
        this.testRunLog = new JTestRunLog(((WsdlTestSuite)this.getModelItem()).getSettings());
        return this.testRunLog;
    }

    protected JTestSuiteTestCaseList getTestCaseList() {
        return this.testCaseList;
    }

    private JComponent buildToolbar() {
        this.cancelAction.setEnabled(false);
        this.runAction.setEnabled(((WsdlTestSuite)this.getModelItem()).getTestCaseCount() > 0);
        JXToolBar toolbar = UISupport.createToolbar();
        this.addToolbarActions(toolbar);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/Functional-Testing/structuring-and-running-tests.html")));
        this.progressBar = new JProgressBar(0, ((WsdlTestSuite)this.getModelItem()).getTestCaseCount());
        JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 10, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar, "First");
        panel.add((Component)progressPanel, "Center");
        return panel;
    }

    protected void addToolbarActions(JXToolBar toolbar) {
        toolbar.add(UISupport.createToolbarButton(this.runAction));
        toolbar.add(UISupport.createToolbarButton(this.cancelAction));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sequentialButton = new JToggleButton(UISupport.createImageIcon("/sequential.gif"), true);
        this.sequentialButton.setToolTipText("The selected TestCases are run in sequence");
        this.sequentialButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.sequentialButton.setSelected(((WsdlTestSuite)this.getModelItem()).getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL);
        this.sequentialButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).setRunType(TestSuite.TestSuiteRunType.SEQUENTIAL);
            }
        });
        buttonGroup.add(this.sequentialButton);
        this.parallellButton = new JToggleButton(UISupport.createImageIcon("/parallell.gif"));
        this.parallellButton.setToolTipText("The selected TestCases are run in parallel");
        this.parallellButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.parallellButton.setSelected(((WsdlTestSuite)this.getModelItem()).getRunType() == TestSuite.TestSuiteRunType.PARALLEL);
        this.parallellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).setRunType(TestSuite.TestSuiteRunType.PARALLEL);
            }
        });
        buttonGroup.add(this.parallellButton);
        toolbar.add(this.sequentialButton);
        toolbar.add(this.parallellButton);
    }

    private JComponent buildTabs() {
        JTabbedPane tabs = new JTabbedPane(1);
        this.testCaseListInspectorPanel = JInspectorPanelFactory.build(this.buildTestCaseList((WsdlTestSuite)this.getModelItem()));
        tabs.addTab("TestCases", this.testCaseListInspectorPanel.getComponent());
        this.addTabs(tabs, this.testCaseListInspectorPanel);
        tabs.setTabLayoutPolicy(1);
        return UISupport.createTabPanel(tabs, true);
    }

    protected void addTabs(JTabbedPane tabs, JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JFocusableComponentInspector<JPanel>(this.buildDescriptionPanel(), this.descriptionArea, "Description", "Description for this TestSuite", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildPropertiesPanel(), "Properties", "TestSuite level properties", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSetupScriptPanel(), "Setup Script", "Script to run before running the TestSuite"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildTearDownScriptPanel(), "TearDown Script", "Script to run after running the TestSuite"));
    }

    protected GroovyEditorComponent buildTearDownScriptPanel() {
        this.tearDownGroovyEditor = new GroovyEditorComponent(new TearDownScriptGroovyEditorModel(), null);
        return this.tearDownGroovyEditor;
    }

    protected GroovyEditorComponent buildSetupScriptPanel() {
        this.setupGroovyEditor = new GroovyEditorComponent(new SetupScriptGroovyEditorModel(), null);
        return this.setupGroovyEditor;
    }

    private JComponent buildPropertiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = this.createPropertyHolderTable();
        panel.add((Component)this.propertiesTable, "Center");
        return panel;
    }

    protected PropertyHolderTable createPropertyHolderTable() {
        return new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
    }

    private JPanel buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JUndoableTextArea(((WsdlTestSuite)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).setDescription(WsdlTestSuiteDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        UISupport.addTitledBorder(panel, "TestSuite Description");
        return panel;
    }

    protected JComponent buildTestCaseList(WsdlTestSuite testSuite) {
        this.testCaseList = new JTestSuiteTestCaseList(testSuite);
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildTestCaseListToolbar(), "North");
        p.add((Component)new JScrollPane(this.testCaseList), "Center");
        return p;
    }

    private Component buildTestCaseListToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        SwingActionDelegate<?> testCaseDelegate = SwingActionDelegate.createDelegate("AddNewTestCaseAction", (WsdlTestSuite)this.getModelItem(), null, "/testcase.png");
        testCaseDelegate.getMapping().setParam((Object)SoapUIActions.CREATE_TEST_CASE_FROM_TEST_TEST_SUITE_PANEL);
        toolbar.add(UISupport.createToolbarButton(testCaseDelegate));
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/functional-testing/reference/testsuite-reference.html")));
        return toolbar;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.propertiesTable.release();
        this.inspectorPanel.release();
        this.testCaseListInspectorPanel.release();
        this.setupGroovyEditor.getEditor().release();
        this.tearDownGroovyEditor.getEditor().release();
        this.testRunLog.release();
        ((WsdlTestSuite)this.getModelItem()).removeTestSuiteRunListener(this.testSuiteRunListener);
        ((WsdlTestSuite)this.getModelItem()).removeTestSuiteListener(this.testSuiteListener);
        return super.release();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlTestSuite)this.getModelItem()).getProject();
    }

    protected void runTestSuite() {
        this.testSuiteRunner = ((WsdlTestSuite)this.getModelItem()).run(new StringToObjectMap(), true);
    }

    protected void beforeRun() {
        this.runAction.setEnabled(false);
        this.cancelAction.setEnabled(this.testSuiteRunner != null);
        this.testCaseList.setEnabled(false);
        this.progressBar.setForeground(Color.GREEN.darker());
    }

    protected void afterRun(WsdlTestSuiteRunner testSuiteRunner) {
        this.runAction.setEnabled(true);
        this.cancelAction.setEnabled(false);
        this.testCaseList.setEnabled(true);
        this.progressBar.setString(String.valueOf((Object)testSuiteRunner.getStatus()));
        this.progressBar.setForeground(testSuiteRunner.isFailed() ? Color.RED : Color.GREEN.darker());
    }

    public WsdlTestSuiteRunner getTestSuiteRunner() {
        return this.testSuiteRunner;
    }

    @Override
    protected void renameModelItem() {
        SoapUI.getActionRegistry().performAction("RenameTestSuiteAction", (ModelItem)this.getModelItem(), null);
    }

    @Override
    protected void cloneModelItem() {
        SoapUI.getActionRegistry().performAction("CloneTestSuiteAction", (ModelItem)this.getModelItem(), null);
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Runs the selected TestCases");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsdlTestSuiteDesktopPanel.this.runTestSuite();
            Analytics.trackAction(SoapUIActions.RUN_TEST_CASE_FROM_TOOLBAR, "RunType", ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getRunType().name());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop.png"));
            this.putValue("ShortDescription", "Cancels ongoing TestCase runs");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsdlTestSuiteDesktopPanel.this.testSuiteRunner.cancel("Cancelled from UI");
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testCaseAdded(TestCase testCase) {
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getTestCaseCount() > 0);
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            WsdlTestSuiteDesktopPanel.this.runAction.setEnabled(((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getTestCaseCount() > 0);
        }
    }

    private class InternalTestSuiteRunListener
    implements TestSuiteRunListener {
        private TestRunLogTestRunListener runLogListener;
        private AtomicInteger finishCount = new AtomicInteger();

        private InternalTestSuiteRunListener() {
        }

        @Override
        public void afterRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
            WsdlTestSuiteDesktopPanel.this.afterRun((WsdlTestSuiteRunner)testRunner);
        }

        @Override
        public void afterTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCaseRunner testCaseRunner) {
            this.finishCount.incrementAndGet();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsdlTestSuiteDesktopPanel.this.progressBar.setValue(InternalTestSuiteRunListener.this.finishCount.get());
                }
            });
            if (((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
                testCaseRunner.getTestCase().removeTestRunListener(this.runLogListener);
            }
        }

        @Override
        public void beforeRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
            WsdlTestSuiteDesktopPanel.this.beforeRun();
            WsdlTestSuiteDesktopPanel.this.testCaseList.reset();
            WsdlTestSuiteDesktopPanel.this.progressBar.setMaximum(((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getTestCaseCount());
            WsdlTestSuiteDesktopPanel.this.progressBar.setValue(0);
            WsdlTestSuiteDesktopPanel.this.progressBar.setString("");
            this.finishCount.set(0);
            if (this.runLogListener == null) {
                this.runLogListener = new TestRunLogTestRunListener(WsdlTestSuiteDesktopPanel.this.testRunLog, false);
            }
            WsdlTestSuiteDesktopPanel.this.testRunLog.clear();
            if (((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getRunType() == TestSuite.TestSuiteRunType.PARALLEL) {
                WsdlTestSuiteDesktopPanel.this.testRunLog.addText("<log disabled during parallell execution>");
            }
        }

        @Override
        public void beforeTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCase testCase) {
            if (((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
                WsdlTestSuiteDesktopPanel.this.progressBar.setString("Running " + testCase.getName());
                testCase.addTestRunListener(this.runLogListener);
            } else {
                WsdlTestSuiteDesktopPanel.this.progressBar.setString("Starting " + testCase.getName());
            }
        }
    }

    private class TearDownScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public TearDownScriptGroovyEditorModel() {
            super(new String[]{"log", "runner", "context", "testSuite"}, (ModelItem)WsdlTestSuiteDesktopPanel.this.getModelItem(), "TearDown");
        }

        @Override
        public String getScript() {
            return ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getTearDownScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).setTearDownScript(text);
        }

        @Override
        public Action createRunAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MockTestSuiteRunner mockRunner = new MockTestSuiteRunner((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem());
                        ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).runTearDownScript((TestSuiteRunContext)mockRunner.getRunContext(), mockRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class SetupScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public SetupScriptGroovyEditorModel() {
            super(new String[]{"log", "runner", "context", "testSuite"}, (ModelItem)WsdlTestSuiteDesktopPanel.this.getModelItem(), "Setup");
        }

        @Override
        public String getScript() {
            return ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).getSetupScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).setSetupScript(text);
        }

        @Override
        public Action createRunAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MockTestSuiteRunner mockRunner = new MockTestSuiteRunner((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem());
                        ((WsdlTestSuite)WsdlTestSuiteDesktopPanel.this.getModelItem()).runSetupScript((TestSuiteRunContext)mockRunner.getRunContext(), mockRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }
}

