/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.xml.actions.EnableLineNumbersAction;
import com.eviware.soapui.support.xml.actions.FormatXmlAction;
import com.eviware.soapui.support.xml.actions.GoToLineAction;
import com.eviware.soapui.ui.support.FindAndReplaceDialogView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class GroovyEditor
extends JPanel
implements JEditorStatusBar.JEditorStatusBarTarget,
PropertyChangeListener {
    private final RSyntaxTextArea editArea;
    private final GoToLineAction goToLineAction;
    private final EnableLineNumbersAction enableLineNumbersAction;
    private FindAndReplaceDialogView findAndReplaceDialog;
    private FormatXmlAction formatXmlAction;
    private GroovyEditorModel model;
    private final InternalSettingsListener settingsListener;
    private final GroovyDocumentListener groovyDocumentListener;
    private final RTextScrollPane scrollPane;
    private boolean updating;

    public GroovyEditor(GroovyEditorModel model) {
        super(new BorderLayout());
        this.model = model;
        model.addPropertyChangeListener(this);
        Settings settings = model.getSettings();
        Font editorFont = UISupport.getEditorFont(settings);
        this.editArea = new RSyntaxTextArea();
        this.editArea.restoreDefaultSyntaxScheme();
        String defaultScriptLanguage = ((WsdlProject)ModelSupport.getModelItemProject(model.getModelItem())).getDefaultScriptLanguage();
        if (defaultScriptLanguage.equals("Groovy")) {
            this.editArea.setSyntaxEditingStyle("text/groovy");
        } else if (defaultScriptLanguage.equals("Javascript")) {
            this.editArea.setSyntaxEditingStyle("text/javascript");
        }
        this.editArea.setFont(editorFont);
        this.editArea.setBorder((Border)BorderFactory.createMatteBorder(0, 2, 0, 0, Color.WHITE));
        this.editArea.setText(model.getScript());
        this.editArea.setCaretPosition(0);
        this.editArea.setHighlightCurrentLine(false);
        Action runAction = model.getRunAction();
        if (runAction != null) {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt ENTER"), "run-action");
            this.editArea.getActionMap().put("run-action", runAction);
        }
        this.groovyDocumentListener = new GroovyDocumentListener();
        this.editArea.getDocument().addDocumentListener(this.groovyDocumentListener);
        this.settingsListener = new InternalSettingsListener();
        settings.addSettingsListener(this.settingsListener);
        this.scrollPane = new RTextScrollPane((RTextArea)this.editArea, true);
        this.scrollPane.setPreferredSize(new Dimension(500, 300));
        this.add((Component)this.scrollPane);
        UISupport.addPreviewCorner((JScrollPane)this.scrollPane, true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GroovyEditor.this.editArea.requestFocusInWindow();
            }
        });
        JPopupMenu popup = this.editArea.getPopupMenu();
        this.findAndReplaceDialog = new FindAndReplaceDialogView(this.editArea);
        if (UISupport.isMac()) {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("meta F"), this.findAndReplaceDialog);
        } else {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F"), this.findAndReplaceDialog);
        }
        popup.add(this.findAndReplaceDialog);
        popup.addSeparator();
        this.goToLineAction = new GoToLineAction(this.editArea, "Go To Line");
        this.enableLineNumbersAction = new EnableLineNumbersAction(this.scrollPane, "Show Line Numbers");
        popup.add(this.goToLineAction);
        popup.add(this.enableLineNumbersAction);
        this.editArea.getInputMap().put(KeyStroke.getKeyStroke("control G"), this.goToLineAction);
        this.editArea.getInputMap().put(KeyStroke.getKeyStroke("control L"), this.enableLineNumbersAction);
        this.editArea.setComponentPopupMenu(popup);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editArea.setEnabled(enabled);
    }

    public RSyntaxTextArea getEditArea() {
        return this.editArea;
    }

    public void release() {
        if (this.model != null) {
            this.model.getSettings().removeSettingsListener(this.settingsListener);
            this.model.removePropertyChangeListener(this);
        }
        this.model = null;
        this.editArea.getDocument().removeDocumentListener(this.groovyDocumentListener);
    }

    public void selectError(String message) {
        int ix;
        int n = ix = message == null ? -1 : message.indexOf("@ line ");
        if (ix >= 0) {
            try {
                int ix2 = message.indexOf(44, ix);
                int line = ix2 == -1 ? Integer.parseInt(message.substring(ix + 6).trim()) : Integer.parseInt(message.substring(ix + 6, ix2).trim());
                int column = 0;
                if (ix2 != -1 && (ix = message.indexOf("column ", ix2)) >= 0) {
                    ix2 = message.indexOf(46, ix);
                    column = ix2 == -1 ? Integer.parseInt(message.substring(ix + 7).trim()) : Integer.parseInt(message.substring(ix + 7, ix2).trim());
                }
                this.editArea.setCaretPosition(this.editArea.getLineStartOffset(line - 1) + column - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.editArea.requestFocus();
        }
    }

    public void setEditorFont(Font newFont) {
        this.editArea.setFont(newFont);
    }

    @Override
    public void addCaretListener(CaretListener listener) {
        this.editArea.addCaretListener(listener);
    }

    @Override
    public int getCaretPosition() {
        return this.editArea.getCaretPosition();
    }

    @Override
    public int getLineOfOffset(int offset) throws Exception {
        return this.editArea.getLineOfOffset(offset);
    }

    @Override
    public int getLineStartOffset(int line) throws Exception {
        return this.editArea.getLineStartOffset(line);
    }

    @Override
    public void removeCaretListener(CaretListener listener) {
        this.editArea.removeCaretListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("script")) {
            this.updating = true;
            this.editArea.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
    }

    private final class GroovyDocumentListener
    extends DocumentListenerAdapter {
        private GroovyDocumentListener() {
        }

        @Override
        public void update(Document document) {
            if (!GroovyEditor.this.updating) {
                GroovyEditor.this.model.setScript(GroovyEditor.this.editArea.getText());
            }
        }
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private InternalSettingsListener() {
        }

        @Override
        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(UISettings.EDITOR_FONT)) {
                Font newFont = Font.decode(newValue);
                GroovyEditor.this.setEditorFont(newFont);
                GroovyEditor.this.invalidate();
            }
        }

        @Override
        public void settingsReloaded() {
        }
    }
}

