/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntryRegistry;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.CryptoType;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.KeyMaterialWssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssContainerListenerAdapter;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.JTableFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class WSSTabPanel
extends JPanel {
    private static final String ILLEGAL_CRYPTO_TYPE_MESSAGE = "Illegal crypto type";
    private static final int ENTRIES_LIST_COMPONENT_WIDTH = 150;
    private static final int MOVE_UP = -1;
    private static final int MOVE_DOWN = 1;
    @Nonnull
    private JTable keystoreTable;
    @Nonnull
    private JTable truststoreTable;
    @Nonnull
    private RemoveCryptoAction removeKeystoreAction;
    @Nonnull
    private RemoveCryptoAction removeTruststoreAction;
    private RemoveIncomingWssAction removeIncomingWssAction;
    private JTable incomingWssTable;
    private JComboBox incomingWssDecryptionCryptoComboBox;
    private JComboBox incomingWssSignatureCryptoComboBox;
    private JTable outgoingWssTable;
    private RemoveOutgoingWssAction removeOutgoingWssAction;
    private WssEntry selectedEntry;
    private OutgoingWss selectedOutgoing;
    private final WssContainer wssContainer;
    private InternalWssContainerListener wssContainerListener;
    private JButton addOutgoingEntryButton;
    private JButton removeOutgoingEntryButton;
    private JButton moveOutgoingEntryUpButton;
    private JButton moveOutgoingEntryDownButton;
    private JSplitPane entriesSplitPane;
    private JScrollPane entriesListContainer;
    private JList entriesList;
    private DefaultListModel entriesListModel;

    public WSSTabPanel(WssContainer wssContainer) {
        super(new BorderLayout());
        this.wssContainer = wssContainer;
        this.wssContainerListener = new InternalWssContainerListener();
        wssContainer.addWssContainerListener(this.wssContainerListener);
        this.buildUI();
    }

    public void release() {
        this.wssContainer.removeWssContainerListener(this.wssContainerListener);
        ((IncomingWssTableModel)this.incomingWssTable.getModel()).release();
        ((OutgoingWssTableModel)this.outgoingWssTable.getModel()).release();
        ((CryptoTableModel)this.keystoreTable.getModel()).release();
        ((CryptoTableModel)this.truststoreTable.getModel()).release();
        ((KeystoresComboBoxModel)this.incomingWssDecryptionCryptoComboBox.getModel()).release();
        ((KeystoresComboBoxModel)this.incomingWssSignatureCryptoComboBox.getModel()).release();
        this.entriesListModel.removeAllElements();
    }

    private void buildUI() {
        this.add(this.buildMainToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
    }

    private Component buildMainToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/SOAP-and-WSDL/applying-ws-security.html")));
        return toolbar;
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Outgoing WS-Security Configurations", this.buildOutgoingConfigurationsTab());
        tabs.addTab("Incoming WS-Security Configurations", this.buildIncomingConfigurationsTab());
        tabs.addTab("Keystores", this.buildCryptoTable(CryptoType.KEYSTORE));
        tabs.addTab("Truststores", this.buildCryptoTable(CryptoType.TRUSTSTORE));
        tabs.setMinimumSize(new Dimension(10, 10));
        return UISupport.createTabPanel(tabs, true);
    }

    private JPanel buildOutgoingConfigurationsTab() {
        this.outgoingWssTable = JTableFactory.getInstance().makeJTable(new OutgoingWssTableModel());
        this.outgoingWssTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = WSSTabPanel.this.outgoingWssTable.getSelectedRow();
                WSSTabPanel.this.selectedOutgoing = selectedRow == -1 ? null : WSSTabPanel.this.wssContainer.getOutgoingWssAt(selectedRow);
                WSSTabPanel.this.removeOutgoingWssAction.setEnabled(selectedRow != -1);
                WSSTabPanel.this.addOutgoingEntryButton.setEnabled(selectedRow != -1);
                if (WSSTabPanel.this.selectedOutgoing != null) {
                    WSSTabPanel.this.entriesListModel.removeAllElements();
                    for (WssEntry entry : WSSTabPanel.this.selectedOutgoing.getEntries()) {
                        WSSTabPanel.this.entriesListModel.addElement(entry);
                    }
                    WSSTabPanel.this.entriesListContainer.getViewport().add(WSSTabPanel.this.entriesList);
                    WSSTabPanel.this.entriesSplitPane.setRightComponent(new JPanel());
                }
                WSSTabPanel.this.entriesSplitPane.setDividerLocation(150);
            }
        });
        this.outgoingWssTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.outgoingWssTable.getColumnModel().getColumn(2).setCellRenderer(new PasswordTableCellRenderer());
        JPanel outgoingConfigurationSplitPane = new JPanel(new BorderLayout());
        JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(this.outgoingWssTable), this.buildOutgoingWssDetails());
        split.setDividerLocation(140);
        outgoingConfigurationSplitPane.add(this.buildOutgoingWssToolbar(), "North");
        outgoingConfigurationSplitPane.add((Component)split, "Center");
        JPanel outgoingConfigurationsPanel = new JPanel(new BorderLayout());
        outgoingConfigurationsPanel.add((Component)outgoingConfigurationSplitPane, "Center");
        return outgoingConfigurationsPanel;
    }

    private Component buildOutgoingWssToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddOutgoingWssAction()));
        this.removeOutgoingWssAction = new RemoveOutgoingWssAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.removeOutgoingWssAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/soapui-projects/ws-security.html")));
        return toolbar;
    }

    private Component buildOutgoingWssDetails() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildOutgoingEntriesToolbar(), "North");
        panel.add(this.buildOutgoingEntryList(), "Center");
        return panel;
    }

    private Component buildOutgoingEntriesToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addOutgoingEntryButton = UISupport.createToolbarButton(new AddOutgoingEntryAction(), false);
        toolbar.addFixed(this.addOutgoingEntryButton);
        this.removeOutgoingEntryButton = UISupport.createToolbarButton(new RemoveOutgoingEntryAction(), false);
        toolbar.addFixed(this.removeOutgoingEntryButton);
        this.moveOutgoingEntryUpButton = UISupport.createToolbarButton(new MoveOutgoingEntryUpAction(), false);
        toolbar.addFixed(this.moveOutgoingEntryUpButton);
        this.moveOutgoingEntryDownButton = UISupport.createToolbarButton(new MoveOutgoingEntryDownAction(), false);
        toolbar.addFixed(this.moveOutgoingEntryDownButton);
        return toolbar;
    }

    private Component buildOutgoingEntryList() {
        this.entriesSplitPane = UISupport.createHorizontalSplit();
        this.entriesListContainer = new JScrollPane();
        this.entriesListContainer.setMinimumSize(new Dimension(150, 150));
        this.entriesSplitPane.setLeftComponent(this.entriesListContainer);
        this.entriesSplitPane.setDividerLocation(150);
        this.setEntriesSplitPaneToEmpty();
        this.entriesList = new JList();
        this.entriesListModel = new DefaultListModel();
        this.entriesList.setModel(this.entriesListModel);
        this.entriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = WSSTabPanel.this.entriesList.getSelectedIndex();
                WSSTabPanel.this.selectedEntry = WSSTabPanel.this.entriesList.getSelectedIndex() == -1 ? null : (WssEntry)WSSTabPanel.this.entriesListModel.get(selectedIndex);
                WSSTabPanel.this.removeOutgoingEntryButton.setEnabled(WSSTabPanel.this.selectedEntry != null);
                WSSTabPanel.this.moveOutgoingEntryUpButton.setEnabled(selectedIndex > 0);
                WSSTabPanel.this.moveOutgoingEntryDownButton.setEnabled(selectedIndex > -1 && selectedIndex < WSSTabPanel.this.entriesListModel.getSize() - 1);
                if (WSSTabPanel.this.selectedEntry != null) {
                    WSSTabPanel.this.entriesSplitPane.setRightComponent(WSSTabPanel.this.selectedEntry.getConfigurationPanel());
                }
                WSSTabPanel.this.entriesSplitPane.setDividerLocation(150);
            }
        });
        return this.entriesSplitPane;
    }

    private JPanel buildIncomingConfigurationsTab() {
        this.incomingWssTable = JTableFactory.getInstance().makeJTable(new IncomingWssTableModel());
        this.incomingWssTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WSSTabPanel.this.removeIncomingWssAction.setEnabled(WSSTabPanel.this.incomingWssTable.getSelectedRow() != -1);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildIncomingWssToolbar(), "North");
        this.incomingWssDecryptionCryptoComboBox = new JComboBox(new KeystoresComboBoxModel(this.wssContainer, null, false));
        this.incomingWssTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.incomingWssDecryptionCryptoComboBox));
        this.incomingWssSignatureCryptoComboBox = new JComboBox(new KeystoresComboBoxModel(this.wssContainer, null, false));
        this.incomingWssTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.incomingWssSignatureCryptoComboBox));
        this.incomingWssTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        this.incomingWssTable.getColumnModel().getColumn(3).setCellRenderer(new PasswordTableCellRenderer());
        p.add((Component)new JScrollPane(this.incomingWssTable), "Center");
        panel.add((Component)p, "Center");
        return panel;
    }

    private Component buildIncomingWssToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddIncomingWssAction()));
        this.removeIncomingWssAction = new RemoveIncomingWssAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.removeIncomingWssAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/soapui-projects/ws-security.html")));
        return toolbar;
    }

    private JPanel buildCryptoTable(final CryptoType cryptoType) {
        final JTable cryptoTable = JTableFactory.getInstance().makeJTable(new CryptoTableModel(cryptoType));
        switch (cryptoType) {
            case KEYSTORE: {
                this.keystoreTable = cryptoTable;
                break;
            }
            case TRUSTSTORE: {
                this.truststoreTable = cryptoTable;
                break;
            }
            default: {
                throw new IllegalArgumentException(ILLEGAL_CRYPTO_TYPE_MESSAGE);
            }
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildCryptoToolbar(cryptoType), "North");
        cryptoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                switch (cryptoType) {
                    case KEYSTORE: {
                        WSSTabPanel.this.removeKeystoreAction.setEnabled(cryptoTable.getSelectedRow() != -1);
                        break;
                    }
                    case TRUSTSTORE: {
                        WSSTabPanel.this.removeTruststoreAction.setEnabled(cryptoTable.getSelectedRow() != -1);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(WSSTabPanel.ILLEGAL_CRYPTO_TYPE_MESSAGE);
                    }
                }
            }
        });
        cryptoTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        cryptoTable.getColumnModel().getColumn(2).setCellRenderer(new PasswordTableCellRenderer());
        cryptoTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(new JPasswordField()));
        cryptoTable.getColumnModel().getColumn(4).setCellRenderer(new PasswordTableCellRenderer());
        p.add((Component)new JScrollPane(cryptoTable), "Center");
        panel.add((Component)p, "Center");
        return panel;
    }

    private Component buildCryptoToolbar(CryptoType cryptoType) {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddCryptoAction(cryptoType)));
        RemoveCryptoAction removeCryptoAction = new RemoveCryptoAction(cryptoType);
        switch (cryptoType) {
            case KEYSTORE: {
                this.removeKeystoreAction = removeCryptoAction;
                break;
            }
            case TRUSTSTORE: {
                this.removeTruststoreAction = removeCryptoAction;
                break;
            }
            default: {
                throw new IllegalArgumentException(ILLEGAL_CRYPTO_TYPE_MESSAGE);
            }
        }
        toolbar.addFixed(UISupport.createToolbarButton(removeCryptoAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/soapui-projects/ws-security.html")));
        return toolbar;
    }

    private void setEntriesSplitPaneToEmpty() {
        this.entriesListContainer.getViewport().add(new JList());
        this.entriesSplitPane.setRightComponent(new JPanel());
    }

    private JTable getCryptoTable(CryptoType cryptoType) {
        switch (cryptoType) {
            case KEYSTORE: {
                return this.keystoreTable;
            }
            case TRUSTSTORE: {
                return this.truststoreTable;
            }
        }
        throw new IllegalArgumentException(ILLEGAL_CRYPTO_TYPE_MESSAGE);
    }

    private class RemoveCryptoAction
    extends AbstractAction {
        private final CryptoType cryptoType;

        public RemoveCryptoAction(CryptoType cryptoType) {
            this.cryptoType = cryptoType;
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes the selected " + cryptoType + " from this configuration");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable cryptoTable = WSSTabPanel.this.getCryptoTable(this.cryptoType);
            int row = cryptoTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            CryptoTableModel tableModel = (CryptoTableModel)cryptoTable.getModel();
            WssCrypto crypto = tableModel.getCryptoAt(row);
            if (UISupport.confirm("Removes selected " + this.cryptoType + "?", "Remove " + this.cryptoType)) {
                WSSTabPanel.this.wssContainer.removeCrypto(crypto);
            }
        }
    }

    private class RemoveIncomingWssAction
    extends AbstractAction {
        public RemoveIncomingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes the selected Incoming WSS Configuration");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = WSSTabPanel.this.incomingWssTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Removes selected configuration?", "Remove Configuration")) {
                WSSTabPanel.this.wssContainer.removeIncomingWssAt(row);
            }
        }
    }

    private class RemoveOutgoingWssAction
    extends AbstractAction {
        public RemoveOutgoingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes the selected Outgoing WSS Configuration");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = WSSTabPanel.this.outgoingWssTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Removes selected configuration?", "Remove Configuration")) {
                WSSTabPanel.this.wssContainer.removeOutgoingWssAt(row);
                WSSTabPanel.this.setEntriesSplitPaneToEmpty();
            }
        }
    }

    private class InternalWssContainerListener
    extends WssContainerListenerAdapter {
        private InternalWssContainerListener() {
        }

        @Override
        public void outgoingWssAdded(OutgoingWss outgoingWss) {
            ((OutgoingWssTableModel)WSSTabPanel.this.outgoingWssTable.getModel()).outgoingWssAdded(outgoingWss);
        }

        @Override
        public void outgoingWssRemoved(OutgoingWss outgoingWss) {
            ((OutgoingWssTableModel)WSSTabPanel.this.outgoingWssTable.getModel()).outgoingWssRemoved(outgoingWss);
        }

        @Override
        public void outgoingWssEntryAdded(WssEntry entry) {
            if (entry.getOutgoingWss() == WSSTabPanel.this.selectedOutgoing) {
                WSSTabPanel.this.entriesListModel.addElement(entry);
            }
        }

        @Override
        public void outgoingWssEntryRemoved(WssEntry entry) {
            if (entry.getOutgoingWss() == WSSTabPanel.this.selectedOutgoing) {
                WSSTabPanel.this.entriesListModel.removeElement(entry);
            }
        }

        @Override
        public void outgoingWssEntryMoved(WssEntry entry, int offset) {
            if (entry.getOutgoingWss() == WSSTabPanel.this.selectedOutgoing) {
                int indexBeforeMove = WSSTabPanel.this.entriesListModel.indexOf(entry);
                if (offset == -1 && indexBeforeMove > 0 || offset == 1 && indexBeforeMove < WSSTabPanel.this.entriesListModel.size() - 1) {
                    WssEntry adjacentEntry = (WssEntry)WSSTabPanel.this.entriesListModel.get(indexBeforeMove + offset);
                    WSSTabPanel.this.entriesListModel.set(indexBeforeMove + offset, entry);
                    WSSTabPanel.this.entriesListModel.set(indexBeforeMove, adjacentEntry);
                    WSSTabPanel.this.entriesList.setSelectedIndex(indexBeforeMove + offset);
                }
            }
        }

        @Override
        public void incomingWssAdded(IncomingWss incomingWss) {
            ((IncomingWssTableModel)WSSTabPanel.this.incomingWssTable.getModel()).incomingWssAdded(incomingWss);
        }

        @Override
        public void incomingWssRemoved(IncomingWss incomingWss) {
            ((IncomingWssTableModel)WSSTabPanel.this.incomingWssTable.getModel()).incomingWssRemoved(incomingWss);
        }

        @Override
        public void cryptoAdded(WssCrypto crypto) {
            JTable cryptoTable = WSSTabPanel.this.getCryptoTable(crypto.getType());
            ((CryptoTableModel)cryptoTable.getModel()).cryptoAdded(crypto);
        }

        @Override
        public void cryptoRemoved(WssCrypto crypto) {
            JTable cryptoTable = WSSTabPanel.this.getCryptoTable(crypto.getType());
            ((CryptoTableModel)cryptoTable.getModel()).cryptoRemoved(crypto);
        }
    }

    public class IncomingWssTableModel
    extends AbstractTableModel {
        private List<IncomingWss> incomingWss;

        public IncomingWssTableModel() {
            this.incomingWss = WSSTabPanel.this.wssContainer.getIncomingWssList();
        }

        public void release() {
            this.incomingWss = null;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Decrypt Keystore";
                }
                case 2: {
                    return "Signature Keystore";
                }
                case 3: {
                    return "Password";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.incomingWss == null ? 0 : this.incomingWss.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            IncomingWss incoming = this.incomingWss.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return incoming.getName();
                }
                case 1: {
                    return WSSTabPanel.this.wssContainer.getCryptoByName(incoming.getDecryptCrypto());
                }
                case 2: {
                    return WSSTabPanel.this.wssContainer.getCryptoByName(incoming.getSignatureCrypto());
                }
                case 3: {
                    return incoming.getDecryptPassword();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            IncomingWss incoming = this.incomingWss.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    incoming.setDecryptCrypto(aValue == null ? null : aValue.toString());
                    break;
                }
                case 2: {
                    incoming.setSignatureCrypto(aValue == null ? null : aValue.toString());
                    break;
                }
                case 3: {
                    incoming.setDecryptPassword(aValue == null ? null : aValue.toString());
                }
            }
        }

        public void incomingWssAdded(IncomingWss incoming) {
            this.incomingWss.add(incoming);
            this.fireTableRowsInserted(this.incomingWss.size() - 1, this.incomingWss.size() - 1);
        }

        public void incomingWssRemoved(IncomingWss incoming) {
            int ix = this.incomingWss.indexOf(incoming);
            if (ix != -1) {
                this.incomingWss.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }

    public class OutgoingWssTableModel
    extends AbstractTableModel {
        private List<OutgoingWss> outgoingWss;

        public OutgoingWssTableModel() {
            this.outgoingWss = WSSTabPanel.this.wssContainer.getOutgoingWssList();
        }

        public void release() {
            this.outgoingWss = null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Default Username/Alias";
                }
                case 2: {
                    return "Default Password";
                }
                case 3: {
                    return "Actor";
                }
                case 4: {
                    return "Must Understand";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 4 ? Boolean.class : String.class;
        }

        @Override
        public int getRowCount() {
            return this.outgoingWss == null ? 0 : this.outgoingWss.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OutgoingWss outgoing = this.outgoingWss.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return outgoing.getName();
                }
                case 1: {
                    return outgoing.getUsername();
                }
                case 2: {
                    return outgoing.getPassword();
                }
                case 3: {
                    return outgoing.getActor();
                }
                case 4: {
                    return outgoing.getMustUnderstand();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            OutgoingWss outgoing = this.outgoingWss.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    outgoing.setUsername(aValue == null ? null : aValue.toString());
                    break;
                }
                case 2: {
                    outgoing.setPassword(aValue == null ? null : aValue.toString());
                    break;
                }
                case 3: {
                    outgoing.setActor(aValue == null ? null : aValue.toString());
                    break;
                }
                case 4: {
                    outgoing.setMustUnderstand(aValue == null ? false : (Boolean)aValue);
                }
            }
        }

        public void outgoingWssAdded(OutgoingWss outgoing) {
            this.outgoingWss.add(outgoing);
            this.fireTableRowsInserted(this.outgoingWss.size() - 1, this.outgoingWss.size() - 1);
        }

        public void outgoingWssRemoved(OutgoingWss outgoing) {
            int ix = this.outgoingWss.indexOf(outgoing);
            if (ix != -1) {
                this.outgoingWss.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }

    public class CryptoTableModel
    extends AbstractTableModel {
        private static final String DEFAULT_OPTION = "<Default>";
        private List<WssCrypto> cryptos = new ArrayList<WssCrypto>();

        public CryptoTableModel(CryptoType cryptoType) {
            for (WssCrypto crypto : WSSTabPanel.this.wssContainer.getCryptoList()) {
                if (crypto.getType() != cryptoType) continue;
                this.cryptos.add(crypto);
            }
        }

        public void release() {
            this.cryptos = null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Source";
                }
                case 1: {
                    return "Status";
                }
                case 2: {
                    return "Password";
                }
                case 3: {
                    return "Default Alias";
                }
                case 4: {
                    return "Alias Password";
                }
                case 5: {
                    return "Security Provider";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.cryptos == null ? 0 : this.cryptos.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            KeyMaterialWssCrypto crypto = (KeyMaterialWssCrypto)this.cryptos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return crypto.getSource();
                }
                case 1: {
                    return crypto.getStatus();
                }
                case 2: {
                    return crypto.getPassword();
                }
                case 3: {
                    return crypto.getDefaultAlias();
                }
                case 4: {
                    return crypto.getAliasPassword();
                }
                case 5: {
                    return StringUtils.hasContent(crypto.getCryptoProvider()) ? crypto.getCryptoProvider() : DEFAULT_OPTION;
                }
            }
            return null;
        }

        public WssCrypto getCryptoAt(int row) {
            return this.cryptos.get(row);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            KeyMaterialWssCrypto crypto = (KeyMaterialWssCrypto)this.cryptos.get(rowIndex);
            if (aValue == null || aValue.equals(DEFAULT_OPTION)) {
                aValue = "";
            }
            switch (columnIndex) {
                case 2: {
                    crypto.setPassword(aValue.toString());
                    break;
                }
                case 3: {
                    crypto.setDefaultAlias(aValue.toString());
                    break;
                }
                case 4: {
                    crypto.setAliasPassword(aValue.toString());
                    break;
                }
                case 5: {
                    crypto.setCryptoProvider(aValue.toString());
                }
            }
        }

        public void cryptoAdded(WssCrypto crypto) {
            this.cryptos.add(crypto);
            this.fireTableRowsInserted(this.cryptos.size() - 1, this.cryptos.size() - 1);
        }

        public void cryptoRemoved(WssCrypto crypto) {
            int ix = this.cryptos.indexOf(crypto);
            if (ix != -1) {
                this.cryptos.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
            }
        }
    }

    public static class PasswordTableCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        public PasswordTableCellRenderer() {
            this.setEditable(false);
            this.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(table.getBackground());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class AddOutgoingWssAction
    extends AbstractAction {
        public AddOutgoingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a new Outgoing WSS Configuration");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique name for configuration", "New Outgoing WSS Configuration", "");
            if (StringUtils.hasContent(name) && WSSTabPanel.this.wssContainer.getOutgoingWssByName(name) == null) {
                WSSTabPanel.this.wssContainer.addOutgoingWss(name);
                WSSTabPanel.this.outgoingWssTable.setRowSelectionInterval(WSSTabPanel.this.outgoingWssTable.getRowCount() - 1, WSSTabPanel.this.outgoingWssTable.getRowCount() - 1);
            }
        }
    }

    public class AddOutgoingEntryAction
    extends AbstractAction {
        public AddOutgoingEntryAction() {
            this.putValue("ShortDescription", "Adds a new WSS Entry");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WSSTabPanel.this.selectedOutgoing == null) {
                return;
            }
            String type = UISupport.prompt("Select type of entry to add", "Add WSS Entry", WssEntryRegistry.get().getTypes());
            if (type != null) {
                WSSTabPanel.this.selectedOutgoing.addEntry(type);
                WSSTabPanel.this.entriesList.setSelectedIndex(WSSTabPanel.this.entriesListModel.getSize() - 1);
            }
        }
    }

    public class RemoveOutgoingEntryAction
    extends AbstractAction {
        public RemoveOutgoingEntryAction() {
            this.putValue("ShortDescription", "Removes the selected WSS-Entry");
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WSSTabPanel.this.selectedEntry == null) {
                return;
            }
            if (UISupport.confirm("Remove entry [" + WSSTabPanel.this.selectedEntry.getLabel() + "]", "Remove WSS Entry")) {
                WSSTabPanel.this.selectedOutgoing.removeEntry(WSSTabPanel.this.selectedEntry);
                WSSTabPanel.this.entriesSplitPane.setRightComponent(new JPanel());
            }
        }
    }

    private class MoveOutgoingEntryUpAction
    extends AbstractAction {
        public MoveOutgoingEntryUpAction() {
            super("Move entry Up");
            this.putValue("ShortDescription", "Moves selected entry up one row");
            this.putValue("SmallIcon", UISupport.createImageIcon("/up_arrow.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WSSTabPanel.this.selectedOutgoing.moveEntry(WSSTabPanel.this.selectedEntry, -1);
        }
    }

    private class MoveOutgoingEntryDownAction
    extends AbstractAction {
        public MoveOutgoingEntryDownAction() {
            super("Move entry Down");
            this.putValue("ShortDescription", "Moves selected entry down one row");
            this.putValue("SmallIcon", UISupport.createImageIcon("/down_arrow.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WSSTabPanel.this.selectedOutgoing.moveEntry(WSSTabPanel.this.selectedEntry, 1);
        }
    }

    private class AddIncomingWssAction
    extends AbstractAction {
        public AddIncomingWssAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a new Incoming WSS Configuration");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique name for configuration", "New Incoming WSS Configuration", "");
            if (StringUtils.hasContent(name) && WSSTabPanel.this.wssContainer.getIncomingWssByName(name) == null) {
                WSSTabPanel.this.wssContainer.addIncomingWss(name);
                WSSTabPanel.this.incomingWssTable.setRowSelectionInterval(WSSTabPanel.this.incomingWssTable.getRowCount() - 1, WSSTabPanel.this.incomingWssTable.getRowCount() - 1);
            }
        }
    }

    private class AddCryptoAction
    extends AbstractAction {
        private final CryptoType cryptoType;

        public AddCryptoAction(CryptoType cryptoType) {
            this.cryptoType = cryptoType;
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a new " + cryptoType.toString() + " to this configuration");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable cryptoTable = WSSTabPanel.this.getCryptoTable(this.cryptoType);
            File file = UISupport.getFileDialogs().open(this, "Select Key Material", null, null, null);
            if (file != null) {
                String password = new String(UISupport.promptPassword("Specify password for [" + file.getName() + "]", "Add Key Material"));
                WSSTabPanel.this.wssContainer.addCrypto(file.getAbsolutePath(), password, this.cryptoType);
                cryptoTable.setRowSelectionInterval(cryptoTable.getRowCount() - 1, cryptoTable.getRowCount() - 1);
            }
        }
    }

    public class ImportWssSettingsAction
    extends AbstractAction {
        public ImportWssSettingsAction() {
            this.putValue("ShortDescription", "Imports an existing WS-Security configuration from another project");
            this.putValue("SmallIcon", UISupport.createImageIcon("/load_properties.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] names = ModelSupport.getNames(((WorkspaceImpl)SoapUI.getWorkspace()).getOpenProjectList());
            String projectName = UISupport.prompt("Select project to import from", "Import WSS Settings", names);
            if (projectName != null) {
                WsdlProject prj = (WsdlProject)SoapUI.getWorkspace().getProjectByName(projectName);
                WSSTabPanel.this.wssContainer.importConfig(prj.getWssContainer());
            }
        }
    }
}

