/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RecreateMockResponseAction
extends AbstractAction {
    private final MockResponse mockResponse;

    public RecreateMockResponseAction(MockResponse mockResponse) {
        super("Recreate response");
        this.mockResponse = mockResponse;
        this.putValue("SmallIcon", UISupport.createImageIcon("/recreate_request.gif"));
        this.putValue("ShortDescription", "Recreates a default response from the schema");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String req;
        Operation operation = this.mockResponse.getMockOperation().getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        String response = this.mockResponse.getResponseContent();
        if (response != null && response.trim().length() > 0 && !UISupport.confirm("Overwrite current response?", "Recreate response")) {
            return;
        }
        boolean createOptional = this.mockResponse.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
        if (!createOptional) {
            createOptional = UISupport.confirm("Create optional elements in schema?", "Create Request");
        }
        if ((req = operation.createResponse(createOptional)) == null) {
            UISupport.showErrorMessage("Response creation failed");
            return;
        }
        this.mockResponse.setResponseContent(req);
    }
}

