/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIAnalyzeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIReportPanel;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.MetricsPanel;
import com.eviware.soapui.support.components.ProgressDialog;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.wsdl.BindingOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.JXTable;
import org.w3c.dom.Element;

public class WsdlInterfaceDesktopPanel
extends ModelItemDesktopPanel<WsdlInterface> {
    private static final Logger logger = LogManager.getLogger(WsdlInterfaceDesktopPanel.class);
    private JTabbedPane partTabs;
    private List<RSyntaxTextArea> editors = new ArrayList<RSyntaxTextArea>();
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> groupNodes = new HashMap<String, DefaultMutableTreeNode>();
    private Map<String, TreePath> pathMap = new HashMap<String, TreePath>();
    private List<TreePath> navigationHistory = new ArrayList<TreePath>();
    private StringList targetNamespaces = new StringList();
    private int historyIndex;
    private boolean navigating;
    private JEditorStatusBar statusBar;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private InternalProjectListener projectListener;
    private final WsdlInterface iface;
    private JPanel wsiPanel;
    private WSIReportPanel reportPanel;
    private SaveWsiReportAction saveWsiReportAction;
    private MetricsPanel metrics;
    private boolean updatingInterface;
    private OperationsTableModel operationsTableModel;

    public WsdlInterfaceDesktopPanel(WsdlInterface iface) {
        super(iface);
        this.iface = iface;
        try {
            iface.getWsdlContext().loadIfNecessary();
            this.buildUI();
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SoapUI.getDesktop().closeDesktopPanel(WsdlInterfaceDesktopPanel.this);
                }
            });
        }
    }

    private void buildUI() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Overview", this.buildInterfaceOverviewTab());
        tabs.addTab("Service Endpoints", this.buildEndpointsTab());
        tabs.addTab("WSDL Content", this.buildWsdlContentTab());
        tabs.addTab("WS-I Compliance", this.buildWSITab());
        this.add((Component)UISupport.createTabPanel(tabs, true), "Center");
    }

    private Component buildWSITab() {
        this.wsiPanel = new JPanel(new BorderLayout());
        this.wsiPanel.setBackground(Color.WHITE);
        this.wsiPanel.setOpaque(true);
        this.wsiPanel.add(this.builderWsiToolbar(), "North");
        return this.wsiPanel;
    }

    private Component builderWsiToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new RunWSIAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new WSIOptionsAction()));
        toolbar.addRelatedGap();
        this.saveWsiReportAction = new SaveWsiReportAction();
        toolbar.addFixed(UISupport.createToolbarButton(this.saveWsiReportAction));
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/SOAP-and-WSDL/working-with-wsdls.html")));
        return toolbar;
    }

    private Component buildInterfaceOverviewTab() {
        this.metrics = new MetricsPanel();
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/SOAP-and-WSDL/working-with-wsdls.html")));
        this.metrics.add((Component)toolbar, "North");
        MetricsPanel.MetricsSection section = this.metrics.addSection("WSDL Definition");
        try {
            section.addMetric("WSDL URL", MetricsPanel.MetricType.URL).set(this.iface.getDefinition());
            section.addMetric("Namespace").set(this.iface.getBindingName().getNamespaceURI());
            section.addMetric("Binding").set(this.iface.getBindingName().getLocalPart());
            section.addMetric("SOAP Version").set(this.iface.getSoapVersion().toString());
            section.addMetric("Style").set(this.iface.getStyle());
            section.addMetric("WS-A version").set(this.iface.getWsaVersion());
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
        section.finish();
        this.metrics.addSection("Definition Parts");
        section = this.metrics.addSection("Operations");
        this.operationsTableModel = new OperationsTableModel();
        JXTable table = section.addTable(this.operationsTableModel);
        table.getColumn(1).setPreferredWidth(60);
        table.getColumn(2).setPreferredWidth(60);
        section.finish();
        table.packColumn(3, 10);
        if (table.getColumn(3).getPreferredWidth() < 250) {
            table.getColumn(3).setPreferredWidth(250);
        }
        return new JScrollPane(this.metrics);
    }

    private Component buildEndpointsTab() {
        return this.iface.getProject().getEndpointStrategy().getConfigurationPanel(this.iface);
    }

    private JComponent buildWsdlContentTab() {
        this.partTabs = new JTabbedPane();
        this.partTabs.setTabLayoutPolicy(1);
        this.rootNode = new DefaultMutableTreeNode(this.iface.getName());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                InspectItem item;
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath selectionPath;
                if (arg0.getClickCount() > 1 && (selectionPath = WsdlInterfaceDesktopPanel.this.tree.getSelectionPath()) != null && (userObject = (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof InspectItem && (item = (InspectItem)userObject) != null && item.selector != null) {
                    item.selector.selectNode(item);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        JSplitPane split = UISupport.createHorizontalSplit(scrollPane, UISupport.createTabPanel(this.partTabs, true));
        split.setDividerLocation(250);
        split.setResizeWeight(0.3);
        this.initTreeModel(this.iface);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)split, "Center");
        panel.add(this.buildWsdlTabToolbar(), "First");
        this.statusBar = new JEditorStatusBar();
        panel.add((Component)this.statusBar, "Last");
        this.setPreferredSize(new Dimension(600, 500));
        this.projectListener = new InternalProjectListener();
        this.iface.getProject().addProjectListener(this.projectListener);
        return panel;
    }

    private void initTreeModel(WsdlInterface iface) {
        try {
            if (iface.getWsdlContext().loadIfNecessary()) {
                XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Loading Defintion", 3, "Initializing definition..", true);
                Loader loader = new Loader(iface);
                if (progressDialog != null) {
                    progressDialog.setCancelLabel("Run in background");
                }
                progressDialog.run(loader);
                loader = null;
                this.treeModel.nodeStructureChanged(this.rootNode);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private Component buildWsdlTabToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new BackwardAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new ForwardAction()));
        toolbar.addUnrelatedGap();
        JButton button = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("UpdateInterfaceAction", (WsdlInterface)this.getModelItem(), null, "/updateDefinition.gif"));
        button.setText(null);
        toolbar.addFixed(button);
        button = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("ExportDefinitionAction", (WsdlInterface)this.getModelItem(), null, "/export.png"));
        button.setText(null);
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("CreateWsdlDocumentationAction", this.iface, null, "/report.png")));
        toolbar.addFixed(button);
        toolbar.addGlue();
        button = UISupport.createToolbarButton(new ShowOnlineHelpAction("/SOAP-and-WSDL/working-with-wsdls.html"));
        button.setText(null);
        toolbar.addFixed(button);
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlInterface)this.getModelItem()).getProject();
    }

    public List<DefaultMutableTreeNode> mapTreeItems(XmlObject xmlObject, DefaultMutableTreeNode treeRoot, boolean createEmpty, int tabIndex, String groupName, String query, String nameQuery, boolean sort, NodeSelector selector) {
        ArrayList<DefaultMutableTreeNode> resultNodes = new ArrayList<DefaultMutableTreeNode>();
        try {
            XmlObject[] items = xmlObject.selectPath(query);
            ArrayList<DefaultMutableTreeNode> treeNodes = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode root = treeRoot;
            if (groupName != null) {
                String groupKey = new TreePath(root.getPath()).toString() + "/" + groupName;
                if ((root = this.groupNodes.get(groupKey)) == null && (items.length > 0 || createEmpty)) {
                    root = new DefaultMutableTreeNode(groupName);
                    treeRoot.add(root);
                    this.groupNodes.put(groupKey, root);
                } else if (root != null) {
                    Enumeration<TreeNode> children = root.children();
                    while (children.hasMoreElements()) {
                        treeNodes.add((DefaultMutableTreeNode)children.nextElement());
                    }
                }
            }
            if (items.length == 0) {
                return resultNodes;
            }
            for (XmlObject item : items) {
                XmlObject[] selectPath = item.selectPath(nameQuery);
                if (selectPath.length <= 0) continue;
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new InspectItem(item, selectPath[0], tabIndex, selector));
                treeNodes.add(treeNode);
                resultNodes.add(treeNode);
            }
            if (sort) {
                Collections.sort(treeNodes, new Comparator<DefaultMutableTreeNode>(){

                    @Override
                    public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
            }
            root.removeAllChildren();
            for (DefaultMutableTreeNode treeNode : treeNodes) {
                root.add(treeNode);
                String path = "/" + this.getTreeNodeName(treeNode);
                TreePath treePath = new TreePath(treeNode.getPath());
                while (treeNode.getParent() != null) {
                    treeNode = (DefaultMutableTreeNode)treeNode.getParent();
                    path = "/" + this.getTreeNodeName(treeNode) + path;
                }
                this.pathMap.put(path, treePath);
            }
        }
        catch (Throwable e) {
            SoapUI.log("Failed to map items for query [" + query + "]:[" + nameQuery + "]");
            SoapUI.logError(e);
        }
        return resultNodes;
    }

    private String getTreeNodeName(DefaultMutableTreeNode treeNode) {
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof InspectItem) {
            return ((InspectItem)userObject).getName();
        }
        return treeNode.toString();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.projectListener != null) {
            ((WsdlInterface)this.getModelItem()).getProject().removeProjectListener(this.projectListener);
        }
        return this.release();
    }

    private void simpleSelect(InspectItem item, String attribute, String targetGroup) {
        Element elm = item.getElement();
        String type = elm.getAttribute(attribute);
        if (type.length() > 0) {
            TreePath treePath;
            int ix = type.indexOf(58);
            if (ix != -1) {
                type = type.substring(ix + 1);
            }
            if ((treePath = this.pathMap.get("/" + ((WsdlInterface)this.getModelItem()).getName() + "/" + targetGroup + "/" + type)) != null) {
                this.tree.setSelectionPath(treePath);
            }
        }
    }

    private class SaveWsiReportAction
    extends AbstractAction {
        public SaveWsiReportAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/export.png"));
            this.putValue("ShortDescription", "Saved the current WS-I report to a file");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (WsdlInterfaceDesktopPanel.this.reportPanel != null) {
                WsdlInterfaceDesktopPanel.this.reportPanel.getSaveReportAction().actionPerformed(null);
            }
        }
    }

    private final class InspectItem {
        private final XmlObject item;
        private String name;
        private final int tabIndex;
        private XmlLineNumber lineNumber;
        private final NodeSelector selector;

        public InspectItem(XmlObject item, XmlObject nameObj, int tabIndex, NodeSelector selector) {
            this.item = item;
            this.selector = selector;
            this.name = XmlUtils.getNodeValue(nameObj.getDomNode());
            if (this.name == null) {
                this.name = nameObj.toString();
            }
            this.tabIndex = tabIndex;
            ArrayList list = new ArrayList();
            XmlCursor cursor = item.newCursor();
            cursor.getAllBookmarkRefs(list);
            for (Object o : list) {
                if (!(o instanceof XmlLineNumber)) continue;
                this.lineNumber = (XmlLineNumber)o;
            }
            cursor.dispose();
        }

        public String getDescription() {
            return this.getName() + "@" + (String)WsdlInterfaceDesktopPanel.this.targetNamespaces.get(this.tabIndex);
        }

        public String getName() {
            int ix = this.name.indexOf(32);
            return ix == -1 ? this.name : this.name.substring(0, ix);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getLineNumber() {
            return this.lineNumber == null ? -1 : this.lineNumber.getLine() - 1;
        }

        public String toString() {
            return this.name;
        }

        public NodeSelector getSelector() {
            return this.selector;
        }

        public Element getElement() {
            return (Element)this.item.getDomNode();
        }
    }

    private class OperationsTableModel
    extends AbstractTableModel {
        private OperationsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return WsdlInterfaceDesktopPanel.this.iface.getOperationCount();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Use";
                }
                case 2: {
                    return "One-Way";
                }
                case 3: {
                    return "Action";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (WsdlInterfaceDesktopPanel.this.updatingInterface) {
                return "<updating>";
            }
            WsdlOperation operation = WsdlInterfaceDesktopPanel.this.iface.getOperationAt(rowIndex);
            BindingOperation bindingOperation = operation.getBindingOperation();
            switch (columnIndex) {
                case 0: {
                    return operation.getName();
                }
                case 1: {
                    boolean out;
                    boolean in = WsdlUtils.isInputSoapEncoded(bindingOperation);
                    boolean bl = out = operation.isUnidirectional() ? false : WsdlUtils.isOutputSoapEncoded(bindingOperation);
                    if (out && in) {
                        return "SOAP Encoding";
                    }
                    if (!out && !in) {
                        return "Literal";
                    }
                    return "Mixed";
                }
                case 3: {
                    return operation.getAction();
                }
                case 2: {
                    return operation.isUnidirectional();
                }
            }
            return null;
        }
    }

    private class RunWSIAction
    extends AbstractAction {
        public RunWSIAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Creates a WS-I report for this interface");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            WSIAnalyzeAction action = new WSIAnalyzeAction(){

                @Override
                protected void showReport(File reportFile, String configFile) throws Exception {
                    WsdlInterfaceDesktopPanel.this.reportPanel = new WSIReportPanel(reportFile, configFile, null, false);
                    WsdlInterfaceDesktopPanel.this.reportPanel.setPreferredSize(new Dimension(600, 400));
                    if (WsdlInterfaceDesktopPanel.this.wsiPanel.getComponentCount() > 1) {
                        WsdlInterfaceDesktopPanel.this.wsiPanel.remove(1);
                    }
                    WsdlInterfaceDesktopPanel.this.wsiPanel.add((Component)WsdlInterfaceDesktopPanel.this.reportPanel, "Center");
                    WsdlInterfaceDesktopPanel.this.wsiPanel.revalidate();
                    WsdlInterfaceDesktopPanel.this.saveWsiReportAction.setEnabled(true);
                }
            };
            action.perform((Interface)WsdlInterfaceDesktopPanel.this.getModelItem(), null);
        }
    }

    private class WSIOptionsAction
    extends AbstractAction {
        public WSIOptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/preferences.png"));
            this.putValue("ShortDescription", "Sets WS-I report creation options");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SoapUIPreferencesAction.getInstance().show("WS-I Settings");
        }
    }

    private final class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
            if (newLeadSelectionPath != null) {
                DefaultMutableTreeNode tn;
                if (!WsdlInterfaceDesktopPanel.this.navigating) {
                    while (WsdlInterfaceDesktopPanel.this.historyIndex < WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1) {
                        TreePath path = (TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.remove(WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1);
                        WsdlInterfaceDesktopPanel.this.navigationHistory.add(WsdlInterfaceDesktopPanel.this.historyIndex++, path);
                    }
                    WsdlInterfaceDesktopPanel.this.navigationHistory.add(newLeadSelectionPath);
                    WsdlInterfaceDesktopPanel.this.historyIndex = WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1;
                }
                if ((tn = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent()).getUserObject() instanceof InspectItem) {
                    InspectItem item = (InspectItem)tn.getUserObject();
                    WsdlInterfaceDesktopPanel.this.partTabs.setSelectedIndex(item.getTabIndex());
                    WsdlInterfaceDesktopPanel.this.statusBar.setInfo(item.getDescription());
                    RSyntaxTextArea editor = (RSyntaxTextArea)WsdlInterfaceDesktopPanel.this.editors.get(item.getTabIndex());
                    int lineNumber = item.getLineNumber();
                    try {
                        if (lineNumber > 0 && editor.getLineStartOffset(lineNumber) >= 0) {
                            editor.setCaretPosition(editor.getLineStartOffset(lineNumber));
                        } else {
                            editor.setCaretPosition(0);
                        }
                    }
                    catch (BadLocationException e1) {
                        SoapUI.logError(e1, "Unable to reset the caret position");
                    }
                }
                WsdlInterfaceDesktopPanel.this.tree.scrollPathToVisible(newLeadSelectionPath);
                WsdlInterfaceDesktopPanel.this.tree.expandPath(newLeadSelectionPath);
            }
        }
    }

    private final class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void interfaceUpdated(Interface iface) {
            if (iface == WsdlInterfaceDesktopPanel.this.getModelItem()) {
                WsdlInterfaceDesktopPanel.this.updatingInterface = true;
                WsdlInterfaceDesktopPanel.this.partTabs.removeAll();
                WsdlInterfaceDesktopPanel.this.tree.setSelectionRow(-1);
                WsdlInterfaceDesktopPanel.this.rootNode.removeAllChildren();
                WsdlInterfaceDesktopPanel.this.editors.clear();
                WsdlInterfaceDesktopPanel.this.groupNodes.clear();
                WsdlInterfaceDesktopPanel.this.pathMap.clear();
                WsdlInterfaceDesktopPanel.this.targetNamespaces.clear();
                WsdlInterfaceDesktopPanel.this.initTreeModel((WsdlInterface)iface);
                WsdlInterfaceDesktopPanel.this.operationsTableModel.fireTableDataChanged();
                WsdlInterfaceDesktopPanel.this.updatingInterface = false;
            }
        }
    }

    private class Loader
    implements Worker {
        private static final String DEFINITION_PARTS_SECTION = "Definition Parts";
        private ProgressDialog progressDialog;
        private final WsdlInterface iface;
        private JProgressBar progressBar;

        public Loader(WsdlInterface iface) {
            this.iface = iface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct(XProgressMonitor monitor) {
            MetricsPanel.MetricsSection section = WsdlInterfaceDesktopPanel.this.metrics.getSection(DEFINITION_PARTS_SECTION);
            section.clear();
            try {
                List<InterfaceDefinitionPart> schemas = this.iface.getWsdlContext().getDefinitionParts();
                int tabCount = WsdlInterfaceDesktopPanel.this.partTabs.getTabCount();
                for (InterfaceDefinitionPart part : schemas) {
                    this.addTab(part.getUrl(), part.getContent());
                }
                while (tabCount-- > 0) {
                    WsdlInterfaceDesktopPanel.this.partTabs.remove(0);
                }
                Iterator<InterfaceDefinitionPart> iterator = null;
                return iterator;
            }
            catch (Exception e) {
                logger.error("Failed to load WSDL; " + e.getClass().getSimpleName() + "; " + e.getMessage());
                WsdlInterfaceDesktopPanel.this.add((Component)new JLabel("Failed to load WSDL; " + e.toString()), "North");
                SoapUI.logError(e);
                Exception exception = e;
                return exception;
            }
            finally {
                section.finish();
            }
        }

        private void addTab(String url, String content) throws Exception {
            int ix;
            int n = ix = url.startsWith("file:") ? url.lastIndexOf(File.separatorChar) : url.lastIndexOf(47);
            if (ix == -1) {
                ix = url.lastIndexOf(47);
            }
            String title = url.substring(ix + 1);
            WsdlInterfaceDesktopPanel.this.metrics.getSection(DEFINITION_PARTS_SECTION).addMetric(title, MetricsPanel.MetricType.URL).set(url);
            if (this.progressBar != null) {
                this.progressBar.setString(title);
            } else if (this.progressDialog != null) {
                this.progressDialog.setProgress(1, title);
            }
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(url);
            label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            panel.add((Component)label, "North");
            RSyntaxTextArea inputArea = SyntaxEditorUtil.createDefaultXmlSyntaxTextArea();
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(XmlUtils.createXmlObject(content), (Writer)writer);
            String xmlString = writer.toString();
            XmlObject xmlObject = XmlUtils.createXmlObject(xmlString, new XmlOptions().setLoadLineNumbers());
            inputArea.setText(xmlString);
            inputArea.setEditable(false);
            inputArea.setFont(UISupport.getEditorFont());
            JPanel p = new JPanel(new BorderLayout());
            RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)inputArea);
            UISupport.addPreviewCorner((JScrollPane)scrollPane, true);
            p.add((Component)scrollPane, "Center");
            panel.add((Component)p, "Center");
            WsdlInterfaceDesktopPanel.this.partTabs.addTab(title, panel);
            if (WsdlInterfaceDesktopPanel.this.tree != null) {
                this.initInspectionTree(xmlObject, inputArea);
            }
        }

        private void initInspectionTree(XmlObject xmlObject, RSyntaxTextArea inputArea) {
            DefaultMutableTreeNode treeRoot = WsdlInterfaceDesktopPanel.this.rootNode;
            WsdlInterfaceDesktopPanel.this.targetNamespaces.add(SchemaUtils.getTargetNamespace(xmlObject));
            int tabCount = WsdlInterfaceDesktopPanel.this.partTabs.getTabCount() - 1;
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Complex Types", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:complexType[@name!='']", "@name", true, null);
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Simple Types", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:simpleType[@name!='']", "@name", true, null);
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Anonymous Complex Types", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:complexType[not(exists(@name))]", "parent::node()/@name", true, null);
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Global Elements", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:schema/xs:element[@name!='']", "@name", true, new GlobalElementSelector());
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Schemas", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:schema", "@targetNamespace", true, null);
            List<DefaultMutableTreeNode> messages = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Messages", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:message", "@name", true, null);
            for (DefaultMutableTreeNode defaultMutableTreeNode : messages) {
                WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)defaultMutableTreeNode.getUserObject()).item, defaultMutableTreeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:part", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';concat('part: name=[', @name, '] type=[', @type, '] element=[', @element, ']' )", true, new PartSelector());
            }
            List<DefaultMutableTreeNode> portTypes = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "PortTypes", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:portType", "@name", true, null);
            for (DefaultMutableTreeNode defaultMutableTreeNode : portTypes) {
                List<DefaultMutableTreeNode> operationNodes = WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)defaultMutableTreeNode.getUserObject()).item, defaultMutableTreeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:operation", "@name", true, null);
                for (DefaultMutableTreeNode treeNode2 : operationNodes) {
                    WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode2.getUserObject()).item, treeNode2, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:*", "concat( @name, ' [', local-name(), '], message=[', @message, ']' )", false, new MessageSelector());
                }
            }
            List<DefaultMutableTreeNode> list = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Bindings", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:binding", "declare namespace wsdlsoap='http://schemas.xmlsoap.org/wsdl/soap/';concat( @name, ' [style=', wsdlsoap:binding[1]/@style, ']' )", true, null);
            for (DefaultMutableTreeNode treeNode : list) {
                List<DefaultMutableTreeNode> operationNodes = WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:operation", "declare namespace wsdlsoap='http://schemas.xmlsoap.org/wsdl/soap/';concat( @name, ' [soapAction=', wsdlsoap:operation/@soapAction, ']' )", true, null);
                for (DefaultMutableTreeNode treeNode2 : operationNodes) {
                    WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode2.getUserObject()).item, treeNode2, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:*", "concat( @name, ' [', local-name(), ']' )", false, new BindingOperationSelector());
                }
            }
            List<DefaultMutableTreeNode> list2 = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Services", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:service", "@name", true, null);
            for (DefaultMutableTreeNode treeNode : list2) {
                WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:port", "concat( 'port: name=[', @name, '] binding=[', @binding, ']' )", true, new PortSelector());
            }
            WsdlInterfaceDesktopPanel.this.tree.expandRow(0);
            WsdlInterfaceDesktopPanel.this.editors.add(inputArea);
        }

        @Override
        public void finished() {
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
            this.progressDialog = null;
        }

        @Override
        public boolean onCancel() {
            this.progressBar = new JProgressBar(0, 1);
            this.progressBar.setSize(new Dimension(120, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Loading Definition..");
            this.progressBar.setIndeterminate(true);
            ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            builder.addFixed((JComponent)this.progressBar);
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            WsdlInterfaceDesktopPanel.this.partTabs.addTab("Loading.. ", builder.getPanel());
            return true;
        }
    }

    private class BackwardAction
    extends AbstractAction {
        public BackwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (WsdlInterfaceDesktopPanel.this.historyIndex > 0) {
                WsdlInterfaceDesktopPanel.this.historyIndex--;
                WsdlInterfaceDesktopPanel.this.navigating = true;
                WsdlInterfaceDesktopPanel.this.tree.setSelectionPath((TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.get(WsdlInterfaceDesktopPanel.this.historyIndex));
                WsdlInterfaceDesktopPanel.this.navigating = false;
            }
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (WsdlInterfaceDesktopPanel.this.historyIndex < WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1) {
                WsdlInterfaceDesktopPanel.this.historyIndex++;
                WsdlInterfaceDesktopPanel.this.navigating = true;
                WsdlInterfaceDesktopPanel.this.tree.setSelectionPath((TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.get(WsdlInterfaceDesktopPanel.this.historyIndex));
                WsdlInterfaceDesktopPanel.this.navigating = false;
            }
        }
    }

    protected static interface NodeSelector {
        public void selectNode(InspectItem var1);
    }

    public class BindingOperationSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String name = elm.getAttribute("name");
            Element operationElm = (Element)elm.getParentNode();
            Element bindingElm = (Element)operationElm.getParentNode();
            String type = bindingElm.getAttribute("type");
            if (type.length() > 0) {
                TreePath treePath;
                int ix = type.indexOf(58);
                if (ix != -1) {
                    type = type.substring(ix + 1);
                }
                if ((treePath = (TreePath)WsdlInterfaceDesktopPanel.this.pathMap.get("/" + ((WsdlInterface)WsdlInterfaceDesktopPanel.this.getModelItem()).getName() + "/PortTypes/" + type + "/" + operationElm.getAttribute("name") + "/" + name)) != null) {
                    WsdlInterfaceDesktopPanel.this.tree.setSelectionPath(treePath);
                }
            }
        }
    }

    public class PortSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "binding", "Bindings");
        }
    }

    public class GlobalElementSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
        }
    }

    public class MessageSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "message", "Messages");
        }
    }

    public class PartSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String type = elm.getAttribute("type");
            String element = elm.getAttribute("element");
            if (type.length() > 0) {
                WsdlInterfaceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
            } else if (element.length() > 0) {
                WsdlInterfaceDesktopPanel.this.simpleSelect(item, "element", "Global Elements");
            }
        }
    }
}

