/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.monitor.SoapMonitorAction;
import com.eviware.soapui.impl.wsdl.monitor.ContentTypes;
import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorListenerCallBack;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedCopyMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedDeleteMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGenericMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedHeadMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedLockMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedOptionsMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPatchMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPropFindMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPurgeMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPutMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedTraceMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedUnlockMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpVersion;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.mortbay.util.IO;

public class ProxyServlet
implements Servlet {
    protected ServletConfig config;
    protected ServletContext context;
    protected WsdlProject project;
    protected HttpContext httpState = new BasicHttpContext();
    protected Settings settings;
    protected final SoapMonitorListenerCallBack listenerCallBack;
    private ContentTypes includedContentTypes = SoapMonitorAction.defaultContentTypes();
    static HashSet<String> dontProxyHeaders = new HashSet();

    public ProxyServlet(WsdlProject project, SoapMonitorListenerCallBack listenerCallBack) {
        this.listenerCallBack = listenerCallBack;
        this.project = project;
        this.settings = project.getSettings();
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "SoapUI Monitor";
    }

    public void setIncludedContentTypes(ContentTypes includedContentTypes) {
        this.includedContentTypes = includedContentTypes != null ? includedContentTypes : SoapMonitorAction.defaultContentTypes();
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.listenerCallBack.fireOnRequest(this.project, request, response);
        if (response.isCommitted()) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExtendedHttpMethod method = httpRequest.getMethod().equals("GET") ? new ExtendedGetMethod() : (httpRequest.getMethod().equals("POST") ? new ExtendedPostMethod() : (httpRequest.getMethod().equals("PUT") ? new ExtendedPutMethod() : (httpRequest.getMethod().equals("DELETE") ? new ExtendedDeleteMethod() : (httpRequest.getMethod().equals("HEAD") ? new ExtendedHeadMethod() : (httpRequest.getMethod().equals("OPTIONS") ? new ExtendedOptionsMethod() : (httpRequest.getMethod().equals("TRACE") ? new ExtendedTraceMethod() : (httpRequest.getMethod().equals("PATCH") ? new ExtendedPatchMethod() : (httpRequest.getMethod().equals("PROPFIND") ? new ExtendedPropFindMethod() : (httpRequest.getMethod().equals("LOCK") ? new ExtendedLockMethod() : (httpRequest.getMethod().equals("UNLOCK") ? new ExtendedUnlockMethod() : (httpRequest.getMethod().equals("COPY") ? new ExtendedCopyMethod() : (httpRequest.getMethod().equals("PURGE") ? new ExtendedPurgeMethod() : new ExtendedGenericMethod(httpRequest.getMethod())))))))))))));
        method.setDecompress(false);
        ByteArrayOutputStream requestBody = null;
        if (method instanceof HttpEntityEnclosingRequest) {
            requestBody = Tools.readAll((InputStream)request.getInputStream(), 0L);
            ByteArrayEntity entity = new ByteArrayEntity(requestBody.toByteArray());
            entity.setContentType(request.getContentType());
            ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)entity);
        }
        JProxyServletWsdlMonitorMessageExchange capturedData = new JProxyServletWsdlMonitorMessageExchange(this.project);
        capturedData.setRequestHost(httpRequest.getServerName());
        capturedData.setRequestMethod(httpRequest.getMethod());
        capturedData.setRequestHeader(httpRequest);
        capturedData.setHttpRequestParameters(httpRequest);
        capturedData.setQueryParameters(httpRequest.getQueryString());
        capturedData.setTargetURL(httpRequest.getRequestURL().toString());
        String connectionHeader = httpRequest.getHeader("Connection");
        if (connectionHeader != null && !(connectionHeader = connectionHeader.toLowerCase()).contains("keep-alive") && !connectionHeader.contains("close")) {
            connectionHeader = null;
        }
        boolean xForwardedFor = false;
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hdr = (String)headerNames.nextElement();
            String lhdr = hdr.toLowerCase();
            if (dontProxyHeaders.contains(lhdr) || connectionHeader != null && connectionHeader.contains(lhdr)) continue;
            Enumeration vals = httpRequest.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null) continue;
                method.setHeader(lhdr, val);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
            }
        }
        method.setHeader("Via", "SoapUI Monitor");
        if (!xForwardedFor) {
            method.addHeader("X-Forwarded-For", request.getRemoteAddr());
        }
        StringBuffer url = new StringBuffer("http://");
        url.append(httpRequest.getServerName());
        if (httpRequest.getServerPort() != 80) {
            url.append(":" + httpRequest.getServerPort());
        }
        if (httpRequest.getServletPath() != null) {
            url.append(httpRequest.getServletPath());
            try {
                method.setURI(new URI(url.toString().replaceAll(" ", "%20")));
            }
            catch (URISyntaxException e) {
                SoapUI.logError(e);
            }
            if (httpRequest.getQueryString() != null) {
                url.append("?" + httpRequest.getQueryString());
                try {
                    method.setURI(new URI(url.toString()));
                }
                catch (URISyntaxException e) {
                    SoapUI.logError(e);
                }
            }
        }
        method.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        this.setProtocolversion(method, request.getProtocol());
        ProxyUtils.setForceDirectConnection(method.getParams());
        this.listenerCallBack.fireBeforeProxy(this.project, request, response, method);
        if (this.settings.getBoolean("Reuse request state")) {
            if (this.httpState == null) {
                this.httpState = new BasicHttpContext();
            }
            HttpClientSupport.execute(method, this.httpState);
        } else {
            HttpClientSupport.execute(method);
        }
        capturedData.stopCapture();
        capturedData.setRequest(requestBody == null ? null : requestBody.toByteArray());
        capturedData.setRawResponseBody(method.getResponseBody());
        capturedData.setResponseHeader(method.getHttpResponse());
        capturedData.setRawRequestData(this.getRequestToBytes(request.toString(), requestBody));
        capturedData.setRawResponseData(this.getResponseToBytes(method, capturedData.getRawResponseBody()));
        byte[] decompressedResponseBody = method.getDecompressedResponseBody();
        capturedData.setResponseContent(decompressedResponseBody != null ? new String(decompressedResponseBody) : "");
        capturedData.setResponseStatusCode(method.hasHttpResponse() ? Integer.valueOf(method.getHttpResponse().getStatusLine().getStatusCode()) : null);
        capturedData.setResponseStatusLine(method.hasHttpResponse() ? method.getHttpResponse().getStatusLine().toString() : null);
        this.listenerCallBack.fireAfterProxy(this.project, request, response, method, capturedData);
        ((HttpServletResponse)response).setStatus((method.hasHttpResponse() ? Integer.valueOf(method.getHttpResponse().getStatusLine().getStatusCode()) : null).intValue());
        if (!response.isCommitted()) {
            StringToStringsMap responseHeaders = capturedData.getResponseHeaders();
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            for (Map.Entry headerEntry : responseHeaders.entrySet()) {
                for (String header : (List)headerEntry.getValue()) {
                    httpServletResponse.addHeader((String)headerEntry.getKey(), header);
                }
            }
            if (capturedData.getRawResponseBody() != null) {
                IO.copy((InputStream)new ByteArrayInputStream(capturedData.getRawResponseBody()), (OutputStream)httpServletResponse.getOutputStream());
            }
        }
        ProxyServlet proxyServlet = this;
        synchronized (proxyServlet) {
            if (this.contentTypeMatches(method)) {
                this.listenerCallBack.fireAddMessageExchange(capturedData);
            }
        }
    }

    protected boolean contentTypeMatches(ExtendedHttpMethod method) {
        if (method.hasHttpResponse()) {
            Header[] headers = method.getHttpResponse().getHeaders("Content-Type");
            if (headers.length == 0) {
                return true;
            }
            for (Header header : headers) {
                if (!this.includedContentTypes.matches(header.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private byte[] getResponseToBytes(ExtendedHttpMethod method, byte[] res) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringBuilder response = new StringBuilder();
        if (method.hasHttpResponse()) {
            Header[] headers;
            response.append(method.getHttpResponse().getStatusLine().toString());
            response.append("\r\n");
            for (Header header : headers = method.getHttpResponse().getAllHeaders()) {
                response.append(header.toString().trim()).append("\r\n");
            }
            response.append("\r\n");
            try {
                out.write(response.toString().getBytes());
                if (res != null) {
                    out.write(res);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out.toByteArray();
    }

    private byte[] getRequestToBytes(String footer, ByteArrayOutputStream requestBody) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(footer.trim().getBytes());
            out.write("\r\n\r\n".getBytes());
            if (requestBody != null) {
                out.write(requestBody.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    protected void setProtocolversion(ExtendedHttpMethod postMethod, String protocolVersion) {
        if (protocolVersion.equals(HttpVersion.HTTP_1_1.toString())) {
            postMethod.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        } else if (protocolVersion.equals(HttpVersion.HTTP_1_0.toString())) {
            postMethod.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        }
    }

    static {
        dontProxyHeaders.add("proxy-connection");
        dontProxyHeaders.add("connection");
        dontProxyHeaders.add("keep-alive");
        dontProxyHeaders.add("transfer-encoding");
        dontProxyHeaders.add("te");
        dontProxyHeaders.add("trailer");
        dontProxyHeaders.add("proxy-authorization");
        dontProxyHeaders.add("proxy-authenticate");
        dontProxyHeaders.add("upgrade");
        dontProxyHeaders.add("content-length");
    }
}

