/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.strategy;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.AbstractLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.xmlbeans.XmlObject;

public class SimpleLoadStrategy
extends AbstractLoadStrategy {
    private static final int DEFAULT_TEST_DELAY = 1000;
    private static final float DEFAULT_RANDOM_FACTOR = 0.5f;
    public static final String STRATEGY_TYPE = "Simple";
    private int testDelay = 1000;
    private float randomFactor = 0.5f;
    private JPanel configPanel;
    private JTextField testDelayField;
    private JTextField randomFactorField;

    public SimpleLoadStrategy(XmlObject config, WsdlLoadTest loadTest) {
        super(STRATEGY_TYPE, loadTest);
        if (config != null) {
            XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config);
            this.testDelay = reader.readInt("testDelay", 1000);
            this.randomFactor = reader.readFloat("randomFactor", 0.5f);
        }
    }

    @Override
    public XmlObject getConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("testDelay", this.testDelay);
        builder.add("randomFactor", this.randomFactor);
        return builder.finish();
    }

    @Override
    public void beforeTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        int delay = this.calculateDelay(this.testDelay);
        if (delay == 0) {
            return;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            SoapUI.logError(e);
        }
    }

    public int calculateDelay(int delay) {
        if (delay == 0 || this.randomFactor == 0.0f) {
            return delay;
        }
        int fixDelay = (int)((float)delay * (1.0f - this.randomFactor));
        int randDelay = (int)(this.randomFactor == 0.0f ? 0.0 : (double)(delay - fixDelay) * Math.random());
        return fixDelay + randDelay;
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configPanel == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.testDelayField = new JTextField(5);
            UISupport.setPreferredHeight(this.testDelayField, 18);
            this.testDelayField.setHorizontalAlignment(4);
            this.testDelayField.setText(String.valueOf(this.testDelay));
            this.testDelayField.setToolTipText("Sets the delay between each test run in milliseconds");
            this.testDelayField.getDocument().addDocumentListener(new ConfigDocumentListener());
            builder.addFixed((JComponent)new JLabel("Test Delay"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.testDelayField);
            builder.addRelatedGap();
            this.randomFactorField = new JTextField(4);
            UISupport.setPreferredHeight(this.randomFactorField, 18);
            this.randomFactorField.setHorizontalAlignment(4);
            this.randomFactorField.setText(String.valueOf(this.randomFactor));
            this.randomFactorField.setToolTipText("Specifies the relative amount of randomization for delay (0 = no random, 1 = all random)");
            this.randomFactorField.getDocument().addDocumentListener(new ConfigDocumentListener());
            builder.addFixed((JComponent)new JLabel("Random"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.randomFactorField);
            this.configPanel = builder.getPanel();
        }
        return this.configPanel;
    }

    public int getTestDelay() {
        return this.testDelay;
    }

    public float getRandomFactor() {
        return this.randomFactor;
    }

    private final class ConfigDocumentListener
    extends DocumentListenerAdapter {
        private ConfigDocumentListener() {
        }

        @Override
        public void update(Document document) {
            try {
                if (document == SimpleLoadStrategy.this.testDelayField.getDocument()) {
                    SimpleLoadStrategy.this.testDelay = Integer.parseInt(SimpleLoadStrategy.this.testDelayField.getText());
                }
                if (document == SimpleLoadStrategy.this.randomFactorField.getDocument()) {
                    SimpleLoadStrategy.this.randomFactor = Float.parseFloat(SimpleLoadStrategy.this.randomFactorField.getText().replace(',', '.'));
                }
                SimpleLoadStrategy.this.notifyConfigurationChanged();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static class Factory
    implements LoadStrategyFactory {
        @Override
        public String getType() {
            return SimpleLoadStrategy.STRATEGY_TYPE;
        }

        @Override
        public LoadStrategy build(XmlObject config, WsdlLoadTest loadTest) {
            return new SimpleLoadStrategy(config, loadTest);
        }

        @Override
        public LoadStrategy create(WsdlLoadTest loadTest) {
            return new SimpleLoadStrategy(null, loadTest);
        }
    }
}

