/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CloneTestCaseAction
extends AbstractSoapUIAction<WsdlTestCase> {
    private static final String CREATE_NEW_OPTION = "<Create New>";
    private XFormDialog dialog;

    public CloneTestCaseAction() {
        super("Clone TestCase", "Clones this TestCase");
    }

    @Override
    public void perform(WsdlTestCase testCase, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField("Target Project").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals(CloneTestCaseAction.CREATE_NEW_OPTION)) {
                        CloneTestCaseAction.this.dialog.setOptions("Target TestSuite", new String[]{CloneTestCaseAction.CREATE_NEW_OPTION});
                    } else {
                        Project project = SoapUI.getWorkspace().getProjectByName(newValue);
                        CloneTestCaseAction.this.dialog.setOptions("Target TestSuite", ModelSupport.getNames(project.getTestSuiteList(), new String[]{CloneTestCaseAction.CREATE_NEW_OPTION}));
                    }
                }
            });
            this.dialog.getFormField("Clone description").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (CloneTestCaseAction.this.dialog.getBooleanValue("Clone description")) {
                        CloneTestCaseAction.this.dialog.getFormField("Description").setEnabled(false);
                    } else {
                        CloneTestCaseAction.this.dialog.getFormField("Description").setEnabled(true);
                    }
                }
            });
        }
        this.dialog.setBooleanValue("Move instead", false);
        this.dialog.setBooleanValue("Clone description", true);
        this.dialog.getFormField("Description").setEnabled(false);
        this.dialog.setValue("Description", testCase.getDescription());
        this.dialog.setValue("TestCase Name", "Copy of " + testCase.getName());
        WorkspaceImpl workspace = testCase.getTestSuite().getProject().getWorkspace();
        this.dialog.setOptions("Target Project", ModelSupport.getNames(workspace.getOpenProjectList(), new String[]{CREATE_NEW_OPTION}));
        this.dialog.setValue("Target Project", testCase.getTestSuite().getProject().getName());
        this.dialog.setOptions("Target TestSuite", ModelSupport.getNames(testCase.getTestSuite().getProject().getTestSuiteList(), new String[]{CREATE_NEW_OPTION}));
        this.dialog.setValue("Target TestSuite", testCase.getTestSuite().getName());
        boolean hasLoadTests = testCase.getLoadTestCount() > 0;
        this.dialog.setBooleanValue("Clone LoadTests", hasLoadTests);
        this.dialog.getFormField("Clone LoadTests").setEnabled(hasLoadTests);
        boolean hasSecurityTests = testCase.getSecurityTestCount() > 0;
        this.dialog.setBooleanValue("Clone SecurityTests", hasSecurityTests);
        this.dialog.getFormField("Clone SecurityTests").setEnabled(hasSecurityTests);
        if (this.dialog.show()) {
            boolean bl;
            String targetProjectName = this.dialog.getValue("Target Project");
            String targetTestSuiteName = this.dialog.getValue("Target TestSuite");
            String name = this.dialog.getValue("TestCase Name");
            WsdlProject project = testCase.getTestSuite().getProject();
            WsdlTestSuite targetTestSuite = null;
            HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
            if (!targetProjectName.equals(project.getName())) {
                for (int y = 0; y < testCase.getTestStepCount(); ++y) {
                    Iterator<Object> testStep = testCase.getTestStepAt(y);
                    requiredInterfaces.addAll(((WsdlTestStep)((Object)testStep)).getRequiredInterfaces());
                }
                project = (WsdlProject)workspace.getProjectByName(targetProjectName);
                if (project == null) {
                    targetProjectName = UISupport.prompt("Enter name for new Project", "Clone TestCase", "");
                    if (targetProjectName == null) {
                        return;
                    }
                    try {
                        project = workspace.createProject(targetProjectName, null);
                    }
                    catch (SoapUIException e) {
                        UISupport.showErrorMessage(e);
                    }
                    if (project == null) {
                        return;
                    }
                }
                if (requiredInterfaces.size() > 0 && project.getInterfaceCount() > 0) {
                    HashMap<String, Interface> bindings = new HashMap<String, Interface>();
                    for (Interface interface_ : requiredInterfaces) {
                        bindings.put(interface_.getTechnicalId(), interface_);
                    }
                    for (Interface interface_ : project.getInterfaceList()) {
                        bindings.remove(interface_.getTechnicalId());
                    }
                    requiredInterfaces.retainAll(bindings.values());
                }
                if (requiredInterfaces.size() > 0) {
                    String msg = "Target project [" + targetProjectName + "] is missing required Interfaces;\r\n\r\n";
                    for (Interface interface_ : requiredInterfaces) {
                        msg = msg + interface_.getName() + " [" + interface_.getTechnicalId() + "]\r\n";
                    }
                    Boolean result = UISupport.confirmOrCancel(msg = msg + "\r\nShould these will be cloned to the targetProject as well?", "Clone TestCase");
                    if (result == null) {
                        return;
                    }
                    if (result.booleanValue()) {
                        for (Interface iface : requiredInterfaces) {
                            project.importInterface((AbstractInterface)iface, true, true);
                        }
                    }
                }
            }
            if ((targetTestSuite = project.getTestSuiteByName(targetTestSuiteName)) == null) {
                targetTestSuiteName = UISupport.prompt("Specify name for new TestSuite", "Clone TestCase", "Copy of " + testCase.getTestSuite().getName());
                if (targetTestSuiteName == null) {
                    return;
                }
                targetTestSuite = project.addNewTestSuite(targetTestSuiteName);
            }
            boolean move = this.dialog.getBooleanValue("Move instead");
            WsdlTestCase newTestCase = targetTestSuite.importTestCase(testCase, name, -1, this.dialog.getBooleanValue("Clone LoadTests"), this.dialog.getBooleanValue("Clone SecurityTests"), !move);
            UISupport.select(newTestCase);
            if (move) {
                testCase.getTestSuite().removeTestCase(testCase);
            }
            if (!(bl = this.dialog.getBooleanValue("Clone description"))) {
                newTestCase.setDescription(this.dialog.getValue("Description"));
            }
        }
    }

    @AForm(description="Specify target Project/TestSuite and name of cloned TestCase", name="Clone TestCase", helpUrl="/functional-testing/reference/testsuite-reference.html", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="TestCase Name", description="The name of the cloned TestCase", type=AField.AFieldType.STRING)
        public static final String NAME = "TestCase Name";
        @AField(name="Target Project", description="The target Project for the cloned TestCase", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Target TestSuite", description="The target TestSuite for the cloned TestCase", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "Target TestSuite";
        @AField(name="Clone LoadTests", description="Clone contained LoadTests", type=AField.AFieldType.BOOLEAN)
        public static final String CLONE_LOADTESTS = "Clone LoadTests";
        @AField(name="Clone SecurityTests", description="Clone contained SecurityTests", type=AField.AFieldType.BOOLEAN)
        public static final String CLONE_SECURITYTESTS = "Clone SecurityTests";
        @AField(name="Move instead", description="Moves the selected TestCase instead of copying", type=AField.AFieldType.BOOLEAN)
        public static final String MOVE = "Move instead";
        @AField(name="Clone description", description="Clones the description of selected TestCase", type=AField.AFieldType.BOOLEAN)
        public static final String CLONE_DESCRIPTION = "Clone description";
        @AField(name="Description", description="Description of new TestCase", type=AField.AFieldType.STRINGAREA)
        public static final String DESCRIPTION = "Description";
    }
}

