/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.dnd.handlers.DragAndDropSupport;
import java.util.HashSet;

public abstract class AbstractAddRequestToTestCaseAction<T extends AbstractHttpRequest>
extends AbstractAddToTestCaseAction<T> {
    public AbstractAddRequestToTestCaseAction(String name, String description) {
        super(name, description);
    }

    public static AbstractAddRequestToTestCaseAction findActionForRequest(AbstractHttpRequest source) {
        String actionId = source instanceof RestRequest ? "AddRestRequestToTestCaseAction" : "AddRequestToTestCaseAction";
        return (AbstractAddRequestToTestCaseAction)SoapUI.getActionRegistry().getAction(actionId);
    }

    public static boolean addRequestToTestCase(AbstractHttpRequest source, TestCase testCase, int index) {
        if (!UISupport.confirm("Add Request [" + source.getName() + "] to TestCase [" + testCase.getName() + "]", "Add Request to TestCase")) {
            return false;
        }
        Project targetProject = testCase.getTestSuite().getProject();
        if (targetProject != ((AbstractInterface)source.getOperation().getInterface()).getProject()) {
            HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
            requiredInterfaces.add(source.getOperation().getInterface());
            if (!DragAndDropSupport.importRequiredInterfaces(targetProject, requiredInterfaces, "Add Request to TestCase")) {
                return false;
            }
        }
        return AbstractAddRequestToTestCaseAction.findActionForRequest(source).addRequest(testCase, source, index);
    }

    public abstract boolean addRequest(TestCase var1, T var2, int var3);
}

