/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.support.HelpActionMarker;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JButtonBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public abstract class SimpleDialog
extends JDialog {
    protected JButtonBar buttons = null;
    private final String title;
    private final String description;
    private final String helpUrl;
    private final boolean okAndCancel;
    private boolean initialized = false;

    public SimpleDialog(String title, String description, String helpUrl, boolean okAndCancel) {
        super(UISupport.getMainFrame(), title, true);
        this.title = title;
        this.description = description;
        this.helpUrl = helpUrl;
        this.okAndCancel = okAndCancel;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.buttons = UISupport.initDialogActions(this.buildActions(this.helpUrl, this.okAndCancel), this);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.getContentPane().add((Component)UISupport.buildDescription(this.title, this.description, UISupport.createImageIcon("/applications-system.png")), "North");
        this.getContentPane().add(this.buildContent(), "Center");
        this.buttons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.WHITE)), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        this.getContentPane().add((Component)this.buttons, "South");
        this.modifyButtons();
        this.pack();
        this.initialized = true;
    }

    protected void modifyButtons() {
    }

    public SimpleDialog(String title, String description, String helpUrl) {
        this(title, description, helpUrl, true);
    }

    protected abstract Component buildContent();

    public ActionList buildActions(String url, boolean okAndCancel) {
        DefaultActionList actions = new DefaultActionList("Actions");
        if (url != null) {
            actions.addAction(new ShowOnlineHelpAction(url));
        }
        OKAction okAction = new OKAction();
        actions.addAction(okAction);
        if (okAndCancel) {
            actions.addAction(new CancelAction());
            actions.setDefaultAction(okAction);
        }
        return actions;
    }

    protected abstract boolean handleOk();

    @Override
    public void setVisible(boolean b) {
        this.init();
        if (b) {
            this.beforeShow();
        } else {
            this.beforeHide();
        }
        UISupport.centerDialog(this);
        super.setVisible(b);
        if (b) {
            this.afterShow();
        } else {
            this.afterHide();
        }
    }

    protected void afterHide() {
    }

    protected void afterShow() {
    }

    protected void beforeHide() {
    }

    protected void beforeShow() {
    }

    protected boolean handleCancel() {
        return true;
    }

    protected final class OKAction
    extends AbstractAction {
        public OKAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SimpleDialog.this.handleOk()) {
                SimpleDialog.this.setVisible(false);
            }
        }
    }

    protected final class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SimpleDialog.this.handleCancel()) {
                SimpleDialog.this.setVisible(false);
            }
        }
    }

    public final class HelpAction
    extends AbstractAction
    implements HelpActionMarker {
        private final String url;

        public HelpAction(String url) {
            this("Online Help", url, UISupport.getKeyStroke("F1"));
        }

        public HelpAction(String title, String url) {
            this(title, url, null);
        }

        public HelpAction(String title, String url, KeyStroke accelerator) {
            super(title);
            this.url = url;
            this.putValue("ShortDescription", "Show online help");
            if (accelerator != null) {
                this.putValue("AcceleratorKey", accelerator);
            }
            this.putValue("SmallIcon", UISupport.HELP_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tools.openURL(this.url);
        }
    }
}

