/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.IOException;

public class RemoveProjectAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "RemoveProjectAction";

    public RemoveProjectAction() {
        super("Remove", "Removes this project from the workspace");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        if (this.hasRunningTests(project)) {
            UISupport.showErrorMessage("Cannot remove Interface due to running tests");
            return;
        }
        Boolean saveProject = Boolean.FALSE;
        if (project.isOpen() ? (saveProject = UISupport.confirmOrCancel("Save project [" + project.getName() + "] before removing?", "Remove Project")) == null : !UISupport.confirm("Remove project [" + project.getName() + "] from workspace", "Remove Project")) {
            return;
        }
        if (saveProject.booleanValue()) {
            try {
                SaveStatus status = project.save();
                if (status == SaveStatus.CANCELLED || status == SaveStatus.FAILED) {
                    return;
                }
            }
            catch (IOException e1) {
                UISupport.showErrorMessage(e1);
            }
        }
        project.getWorkspace().removeProject(project);
    }

    private boolean hasRunningTests(WsdlProject project) {
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            WsdlTestSuite wsdlTestSuite = project.getTestSuiteAt(c);
            for (int i = 0; i < wsdlTestSuite.getTestCaseCount(); ++i) {
                if (!SoapUI.getTestMonitor().hasRunningTest(wsdlTestSuite.getTestCaseAt(i))) continue;
                return true;
            }
        }
        for (MockService mockService : project.getMockServiceList()) {
            if (!SoapUI.getTestMonitor().hasRunningMock(mockService)) continue;
            return true;
        }
        return false;
    }
}

