/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateWsdlTestSuiteAction;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;
import javax.annotation.Nullable;

public class AddWsdlAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "NewWsdlProjectAction";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(AddWsdlAction.class);

    public AddWsdlAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setValue(Form.CREATEREQUEST, Boolean.toString(true));
            this.dialog.getFormField(Form.INITIALWSDL).addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    String value = newValue.toLowerCase().trim();
                    AddWsdlAction.this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(value.length() > 0);
                    AddWsdlAction.this.dialog.getFormField(Form.GENERATEMOCKSERVICE).setEnabled(newValue.trim().length() > 0);
                    AddWsdlAction.this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(newValue.trim().length() > 0);
                }
            });
        } else {
            this.dialog.setValue(Form.INITIALWSDL, "");
            this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(false);
            this.dialog.getFormField(Form.GENERATEMOCKSERVICE).setEnabled(false);
            this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(false);
        }
        while (this.dialog.show()) {
            try {
                WsdlInterface[] results;
                String url = this.dialog.getValue(Form.INITIALWSDL).trim();
                if (!StringUtils.hasContent(url)) continue;
                String expUrl = PathUtils.expandPath(url, project);
                if (new File(expUrl).exists()) {
                    url = new File(expUrl).toURI().toURL().toString();
                }
                if ((results = this.importWsdl(project, expUrl)) == null) continue;
                if (url.equals(expUrl)) break;
                for (WsdlInterface iface : results) {
                    iface.setDefinition(url, false);
                }
                break;
            }
            catch (InvalidDefinitionException ex) {
                ex.show();
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    @Nullable
    private WsdlInterface[] importWsdl(WsdlProject project, String url) throws SoapUIException {
        WsdlInterface[] results = WsdlInterfaceFactory.importWsdl(project, url, this.dialog.getValue(Form.CREATEREQUEST).equals("true"));
        if (results != null) {
            for (WsdlInterface iface : results) {
                UISupport.select(iface);
                if (this.dialog.getValue(Form.GENERATETESTSUITE).equals("true")) {
                    GenerateWsdlTestSuiteAction generateTestSuiteAction = new GenerateWsdlTestSuiteAction();
                    generateTestSuiteAction.generateTestSuite(iface, true);
                }
                if (!this.dialog.getValue(Form.GENERATEMOCKSERVICE).equals("true")) continue;
                GenerateMockServiceAction generateMockAction = new GenerateMockServiceAction();
                generateMockAction.generateMockService(iface, false);
            }
        }
        return results;
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="/Working-with-Projects/new-project.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.InitialWsdl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = messages.get("Form.InitialWsdl.Label");
        @AField(description="Form.CreateRequests.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String CREATEREQUEST = messages.get("Form.CreateRequests.Label");
        @AField(description="Form.GenerateTestSuite.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATETESTSUITE = messages.get("Form.GenerateTestSuite.Label");
        @AField(description="Form.GenerateMockService.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATEMOCKSERVICE = messages.get("Form.GenerateMockService.Label");
    }
}

