/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.actions.service.GenerateRestTestSuiteAction;
import com.eviware.soapui.impl.rest.support.WadlImporter;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;

public class AddWadlAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "NewWsdlProjectAction";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(AddWadlAction.class);

    public AddWadlAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        this.createOrUpdateDialog();
        while (this.dialog.show()) {
            try {
                String url = this.dialog.getValue(Form.INITIALWSDL).trim();
                if (!StringUtils.hasContent(url)) continue;
                String expandedUrl = PathUtils.expandPath(url, project);
                if (new File(expandedUrl).exists()) {
                    expandedUrl = new File(expandedUrl).toURI().toURL().toString();
                }
                RestService result = this.importWadl(project, expandedUrl);
                if (url.equals(expandedUrl) || result == null) break;
                result.setWadlUrl(url);
                if (!this.dialog.getBooleanValue(Form.GENERATETESTSUITE)) break;
                new GenerateRestTestSuiteAction().perform(result, (Object)true);
                break;
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    private void createOrUpdateDialog() {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField(Form.INITIALWSDL).addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    AddWadlAction.this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(newValue.trim().length() > 0);
                }
            });
        } else {
            this.dialog.setValue(Form.INITIALWSDL, "");
            this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(false);
        }
    }

    private RestService importWadl(WsdlProject project, String url) {
        RestService restService = (RestService)project.addNewInterface(project.getName(), "rest");
        UISupport.select(restService);
        try {
            new WadlImporter(restService).initFromWadl(url);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
        Analytics.trackAction(SoapUIActions.IMPORT_WADL);
        return restService;
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="/Working-with-Projects/new-project.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.InitialWadl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = messages.get("Form.InitialWadl.Label");
        @AField(description="Form.GenerateTestSuite.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATETESTSUITE = messages.get("Form.GenerateTestSuite.Label");
    }
}

