/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.impl.swing.JTextAreaFormField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestRunnerAction
extends AbstractToolsAction<WsdlProject> {
    protected static final String ALL_VALUE = "<all>";
    protected static final String ENVIRONMENT = "Environment";
    protected static final String ENDPOINT = "Endpoint";
    protected static final String HOSTPORT = "Host:Port";
    protected static final String TESTSUITE = "TestSuite";
    protected static final String TESTCASE = "TestCase";
    protected static final String USERNAME = "Username";
    protected static final String PASSWORD = "Password";
    protected static final String WSSTYPE = "WSS Password Type";
    protected static final String DOMAIN = "Domain";
    protected static final String PRINTREPORT = "Print Report";
    protected static final String ROOTFOLDER = "Root Folder";
    protected static final String EXPORTJUNITRESULTS = "Export JUnit Results";
    protected static final String EXPORTJUNITRESULTSWITHPROPERTIES = "Export JUnit Results with test properties";
    protected static final String EXPORTALL = "Export All";
    protected static final String ENABLEUI = "Enable UI";
    protected static final String TESTRUNNERPATH = "TestRunner Path";
    protected static final String SAVEPROJECT = "Save Project";
    protected static final String ADDSETTINGS = "Add Settings";
    protected static final String OPEN_REPORT = "Open Report";
    protected static final String COVERAGE = "Coverage Report";
    protected static final String PROJECTPASSWORD = "Project Password";
    protected static final String IGNOREERRORS = "Ignore Errors";
    protected static final String GENERATEREPORTSEACHTESTCASE = "Select Report Type";
    protected static final String REPORTFORMAT = "Report Format(s)";
    protected static final String SAVEAFTER = "Save After";
    protected static final String GLOBALPROPERTIES = "Global Properties";
    protected static final String SYSTEMPROPERTIES = "System Properties";
    protected static final String PROJECTPROPERTIES = "Project Properties";
    protected XForm mainForm;
    private static final Logger log = LogManager.getLogger(TestRunnerAction.class);
    public static final String SOAPUI_ACTION_ID = "TestRunnerAction";
    protected XForm advForm;
    protected XForm propertyForm;
    protected XForm reportForm;
    protected List<TestSuite> testSuites;
    protected boolean proVersion;

    public TestRunnerAction() {
        super("Launch TestRunner", "Launch command-line TestRunner for this project");
    }

    public TestRunnerAction(String name, String description) {
        super(name, description);
    }

    @Override
    protected XFormDialog buildDialog(WsdlProject modelItem) {
        if (modelItem == null) {
            return null;
        }
        this.proVersion = this.isProVersion(modelItem);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch TestRunner");
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addComboBox(TESTSUITE, new String[0], "The TestSuite to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                ArrayList<String> testCases = new ArrayList<String>();
                String tc = TestRunnerAction.this.mainForm.getComponentValue(TestRunnerAction.TESTCASE);
                if (newValue.equals(TestRunnerAction.ALL_VALUE)) {
                    for (TestSuite testSuite : TestRunnerAction.this.testSuites) {
                        for (TestCase testCase : testSuite.getTestCaseList()) {
                            if (testCases.contains(testCase.getName())) continue;
                            testCases.add(testCase.getName());
                        }
                    }
                } else {
                    WsdlTestSuite testSuite = ((WsdlProject)TestRunnerAction.this.getModelItem()).getTestSuiteByName(newValue);
                    if (testSuite != null) {
                        testCases.addAll(Arrays.asList(ModelSupport.getNames(testSuite.getTestCaseList())));
                    }
                }
                testCases.add(0, TestRunnerAction.ALL_VALUE);
                TestRunnerAction.this.mainForm.setOptions(TestRunnerAction.TESTCASE, testCases.toArray());
                if (testCases.contains(tc)) {
                    TestRunnerAction.this.mainForm.getFormField(TestRunnerAction.TESTCASE).setValue(tc);
                }
            }
        });
        this.mainForm.addComboBox(TESTCASE, new String[0], "The TestCase to run");
        this.mainForm.addSeparator();
        this.mainForm.addCheckBox(ENABLEUI, "Enables UI components in scripts");
        this.mainForm.addTextField(TESTRUNNERPATH, "Folder containing TestRunner.bat to use", XForm.FieldType.FOLDER);
        this.mainForm.addCheckBox(SAVEPROJECT, "Saves project before running").setEnabled(!modelItem.isRemote());
        this.mainForm.addCheckBox(ADDSETTINGS, "Adds global settings to command-line");
        this.mainForm.addSeparator();
        this.mainForm.addTextField(PROJECTPASSWORD, "Set project password", XForm.FieldType.PASSWORD);
        this.mainForm.addTextField("user-settings.xml Password", "Set soapui-settings.xml password", XForm.FieldType.PASSWORD);
        this.mainForm.addCheckBox(IGNOREERRORS, "Do not stop if error occurs, ignore them");
        this.mainForm.addCheckBox(SAVEAFTER, "Sets to save the project file after tests have been run");
        this.advForm = builder.createForm("Overrides");
        this.advForm.addComboBox(ENVIRONMENT, new String[]{"Default"}, "The environment to set for all requests").setEnabled(this.proVersion);
        this.advForm.addComboBox(ENDPOINT, new String[]{""}, "endpoint to forward to");
        this.advForm.addTextField(HOSTPORT, "Host:Port to use for requests", XForm.FieldType.TEXT);
        this.advForm.addSeparator();
        this.advForm.addTextField(USERNAME, "The username to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addTextField(PASSWORD, "The password to set for all requests", XForm.FieldType.PASSWORD);
        this.advForm.addTextField(DOMAIN, "The domain to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addComboBox(WSSTYPE, new String[]{"", "Text", "Digest"}, "The username to set for all requests");
        this.reportForm = builder.createForm("Reports");
        this.reportForm.addCheckBox(PRINTREPORT, "Prints a summary report to the console");
        this.reportForm.addCheckBox(EXPORTJUNITRESULTS, "Exports results to a JUnit-Style report");
        this.reportForm.addCheckBox(EXPORTJUNITRESULTSWITHPROPERTIES, "Exports results to a JUnit-Style report with test properties");
        this.reportForm.addCheckBox(EXPORTALL, "Exports all results (not only errors)");
        this.reportForm.addTextField(ROOTFOLDER, "Folder to export to", XForm.FieldType.FOLDER);
        this.reportForm.addSeparator();
        this.reportForm.addCheckBox(COVERAGE, "Generate WSDL Coverage report (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addCheckBox(OPEN_REPORT, "Opens generated report(s) in browser (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addComboBox(GENERATEREPORTSEACHTESTCASE, new String[0], "Template used to generate report (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addTextField(REPORTFORMAT, "Choose report format(s), comma-separated (SoapUI Pro only)", XForm.FieldType.TEXT).setEnabled(this.proVersion);
        this.propertyForm = builder.createForm("Properties");
        this.propertyForm.addComponent(GLOBALPROPERTIES, this.createTextArea());
        this.propertyForm.addComponent(SYSTEMPROPERTIES, this.createTextArea());
        this.propertyForm.addComponent(PROJECTPROPERTIES, this.createTextArea());
        this.setToolsSettingsAction(null);
        this.buildArgsForm(builder, false, "TestRunner");
        return builder.buildDialog(this.buildDefaultActions("/Test-Automation/launch-testrunner.html", modelItem), "Specify arguments for launching SoapUI TestRunner", UISupport.TOOL_ICON);
    }

    protected JTextAreaFormField createTextArea() {
        JTextAreaFormField textArea = new JTextAreaFormField();
        textArea.setWidth(40);
        textArea.getTextArea().setRows(4);
        textArea.setToolTip("name=value pairs separated by space or enter");
        return textArea;
    }

    protected boolean isProVersion(WsdlProject modelItem) {
        return modelItem.getClass().getName().contains("WsdlProjectPro");
    }

    @Override
    protected Action createRunOption(WsdlProject modelItem) {
        Action action = super.createRunOption(modelItem);
        action.putValue("Name", "Launch");
        return action;
    }

    @Override
    protected StringToStringMap initValues(WsdlProject modelItem, Object param) {
        if (modelItem != null && this.mainForm != null) {
            ArrayList<String> endpoints = new ArrayList<String>();
            for (Interface iface : modelItem.getInterfaceList()) {
                for (String endpoint : iface.getEndpoints()) {
                    if (endpoints.contains(endpoint)) continue;
                    endpoints.add(endpoint);
                }
            }
            endpoints.add(0, null);
            this.advForm.setOptions(ENDPOINT, endpoints.toArray());
            this.testSuites = modelItem.getTestSuiteList();
            for (int c = 0; c < this.testSuites.size(); ++c) {
                if (this.testSuites.get(c).getTestCaseCount() != 0) continue;
                this.testSuites.remove(c);
                --c;
            }
            this.mainForm.setOptions(TESTSUITE, ModelSupport.getNames(new String[]{ALL_VALUE}, this.testSuites));
            ArrayList<String> testCases = new ArrayList<String>();
            for (TestSuite testSuite : this.testSuites) {
                for (TestCase testCase : testSuite.getTestCaseList()) {
                    if (testCases.contains(testCase.getName())) continue;
                    testCases.add(testCase.getName());
                }
            }
            testCases.add(0, ALL_VALUE);
            this.mainForm.setOptions(TESTCASE, testCases.toArray());
        } else if (this.mainForm != null) {
            this.mainForm.setOptions(ENDPOINT, new String[]{null});
        }
        this.initEnvironment(modelItem);
        StringToStringMap values = super.initValues(modelItem, param);
        if (this.mainForm != null) {
            if (param instanceof WsdlTestCase) {
                this.mainForm.getFormField(TESTSUITE).setValue(((WsdlTestCase)param).getTestSuite().getName());
                this.mainForm.getFormField(TESTCASE).setValue(((WsdlTestCase)param).getName());
                values.put(TESTSUITE, ((WsdlTestCase)param).getTestSuite().getName());
                values.put(TESTCASE, ((WsdlTestCase)param).getName());
            } else if (param instanceof WsdlTestSuite) {
                this.mainForm.getFormField(TESTSUITE).setValue(((WsdlTestSuite)param).getName());
                values.put(TESTSUITE, ((WsdlTestSuite)param).getName());
            }
            this.mainForm.getComponent(SAVEPROJECT).setEnabled(!modelItem.isRemote());
        }
        return values;
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, WsdlProject modelItem) throws Exception {
        String testRunnerDir = this.mainForm.getComponentValue(TESTRUNNERPATH);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        if (StringUtils.isNullOrEmpty(testRunnerDir)) {
            builder.directory(new File("."));
        } else {
            builder.directory(new File(testRunnerDir));
        }
        if (this.mainForm.getComponentValue(SAVEPROJECT).equals(Boolean.TRUE.toString())) {
            modelItem.save();
        } else if (StringUtils.isNullOrEmpty(modelItem.getPath())) {
            UISupport.showErrorMessage("Project [" + modelItem.getName() + "] has not been saved to file.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Launching testrunner in directory [" + builder.directory() + "] with arguments [" + args.toString() + "]");
        }
        toolHost.run(new ProcessToolRunner(builder, "SoapUI TestRunner", (ModelItem)modelItem, args));
    }

    protected ArgumentBuilder buildArgs(WsdlProject modelItem) throws IOException {
        XFormDialog dialog = this.getDialog();
        if (dialog == null) {
            ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
            builder.startScript("testrunner", ".bat", ".sh");
            return builder;
        }
        StringToStringMap values = dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("testrunner", ".bat", ".sh");
        builder.addString(ENDPOINT, "-e", "");
        builder.addString(HOSTPORT, "-h", "");
        if (!((String)values.get(TESTSUITE)).equals(ALL_VALUE)) {
            builder.addString(TESTSUITE, "-s", "");
        }
        if (!((String)values.get(TESTCASE)).equals(ALL_VALUE)) {
            builder.addString(TESTCASE, "-c", "");
        }
        builder.addString(USERNAME, "-u", "");
        builder.addStringShadow(PASSWORD, "-p", "");
        builder.addString(DOMAIN, "-d", "");
        builder.addString(WSSTYPE, "-w", "");
        builder.addBoolean(PRINTREPORT, "-r");
        builder.addBoolean(EXPORTALL, "-a");
        builder.addBoolean(EXPORTJUNITRESULTS, "-j");
        builder.addBoolean(EXPORTJUNITRESULTSWITHPROPERTIES, "-J");
        builder.addString(ROOTFOLDER, "-f", "");
        if (this.proVersion) {
            builder.addBoolean(OPEN_REPORT, "-o");
            builder.addBoolean(COVERAGE, "-g");
            builder.addString(GENERATEREPORTSEACHTESTCASE, "-R", "");
            builder.addString(REPORTFORMAT, "-F", "");
            builder.addString(ENVIRONMENT, "-E", "");
        }
        builder.addStringShadow(PROJECTPASSWORD, "-x", "");
        builder.addStringShadow("user-settings.xml Password", "-v", "");
        builder.addBoolean(IGNOREERRORS, "-I");
        builder.addBoolean(SAVEAFTER, "-S");
        this.addPropertyArguments(builder);
        if (dialog.getBooleanValue(ADDSETTINGS)) {
            try {
                builder.addBoolean(ADDSETTINGS, "-t" + SoapUI.saveSettings());
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        builder.addBoolean(ENABLEUI, "-i");
        builder.addArgs(modelItem.getPath());
        this.addToolArgs(values, builder);
        return builder;
    }

    protected void addPropertyArguments(ArgumentBuilder builder) {
        ArrayList<String> propertyArguments = new ArrayList<String>();
        this.addProperties(propertyArguments, GLOBALPROPERTIES, "-G");
        this.addProperties(propertyArguments, SYSTEMPROPERTIES, "-D");
        this.addProperties(propertyArguments, PROJECTPROPERTIES, "-P");
        builder.addArgs(propertyArguments.toArray(new String[propertyArguments.size()]));
    }

    protected void addProperties(List<String> propertyArguments, String propertiyDomain, String arg) {
        StringTokenizer tokenizer = new StringTokenizer(this.getDialog().getValue(propertiyDomain));
        while (tokenizer.hasMoreTokens()) {
            propertyArguments.add(arg + tokenizer.nextToken());
        }
    }

    protected void initEnvironment(WsdlProject modelItem) {
    }
}

