/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.settings;

import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.HashSet;
import java.util.Set;

public class SettingsImpl
implements Settings {
    private final Settings parent;
    private final StringToStringMap values = new StringToStringMap();
    private final Set<SettingsListener> listeners = new HashSet<SettingsListener>();

    public SettingsImpl() {
        this(null);
    }

    public SettingsImpl(Settings parent) {
        this.parent = parent;
    }

    @Override
    public boolean isSet(String id) {
        return this.values.containsKey(id);
    }

    @Override
    public String getString(String id, String defaultValue) {
        if (this.values.containsKey(id)) {
            return (String)this.values.get(id);
        }
        return this.parent == null ? defaultValue : this.parent.getString(id, defaultValue);
    }

    @Override
    public void setString(String id, String value) {
        String oldValue = this.getString(id, null);
        this.values.put(id, value);
        for (SettingsListener listener : this.listeners) {
            listener.settingChanged(id, value, oldValue);
        }
    }

    @Override
    public void reloadSettings() {
        for (SettingsListener listener : this.listeners) {
            listener.settingsReloaded();
        }
    }

    @Override
    public boolean getBoolean(String id) {
        return this.getBoolean(id, false);
    }

    @Override
    public boolean getBoolean(String id, boolean defaultValue) {
        if (this.values.containsKey(id)) {
            return Boolean.parseBoolean((String)this.values.get(id));
        }
        return this.parent == null ? defaultValue : this.parent.getBoolean(id);
    }

    @Override
    public void setBoolean(String id, boolean value) {
        String oldValue = this.getString(id, null);
        this.values.put(id, Boolean.toString(value));
        for (SettingsListener listener : this.listeners) {
            listener.settingChanged(id, Boolean.toString(value), oldValue);
        }
    }

    @Override
    public long getLong(String id, long defaultValue) {
        if (this.values.containsKey(id)) {
            try {
                return Long.parseLong((String)this.values.get(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void addSettingsListener(SettingsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSettingsListener(SettingsListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clearSetting(String id) {
        this.values.remove(id);
    }

    @Override
    public void setLong(String id, long value) {
        this.values.put(id, Long.toString(value));
    }
}

