/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.config.RestServiceConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.support.UrlSchemaLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.java.dev.wadl.x2009.x02.ApplicationDocument;
import net.java.dev.wadl.x2009.x02.DocDocument;
import net.java.dev.wadl.x2009.x02.MethodDocument;
import net.java.dev.wadl.x2009.x02.ParamDocument;
import net.java.dev.wadl.x2009.x02.ParamStyle;
import net.java.dev.wadl.x2009.x02.RepresentationDocument;
import net.java.dev.wadl.x2009.x02.ResourceDocument;
import net.java.dev.wadl.x2009.x02.ResourceTypeDocument;
import net.java.dev.wadl.x2009.x02.ResourcesDocument;
import net.java.dev.wadl.x2009.x02.ResponseDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WadlImporter {
    private RestService service;
    private ApplicationDocument.Application application;
    private List<ResourcesDocument.Resources> resourcesList;
    private Map<String, ApplicationDocument> refCache = new HashMap<String, ApplicationDocument>();
    private boolean isWADL11 = true;

    public WadlImporter(RestService service) {
        this.service = service;
    }

    public void initFromWadl(String wadlUrl) {
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(new URL(wadlUrl));
            String content = Tools.removePropertyExpansions(wadlUrl, xmlObject.xmlText());
            Element element = ((Document)xmlObject.getDomNode()).getDocumentElement();
            if (element.getLocalName().equals("application") && element.getNamespaceURI().startsWith("http://research.sun.com/wadl")) {
                this.isWADL11 = false;
                content = content.replaceAll("\"" + element.getNamespaceURI() + "\"", "\"http://wadl.dev.java.net/2009/02\"");
            } else if (!element.getLocalName().equals("application") || !element.getNamespaceURI().equals("http://wadl.dev.java.net/2009/02")) {
                throw new Exception("Document is not a WADL application with http://wadl.dev.java.net/2009/02 namespace");
            }
            ApplicationDocument applicationDocument = ApplicationDocument.Factory.parse(content);
            this.application = applicationDocument.getApplication();
            this.resourcesList = this.application.getResourcesList();
            this.service.setName(this.getFirstTitle(this.application.getDocList(), this.service.getName()));
            String base = this.resourcesList.size() == 1 ? this.resourcesList.get(0).getBase() : "";
            try {
                URL baseUrl = new URL(base);
                this.service.setBasePath(baseUrl.getPath());
                this.service.addEndpoint(Tools.getEndpointFromUrl(baseUrl));
            }
            catch (Exception e) {
                this.service.setBasePath(base);
            }
            this.service.setWadlUrl(wadlUrl);
            ((RestServiceConfig)this.service.getConfig()).setWadlVersion(this.isWADL11 ? "http://wadl.dev.java.net/2009/02" : "http://research.sun.com/wadl/2006/10");
            for (ResourcesDocument.Resources resources : this.resourcesList) {
                RestResource baseResource = null;
                if (this.resourcesList.size() > 1) {
                    String path = resources.getBase();
                    baseResource = this.service.addNewResource(path, path);
                }
                for (ResourceDocument.Resource resource : resources.getResourceList()) {
                    String name = this.getFirstTitle(resource.getDocList(), resource.getPath());
                    String path = resource.getPath();
                    RestResource newResource = null;
                    if (baseResource != null && path != null) {
                        for (RestResource res : baseResource.getChildResourceList()) {
                            if (!path.equals(res.getPath())) continue;
                            newResource = res;
                            break;
                        }
                        if (newResource == null) {
                            newResource = baseResource.addNewChildResource(name, path);
                        }
                    } else if (path != null) {
                        for (RestResource res : this.service.getResourceList()) {
                            if (!path.equals(res.getPath())) continue;
                            newResource = res;
                            break;
                        }
                        if (newResource == null) {
                            newResource = this.service.addNewResource(name, path);
                        }
                    } else {
                        newResource = this.service.addNewResource(name, "");
                    }
                    this.initResourceFromWadlResource(newResource, resource);
                    this.addSubResources(newResource, resource);
                }
            }
        }
        catch (InvalidDefinitionException ex) {
            ex.show();
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private void addSubResources(RestResource newResource, ResourceDocument.Resource resource) {
        for (ResourceDocument.Resource res : resource.getResourceList()) {
            String path = res.getPath();
            if (path == null) {
                path = "";
            }
            String name = this.getFirstTitle(res.getDocList(), path);
            RestResource newRes = null;
            for (RestResource child : newResource.getChildResourceList()) {
                if (!path.equals(child.getPath())) continue;
                newRes = child;
                break;
            }
            if (newRes == null) {
                newRes = newResource.addNewChildResource(name, path);
            }
            this.initResourceFromWadlResource(newRes, res);
            this.addSubResources(newRes, res);
        }
    }

    private String getFirstTitle(List<DocDocument.Doc> list, String defaultTitle) {
        for (DocDocument.Doc doc : list) {
            if (!StringUtils.hasContent(doc.getTitle())) continue;
            return doc.getTitle();
        }
        return defaultTitle;
    }

    private void initResourceFromWadlResource(RestResource newResource, ResourceDocument.Resource resource) {
        for (ParamDocument.Param param : resource.getParamList()) {
            if ((param = this.resolveParameter(param)) == null) continue;
            String nm = param.getName();
            RestParamProperty prop = newResource.hasProperty(nm) ? newResource.getProperty(nm) : newResource.addProperty(nm);
            this.initParam(param, prop);
        }
        for (MethodDocument.Method method : resource.getMethodList()) {
            method = this.resolveMethod(method);
            this.initMethod(newResource, method);
        }
        List types = resource.getType();
        if (types != null && types.size() > 0) {
            for (Object obj : types) {
                ResourceTypeDocument.ResourceType type = this.resolveResource(obj.toString());
                if (type == null) continue;
                for (MethodDocument.Method method : type.getMethodList()) {
                    method = this.resolveMethod(method);
                    RestMethod restMethod = this.initMethod(newResource, method);
                    for (ParamDocument.Param param : type.getParamList()) {
                        if ((param = this.resolveParameter(param)) == null) continue;
                        String nm = param.getName();
                        RestParamProperty prop = restMethod.hasProperty(nm) ? restMethod.getProperty(nm) : restMethod.addProperty(nm);
                        this.initParam(param, prop);
                    }
                }
            }
        }
    }

    private RestMethod initMethod(RestResource newResource, MethodDocument.Method method) {
        Object name = this.getFirstTitle(method.getDocList(), method.getName());
        String id = method.getId();
        if (StringUtils.hasContent(id) && !id.trim().equals(((String)name).trim())) {
            name = (String)name + " - " + method.getId();
        }
        if (newResource.getRestMethodByName((String)name) != null) {
            int cnt = 0;
            String orgName = name;
            while (newResource.getRestMethodByName((String)name) != null) {
                name = orgName + "-" + ++cnt;
            }
        }
        RestMethod restMethod = newResource.addNewMethod((String)name);
        restMethod.setMethod(RestRequestInterface.HttpMethod.valueOf(method.getName()));
        if (method.getRequest() != null) {
            for (ParamDocument.Param param : method.getRequest().getParamList()) {
                if ((param = this.resolveParameter(param)) == null) continue;
                RestParamProperty p = restMethod.addProperty(param.getName());
                this.initParam(param, p);
            }
            for (RepresentationDocument.Representation representation : method.getRequest().getRepresentationList()) {
                representation = this.resolveRepresentation(representation);
                this.addRepresentationFromConfig(restMethod, representation, RestRepresentation.Type.REQUEST, null);
            }
        }
        for (ResponseDocument.Response response : method.getResponseList()) {
            for (RepresentationDocument.Representation representation : response.getRepresentationList()) {
                this.addRepresentation(response, restMethod, representation);
            }
            if (this.isWADL11) continue;
            NodeList children = response.getDomNode().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (!"fault".equals(n.getNodeName())) continue;
                String content = XmlUtils.serialize(n, false);
                try {
                    HashMap map = new HashMap();
                    XmlCursor cursor = response.newCursor();
                    cursor.getAllNamespaces(map);
                    cursor.dispose();
                    XmlOptions options = new XmlOptions();
                    options.setLoadAdditionalNamespaces(map);
                    XmlObject obj = XmlUtils.createXmlObject(content.replaceFirst("<(([a-z]+:)?)fault ", "<$1representation "), options);
                    RepresentationDocument representation = (RepresentationDocument)obj.changeType(RepresentationDocument.type);
                    this.addRepresentation(response, restMethod, representation.getRepresentation());
                    continue;
                }
                catch (XmlException xmlException) {
                    // empty catch block
                }
            }
        }
        restMethod.addNewRequest("Request 1");
        return restMethod;
    }

    private void addRepresentation(ResponseDocument.Response response, RestMethod restMethod, RepresentationDocument.Representation representation) {
        representation = this.resolveRepresentation(representation);
        ArrayList<Long> status = null;
        if (this.isWADL11) {
            status = response.getStatus();
        } else {
            Node n = representation.getDomNode().getAttributes().getNamedItem("status");
            if (n != null) {
                status = new ArrayList<Long>();
                for (String s : n.getNodeValue().split(" ")) {
                    status.add(Long.parseLong(s));
                }
            }
        }
        boolean fault = false;
        if (status != null && status.size() > 0) {
            fault = true;
            for (Long s : status) {
                if (s >= 400L) continue;
                fault = false;
                break;
            }
        }
        RestRepresentation.Type type = fault ? RestRepresentation.Type.FAULT : RestRepresentation.Type.RESPONSE;
        this.addRepresentationFromConfig(restMethod, representation, type, status);
    }

    private void addRepresentationFromConfig(RestMethod restMethod, RepresentationDocument.Representation representation, RestRepresentation.Type type, List<?> status) {
        RestRepresentation restRepresentation = restMethod.addNewRepresentation(type);
        restRepresentation.setMediaType(representation.getMediaType());
        restRepresentation.setElement(representation.getElement());
        if (status != null) {
            restRepresentation.setStatus(status);
        }
        restRepresentation.setId(representation.getId());
        restRepresentation.setDescription(this.getFirstTitle(representation.getDocList(), null));
    }

    private void initParam(ParamDocument.Param param, RestParamProperty prop) {
        prop.setDefaultValue(param.getDefault());
        prop.setValue(param.getDefault());
        ParamStyle.Enum paramStyle = param.getStyle();
        if (paramStyle == null) {
            paramStyle = ParamStyle.QUERY;
        }
        prop.setStyle(RestParamsPropertyHolder.ParameterStyle.valueOf(paramStyle.toString().toUpperCase()));
        prop.setRequired(param.getRequired());
        QName paramType = param.getType();
        prop.setType(paramType);
        String[] options = new String[param.sizeOfOptionArray()];
        for (int c = 0; c < options.length; ++c) {
            options[c] = param.getOptionArray(c).getValue();
        }
        if (options.length > 0) {
            prop.setOptions(options);
        }
    }

    private MethodDocument.Method resolveMethod(MethodDocument.Method method) {
        String href = method.getHref();
        if (!StringUtils.hasContent(href)) {
            return method;
        }
        for (MethodDocument.Method m : this.application.getMethodList()) {
            if (!m.getId().equals(href.substring(1))) continue;
            return m;
        }
        try {
            ApplicationDocument applicationDocument = this.loadReferencedWadl(href);
            if (applicationDocument != null) {
                int ix = href.lastIndexOf(35);
                if (ix > 0) {
                    href = href.substring(ix + 1);
                }
                for (MethodDocument.Method m : this.application.getMethodList()) {
                    if (!m.getId().equals(href)) continue;
                    return m;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return method;
    }

    private RepresentationDocument.Representation resolveRepresentation(RepresentationDocument.Representation representation) {
        String href = representation.getHref();
        if (!StringUtils.hasContent(href)) {
            return representation;
        }
        try {
            ApplicationDocument.Application app = this.application;
            if (!href.startsWith("#")) {
                ApplicationDocument applicationDocument = this.loadReferencedWadl(href);
                app = applicationDocument.getApplication();
            }
            if (app != null) {
                int ix = href.lastIndexOf(35);
                if (ix >= 0) {
                    href = href.substring(ix + 1);
                }
                for (RepresentationDocument.Representation m : this.application.getRepresentationList()) {
                    if (!m.getId().equals(href)) continue;
                    return m;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return representation;
    }

    private ParamDocument.Param resolveParameter(ParamDocument.Param param) {
        String href = param.getHref();
        if (!StringUtils.hasContent(href)) {
            return param;
        }
        try {
            ApplicationDocument.Application app = this.application;
            if (!href.startsWith("#")) {
                ApplicationDocument applicationDocument = this.loadReferencedWadl(href);
                app = applicationDocument.getApplication();
            }
            if (app != null) {
                int ix = href.lastIndexOf(35);
                if (ix >= 0) {
                    href = href.substring(ix + 1);
                }
                for (ParamDocument.Param p : this.application.getParamList()) {
                    if (!p.getId().equals(href)) continue;
                    return p;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ResourceTypeDocument.ResourceType resolveResource(String id) {
        for (ResourceTypeDocument.ResourceType resourceType : this.application.getResourceTypeList()) {
            if (!resourceType.getId().equals(id)) continue;
            return resourceType;
        }
        try {
            ApplicationDocument applicationDocument = this.loadReferencedWadl(id);
            if (applicationDocument != null) {
                int ix = id.lastIndexOf(35);
                if (ix > 0) {
                    id = id.substring(ix + 1);
                }
                for (ResourceTypeDocument.ResourceType resourceType : applicationDocument.getApplication().getResourceTypeList()) {
                    if (!resourceType.getId().equals(id)) continue;
                    return resourceType;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ApplicationDocument loadReferencedWadl(String id) throws URISyntaxException, XmlException, IOException {
        ApplicationDocument applicationDocument;
        int ix = id.indexOf(35);
        if (ix != -1) {
            id = id.substring(0, ix);
        }
        if ((applicationDocument = this.refCache.get(id)) == null) {
            URI uri = new URI(id);
            applicationDocument = ApplicationDocument.Factory.parse(uri.toURL());
            this.refCache.put(id, applicationDocument);
        }
        return applicationDocument;
    }

    public static Map<String, XmlObject> getDefinitionParts(String wadlUrl) {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        try {
            return SchemaUtils.getSchemas(wadlUrl, new UrlSchemaLoader(wadlUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static String extractParams(URL param, RestParamsPropertyHolder params) {
        RestParamProperty property;
        String name;
        String path = param.getPath();
        String[] items = path.split("/");
        int templateParamCount = 0;
        StringBuffer resultPath = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            try {
                String[] matrixParams = ((String)item).split(";");
                if (matrixParams.length > 0) {
                    item = matrixParams[0];
                    for (int c = 1; c < matrixParams.length; ++c) {
                        String matrixParam = matrixParams[c];
                        int ix = matrixParam.indexOf(61);
                        if (ix == -1) {
                            params.addProperty(URLDecoder.decode(matrixParam, "Utf-8")).setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                            continue;
                        }
                        name = matrixParam.substring(0, ix);
                        property = params.addProperty(URLDecoder.decode(name, "Utf-8"));
                        property.setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                        property.setValue(URLDecoder.decode(matrixParam.substring(ix + 1), "Utf-8"));
                    }
                }
                Integer.parseInt((String)item);
                RestParamProperty prop = params.addProperty("param" + templateParamCount++);
                prop.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                prop.setValue((String)item);
                item = "{" + prop.getName() + "}";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!StringUtils.hasContent((String)item)) continue;
            resultPath.append('/').append((String)item);
        }
        String query = param.getQuery();
        if (StringUtils.hasContent(query)) {
            for (String item : items = query.split("&")) {
                try {
                    int ix = item.indexOf(61);
                    if (ix == -1) {
                        params.addProperty(URLDecoder.decode(item, "Utf-8")).setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                        continue;
                    }
                    name = item.substring(0, ix);
                    property = params.addProperty(URLDecoder.decode(name, "Utf-8"));
                    property.setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                    property.setValue(URLDecoder.decode(item.substring(ix + 1), "Utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultPath.toString();
    }
}

