/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.html;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponentFactory;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HttpHtmlResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private HttpRequestInterface<?> httpRequest;
    private JPanel panel = new JPanel(new BorderLayout());
    private WebViewBasedBrowserComponent browser;
    private MessageExchangeModelItem messageExchangeModelItem;
    private boolean initialized = false;

    public HttpHtmlResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("HTML", httpRequestMessageEditor, "HTML Response");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean activate(EditorLocation<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument> location) {
        boolean activated = super.activate(location);
        if (activated) {
            this.ensureComponentIsInitialized();
            HttpResponse response = this.httpRequest.getResponse();
            if (response != null) {
                this.setEditorContent(response);
            }
        }
        return activated;
    }

    private void ensureComponentIsInitialized() {
        if (!this.initialized) {
            if (SoapUI.isBrowserDisabled()) {
                this.panel.add(new JLabel("Browser component is disabled."));
            } else {
                this.browser = WebViewBasedBrowserComponentFactory.createBrowserComponent(false);
                Component component = this.browser.getComponent();
                component.setMinimumSize(new Dimension(100, 100));
                this.panel.add(component, "Center");
            }
            this.initialized = true;
        }
    }

    @Override
    public boolean deactivate() {
        boolean deactivated = super.deactivate();
        if (deactivated) {
            this.browser.setContent("");
        }
        return deactivated;
    }

    @Override
    public void release() {
        super.release();
        if (this.browser != null) {
            this.browser.close(true);
        }
        if (this.messageExchangeModelItem != null) {
            this.messageExchangeModelItem.removePropertyChangeListener(this);
        } else {
            this.httpRequest.removePropertyChangeListener(this);
        }
        this.httpRequest = null;
        this.messageExchangeModelItem = null;
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse == null || SoapUI.isBrowserDisabled()) {
            return;
        }
        String content = httpResponse.getContentAsString();
        if (content != null) {
            String contentType = httpResponse.getContentType();
            if (contentType != null && this.isSupportedContentType(contentType)) {
                try {
                    this.browser.setContent(content, contentType);
                }
                catch (Exception e) {
                    SoapUI.logError(e, "Could not display response from " + httpResponse.getURL() + " as HTML");
                }
            } else {
                this.browser.setContent("unsupported content-type [" + contentType + "]");
            }
        } else {
            this.browser.setContent("<missing content>");
        }
    }

    private boolean isSupportedContentType(String contentType) {
        return contentType != null && (contentType.trim().toLowerCase().startsWith("text") || contentType.trim().toLowerCase().startsWith("image"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && this.browser != null) {
            this.setEditorContent((HttpResponse)evt.getNewValue());
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }

    @Override
    public int getSupportScoreForContentType(String contentType) {
        return contentType.toLowerCase().endsWith("html") ? 2 : 0;
    }

    public HttpRequestInterface<?> getHttpRequest() {
        return this.httpRequest;
    }
}

