/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.service;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.List;

public class GenerateRestMockServiceAction
extends AbstractSoapUIAction<RestService> {
    XFormDialog dialog = null;

    public GenerateRestMockServiceAction() {
        super("Generate REST Mock Service", "Generates a REST mock service containing all resources of this REST service");
    }

    @Override
    public void perform(RestService restService, Object param) {
        String mockServiceName;
        RestMockService mockService;
        this.createDialog(restService);
        if (this.dialog.show() && (mockService = this.getMockService(mockServiceName = this.dialog.getValue("MockService Name"), restService.getProject())) != null) {
            this.populateMockService(restService, mockService);
            restService.addEndpoint(mockService.getLocalEndpoint());
            UISupport.showDesktopPanel(mockService);
            Analytics.trackAction(SoapUIActions.GENERATE_REST_MOCK_FROM_NAVIGATOR);
            this.maybeStart(mockService);
        }
    }

    private void createDialog(RestService restService) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        String nextMockServiceName = this.nextMockServiceName(restService);
        this.dialog.setValue("MockService Name", nextMockServiceName);
    }

    private void maybeStart(MockService mockService) {
        try {
            mockService.startIfConfigured();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            UISupport.showErrorMessage(e.getMessage());
        }
    }

    private String nextMockServiceName(RestService restService) {
        int nextMockServiceCount = restService.getProject().getRestMockServiceCount() + 1;
        return "REST MockService " + nextMockServiceCount;
    }

    private void populateMockService(RestService restService, RestMockService mockService) {
        mockService.setPath("/");
        mockService.setPort(8089);
        this.addMockOperations(restService, mockService);
    }

    private RestMockService getMockService(String mockServiceName, WsdlProject project) {
        if (StringUtils.isNullOrEmpty(mockServiceName)) {
            UISupport.showInfoMessage("The mock service name can not be empty");
            return null;
        }
        if (project.getRestMockServiceByName(mockServiceName) == null) {
            return project.addNewRestMockService(mockServiceName);
        }
        UISupport.showInfoMessage("The mock service name need to be unique. '" + mockServiceName + "' already exists.");
        return null;
    }

    private void addMockOperations(RestService restService, RestMockService mockService) {
        for (RestResource oneResource : restService.getAllResources()) {
            List<MockOperation> listOfOperations = mockService.addNewMockOperationsFromResource(oneResource);
            for (MockOperation mockOperation : listOfOperations) {
                if (mockOperation == null) continue;
                mockOperation.addNewMockResponse("Response 1");
            }
        }
    }

    protected void setFormDialog(XFormDialog dialog) {
        this.dialog = dialog;
    }

    @AForm(name="Generate REST Mock Service", description="Set name for the new REST Mock Service", helpUrl="/rest-testing-mocking/rest-mock-service-creation/rest-mock-from-service.html")
    protected static interface Form {
        @AField(name="MockService Name", description="The Mock Service name", type=AField.AFieldType.STRING)
        public static final String MOCKSERVICE_NAME = "MockService Name";
    }
}

