/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.RestRequestConfig;
import com.eviware.soapui.config.StringToStringMapConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestRequestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.handlers.JsonMediaTypeHandler;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderConfig;
import com.eviware.soapui.impl.wsdl.support.jms.property.JMSPropertiesConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlString;

public class RestRequest
extends AbstractHttpRequest<RestRequestConfig>
implements RestRequestInterface {
    static final String ACCEPT_HEADER_NAME = "Accept";
    private RestMethod method;
    private RestRequestParamsPropertyHolder params;
    private ParamUpdater paramUpdater;
    private JMSHeaderConfig jmsHeaderConfig;
    private JMSPropertiesConfig jmsPropertyConfig;

    public RestRequest(RestMethod method, RestRequestConfig requestConfig, boolean forLoadTest) {
        super(requestConfig, method.getOperation(), "/rest_request_step.png", forLoadTest);
        this.method = method;
        if (requestConfig.getParameters() == null) {
            requestConfig.addNewParameters();
        }
        StringToStringMap paramValues = StringToStringMap.fromXml(requestConfig.getParameters());
        this.params = new RestRequestParamsPropertyHolder(method.getOverlayParams(), this, paramValues);
        this.paramUpdater = new ParamUpdater(paramValues);
        this.params.addTestPropertyListener(this.paramUpdater);
        method.addPropertyChangeListener(this);
        if (requestConfig.getMediaType() == null) {
            String defaultMediaType = this.getRestMethod().getDefaultRequestMediaType();
            ((RestRequestConfig)this.getConfig()).setMediaType(defaultMediaType);
        }
        this.cleanUpAcceptEncoding();
    }

    @Override
    public ModelItem getParent() {
        return this.getRestMethod();
    }

    @Override
    public RestMethod getRestMethod() {
        return this.method;
    }

    @Override
    protected AbstractHttpRequest.RequestIconAnimator<?> initIconAnimator() {
        return new AbstractHttpRequest.RequestIconAnimator<RestRequest>(this, "/rest_request.gif", "/exec_rest_request.gif", 4);
    }

    @Override
    public MessagePart[] getRequestParts() {
        ArrayList<MessagePart.ContentPart> result = new ArrayList<MessagePart.ContentPart>();
        for (int c = 0; c < this.getPropertyCount(); ++c) {
            result.add(new ParameterMessagePart(this.getPropertyAt(c)));
        }
        if (this.getMethod() == RestRequestInterface.HttpMethod.POST || this.getMethod() == RestRequestInterface.HttpMethod.PUT || this.getMethod() == RestRequestInterface.HttpMethod.PATCH) {
            result.add(new RestContentPart());
        }
        return result.toArray(new MessagePart[result.size()]);
    }

    @Override
    public RestRepresentation[] getRepresentations() {
        return this.getRepresentations(null, null);
    }

    @Override
    public RestRepresentation[] getRepresentations(RestRepresentation.Type type) {
        return this.getRepresentations(type, null);
    }

    @Override
    public RestRepresentation[] getRepresentations(RestRepresentation.Type type, String mediaType) {
        return this.getRestMethod().getRepresentations(type, mediaType);
    }

    @Override
    public MessagePart[] getResponseParts() {
        return new MessagePart[0];
    }

    @Override
    public RestRequestInterface.HttpMethod getMethod() {
        return this.getRestMethod().getMethod();
    }

    @Override
    public String getAccept() {
        String accept = ((RestRequestConfig)this.getConfig()).getAccept();
        return accept == null ? "" : accept;
    }

    @Override
    public void setAccept(String acceptEncoding) {
        String old = this.getAccept();
        ((RestRequestConfig)this.getConfig()).setAccept(acceptEncoding);
        this.notifyPropertyChanged("accept", old, acceptEncoding);
    }

    @Override
    public void setMediaType(String mediaType) {
        String old = this.getMediaType();
        ((RestRequestConfig)this.getConfig()).setMediaType(mediaType);
        this.notifyPropertyChanged("mediaType", old, mediaType);
    }

    @Override
    public String getMediaType() {
        return ((RestRequestConfig)this.getConfig()).getMediaType();
    }

    @Override
    public void setMethod(RestRequestInterface.HttpMethod method) {
        this.getRestMethod().setMethod(method);
    }

    @Override
    public WsdlSubmit<RestRequest> submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        String endpoint = PropertyExpander.expandProperties(submitContext, this.getEndpoint());
        if (StringUtils.isNullOrEmpty(endpoint)) {
            try {
                endpoint = new URL(this.getPath()).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (StringUtils.isNullOrEmpty(endpoint)) {
            UISupport.showErrorMessage("Missing endpoint for request [" + this.getName() + "]");
            return null;
        }
        try {
            WsdlSubmit<RestRequest> submitter = new WsdlSubmit<RestRequest>(this, this.getSubmitListeners(), RequestTransportRegistry.getTransport(endpoint, submitContext));
            submitter.submitRequest(submitContext, async);
            this.addPropertyChangeListener(AbstractHttpRequest.RESPONSE_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() != null) {
                        RestRequest.this.setOriginalUriInConfig((HttpResponse)evt.getNewValue());
                    }
                }
            });
            return submitter;
        }
        catch (Exception e) {
            throw new Request.SubmitException(e.toString());
        }
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this);
        result.addAll(super.getPropertyExpansions());
        result.addAll(this.getRestMethod().getPropertyExpansions());
        result.addAll(this.params.getPropertyExpansions());
        this.addJMSHeaderExpansions(result, this.getJMSHeaderConfig(), this);
        return result.toArray();
    }

    public void addJMSHeaderExpansions(PropertyExpansionsResult result, JMSHeaderConfig jmsHeaderConfig, ModelItem modelItem) {
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSCorrelationID"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSReplyTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSType"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSPriority"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "timeToLive"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "durableSubscriptionName"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "clientID"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "sendAsBytesMessage"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "soapActionAdd"));
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.params.addProperty(name);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.params.moveProperty(propertyName, targetIndex);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.params.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.params.renameProperty(name, newName);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.params.addTestPropertyListener(listener);
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public RestResource getOperation() {
        return this.method.getOperation();
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.params.getProperties();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.params.getProperty(name);
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.params.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public String[] getPropertyNames() {
        return this.params.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.params.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.params.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.params.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.params.setPropertyValue(name, value);
    }

    public void resetPropertyValues() {
        this.params.clear();
        for (String name : this.params.getPropertyNames()) {
            this.params.getProperty(name).setValue(this.params.getProperty(name).getDefaultValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("path")) {
            this.notifyPropertyChanged("path", null, this.getPath());
        } else if (evt.getPropertyName().equals("method")) {
            this.notifyPropertyChanged("method", evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public String[] getResponseMediaTypes() {
        StringList result = new StringList();
        for (RestRepresentation representation : this.getRepresentations(RestRepresentation.Type.RESPONSE, null)) {
            if (result.contains(representation.getMediaType())) continue;
            result.add(representation.getMediaType());
        }
        return result.toStringArray();
    }

    @Override
    public boolean isPostQueryString() {
        return this.hasRequestBody() && ((RestRequestConfig)this.getConfig()).getPostQueryString();
    }

    @Override
    public void setPostQueryString(boolean b) {
        boolean old = this.isPostQueryString();
        ((RestRequestConfig)this.getConfig()).setPostQueryString(b);
        this.notifyPropertyChanged("postQueryString", old, b);
        if (!"multipart/form-data".equals(this.getMediaType()) && !"multipart/mixed".equals(this.getMediaType())) {
            this.setMediaType(b ? "application/x-www-form-urlencoded" : this.getMediaType());
        }
    }

    @Override
    public String getPropertiesLabel() {
        return "Request Params";
    }

    @Override
    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        return null;
    }

    public HttpAttachmentPart[] getDefinedAttachmentParts() {
        return new HttpAttachmentPart[0];
    }

    @Override
    public boolean hasRequestBody() {
        return this.getRestMethod().hasRequestBody();
    }

    @Override
    public RestResource getResource() {
        return this.getOperation();
    }

    @Override
    public String getPath() {
        if (!StringUtils.isNullOrEmpty(((RestRequestConfig)this.getConfig()).getFullPath()) || this.getResource() == null) {
            return ((RestRequestConfig)this.getConfig()).getFullPath();
        }
        return this.getResource().getFullPath();
    }

    @Override
    public void setPath(String fullPath) {
        String old = this.getPath();
        if (this.getResource() != null && this.getResource().getFullPath().equals(fullPath)) {
            ((RestRequestConfig)this.getConfig()).unsetFullPath();
        } else {
            ((RestRequestConfig)this.getConfig()).setFullPath(fullPath);
        }
        this.notifyPropertyChanged("path", old, fullPath);
    }

    @Override
    public String getResponseContentAsXml() {
        HttpResponse response = this.getResponse();
        if (response == null) {
            return null;
        }
        return response.getContentAsXml();
    }

    @Override
    public void release() {
        super.release();
        if (this.method != null) {
            this.method.removePropertyChangeListener(this);
        }
        this.params.removeTestPropertyListener(this.paramUpdater);
        this.params.release();
    }

    @Override
    public void updateConfig(RestRequestConfig request) {
        this.setConfig(request);
        this.updateParams();
        List<AttachmentConfig> attachmentConfigs = ((RestRequestConfig)this.getConfig()).getAttachmentList();
        for (int i = 0; i < attachmentConfigs.size(); ++i) {
            AttachmentConfig config = attachmentConfigs.get(i);
            this.getAttachmentsList().get(i).updateConfig(config);
        }
        if (this.jmsHeaderConfig != null) {
            this.jmsHeaderConfig.setJMSHeaderConfConfig(request.getJmsConfig());
        }
        if (this.jmsPropertyConfig != null) {
            this.jmsPropertyConfig.setJmsPropertyConfConfig(request.getJmsPropertyConfig());
        }
    }

    protected void updateParams() {
        StringToStringMap paramValues = StringToStringMap.fromXml(((RestRequestConfig)this.getConfig()).getParameters());
        this.params.reset(this.getRestMethod().getOverlayParams(), paramValues);
        this.paramUpdater.setValues(paramValues);
    }

    @Override
    public boolean hasEndpoint() {
        return super.hasEndpoint() || PathUtils.isHttpPath(this.getPath());
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.params.getPropertyList();
    }

    protected void setRestMethod(RestMethod restMethod) {
        if (this.method != null) {
            this.method.removePropertyChangeListener(this);
        }
        this.method = restMethod;
        if (this.method != null) {
            this.method.addPropertyChangeListener(this);
        }
        this.updateParams();
    }

    @Override
    public JMSHeaderConfig getJMSHeaderConfig() {
        if (this.jmsHeaderConfig == null) {
            if (!((RestRequestConfig)this.getConfig()).isSetJmsConfig()) {
                ((RestRequestConfig)this.getConfig()).addNewJmsConfig();
            }
            this.jmsHeaderConfig = new JMSHeaderConfig(((RestRequestConfig)this.getConfig()).getJmsConfig(), this);
        }
        return this.jmsHeaderConfig;
    }

    @Override
    public JMSPropertiesConfig getJMSPropertiesConfig() {
        if (this.jmsPropertyConfig == null) {
            if (!((RestRequestConfig)this.getConfig()).isSetJmsPropertyConfig()) {
                ((RestRequestConfig)this.getConfig()).addNewJmsPropertyConfig();
            }
            this.jmsPropertyConfig = new JMSPropertiesConfig(((RestRequestConfig)this.getConfig()).getJmsPropertyConfig(), this);
        }
        return this.jmsPropertyConfig;
    }

    @Override
    public String getMultiValueDelimiter() {
        return ((RestRequestConfig)this.getConfig()).getMultiValueDelimiter();
    }

    public void setMultiValueDelimiter(String delimiter) {
        String old = this.getMultiValueDelimiter();
        ((RestRequestConfig)this.getConfig()).setMultiValueDelimiter(delimiter);
        this.notifyPropertyChanged("multiValueDelimiter", old, delimiter);
    }

    private void setOriginalUriInConfig(HttpResponse response) {
        if (((RestRequestConfig)this.getConfig()).getOriginalUri() == null && response.getURL() != null) {
            ((RestRequestConfig)this.getConfig()).setOriginalUri(JsonMediaTypeHandler.makeNamespaceUriFrom(response.getURL()));
        }
    }

    private void cleanUpAcceptEncoding() {
        if (StringUtils.hasContent(this.getAccept())) {
            StringToStringsMap requestHeaders = this.getRequestHeaders();
            requestHeaders.add(ACCEPT_HEADER_NAME, this.getAccept());
            this.setRequestHeaders(requestHeaders);
            this.setAccept(null);
        }
    }

    private class ParamUpdater
    implements TestPropertyListener {
        private StringToStringMap values;

        public ParamUpdater(StringToStringMap paramValues) {
            this.values = paramValues;
        }

        public void setValues(StringToStringMap paramValues) {
            this.values = paramValues;
        }

        private void sync() {
            try {
                RestRequestConfig requestConfig = (RestRequestConfig)RestRequest.this.getConfig();
                requestConfig.setParameters(StringToStringMapConfig.Factory.parse(this.values.toXml()));
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void propertyAdded(String name) {
            this.sync();
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
        }

        @Override
        public void propertyRemoved(String name) {
            this.sync();
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            this.sync();
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            this.sync();
        }
    }

    public static final class ParameterMessagePart
    extends MessagePart.ParameterPart {
        private String name;

        public ParameterMessagePart(TestProperty propertyAt) {
            this.name = propertyAt.getName();
        }

        @Override
        public SchemaType getSchemaType() {
            return XmlString.type;
        }

        @Override
        public SchemaGlobalElement getPartElement() {
            return null;
        }

        @Override
        public QName getPartElementName() {
            return new QName(this.getName());
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public class RestContentPart
    extends MessagePart.ContentPart
    implements MessagePart {
        @Override
        public SchemaGlobalElement getPartElement() {
            return null;
        }

        @Override
        public QName getPartElementName() {
            return null;
        }

        @Override
        public SchemaType getSchemaType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        public String getMediaType() {
            return ((RestRequestConfig)RestRequest.this.getConfig()).getMediaType();
        }
    }
}

