/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.AccessTokenPositionConfig;
import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.config.OAuth1ProfileConfig;
import com.eviware.soapui.config.RefreshAccessTokenMethodConfig;
import com.eviware.soapui.config.TimeUnitConfig;
import com.eviware.soapui.impl.rest.OAuth1ProfileContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.opensaml.xml.util.DatatypeHelper;

public class OAuth1Profile
implements PropertyExpansionContainer {
    public static final String CLIENT_ID_PROPERTY = "clientID";
    public static final String CLIENT_SECRET_PROPERTY = "clientSecret";
    public static final String AUTHORIZATION_URI_PROPERTY = "authorizationURI";
    public static final String ACCESS_TOKEN_URI_PROPERTY = "accessTokenURI";
    public static final String REDIRECT_URI_PROPERTY = "redirectURI";
    public static final String ACCESS_TOKEN_PROPERTY = "accessToken";
    public static final String REFRESH_TOKEN_PROPERTY = "refreshToken";
    public static final String SCOPE_PROPERTY = "scope";
    public static final String ACCESS_TOKEN_STATUS_PROPERTY = "accessTokenStatus";
    public static final String ACCESS_TOKEN_POSITION_PROPERTY = "accessTokenPosition";
    public static final String ACCESS_TOKEN_EXPIRATION_TIME = "accessTokenExpirationTime";
    public static final String ACCESS_TOKEN_ISSUED_TIME = "accessTokenIssuedTime";
    public static final String MANUAL_ACCESS_TOKEN_EXPIRATION_TIME = "manualAccessTokenExpirationTime";
    public static final String USE_MANUAL_ACCESS_TOKEN_EXPIRATION_TIME = "useManualAccessTokenExpirationTime";
    public static final String REFRESH_ACCESS_TOKEN_METHOD_PROPERTY = "refreshAccessTokenMethod";
    public static final String MANUAL_ACCESS_TOKEN_EXPIRATION_TIME_UNIT_PROPERTY = "manualAccessTokenExpirationTimeUnit";
    public static final String TOKEN_SECRET_PROPERTY = "tokenSecret";
    public static final String TEMPORARY_TOKEN_URI_PROPERTY = "temporaryTokenURI";
    public static final String CONSUMER_SECRET_PROPERTY = "consumerSecret";
    public static final String CONSUMER_KEY_PROPERTY = "consumerKey";
    public static final String RESOURCE_OWNER_LOGIN_PROPERTY = "resourceOwnerName";
    public static final String RESOURCE_OWNER_PASSWORD_PROPERTY = "resourceOwnerPassword";
    public static final String TOKEN_SECRET_STATUS_PROPERTY = "tokenSecretStatus";
    private final OAuth1ProfileContainer OAuth1ProfileContainer;
    private final OAuth1ProfileConfig configuration;
    private final PropertyChangeSupport pcs;

    public OAuth1Profile(OAuth1ProfileContainer OAuth1ProfileContainer2, OAuth1ProfileConfig configuration) {
        this.OAuth1ProfileContainer = OAuth1ProfileContainer2;
        this.configuration = configuration;
        this.pcs = new PropertyChangeSupport(this);
        this.setDefaultAccessTokenPosition();
        this.setDefaultAccessTokenStatus();
    }

    public String getName() {
        if (StringUtils.isEmpty((String)this.configuration.getName())) {
            this.configuration.setName("OAuth 1 - Profile 1");
        }
        return this.configuration.getName();
    }

    public void setName(String newName) {
        this.configuration.setName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAccessTokenStatus(AccessTokenStatusConfig.Enum accessTokenStatus, int timeout) {
        int timeLeft = timeout;
        while (this.getAccessTokenStatus() != accessTokenStatus && timeLeft > 0) {
            long startTime = System.currentTimeMillis();
            try {
                OAuth1Profile oAuth1Profile = this;
                synchronized (oAuth1Profile) {
                    this.wait(timeLeft);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeLeft = (int)((long)timeLeft - (System.currentTimeMillis() - startTime));
        }
    }

    public void applyRetrievedAccessToken(String accessToken) {
        this.doSetAccessToken(accessToken);
        this.setAccessTokenStatus(AccessTokenStatusConfig.RETRIEVED_FROM_SERVER);
    }

    public String getAccessToken() {
        return this.configuration.getAccessToken();
    }

    public void setAccessToken(String accessToken) {
        if (this.doSetAccessToken(accessToken)) {
            this.setAccessTokenStatus(AccessTokenStatusConfig.ENTERED_MANUALLY);
        }
    }

    public String getConsumerKey() {
        return this.configuration.getConsumerKey();
    }

    public void setConsumerKey(String consumerKey) {
        String newValue;
        String oldValue = this.configuration.getConsumerKey();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = DatatypeHelper.safeTrim((String)consumerKey)))) {
            this.configuration.setConsumerKey(newValue);
            this.pcs.firePropertyChange(CONSUMER_KEY_PROPERTY, oldValue, newValue);
        }
    }

    public String getTokenSecret() {
        return this.configuration.getTokenSecret();
    }

    public void setTokenSecret(String tokenSecret) {
        if (this.doSetTokenSecret(tokenSecret)) {
            this.setTokenSecretStatus(AccessTokenStatusConfig.ENTERED_MANUALLY);
        }
    }

    public String getTemporaryTokenURI() {
        return this.configuration.getTemporaryTokenURI();
    }

    public void setTemporaryTokenURI(String temporaryTokenURI) {
        String newValue;
        String oldValue = this.configuration.getTemporaryTokenURI();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = DatatypeHelper.safeTrim((String)temporaryTokenURI)))) {
            this.configuration.setTemporaryTokenURI(newValue);
            this.pcs.firePropertyChange(TEMPORARY_TOKEN_URI_PROPERTY, oldValue, newValue);
        }
    }

    public String getConsumerSecret() {
        return this.configuration.getConsumerSecret();
    }

    public void setConsumerSecret(String consumerSecret) {
        String newValue;
        String oldValue = this.configuration.getConsumerSecret();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = DatatypeHelper.safeTrim((String)consumerSecret)))) {
            this.configuration.setConsumerSecret(newValue);
            this.pcs.firePropertyChange(CONSUMER_SECRET_PROPERTY, oldValue, newValue);
        }
    }

    public void resetTokenSecretStatusToStartingStatus() {
        this.setTokenSecretStatus(this.getTokenSecretStartingStatus());
    }

    public AccessTokenStatusConfig.Enum getTokenSecretStartingStatus() {
        AccessTokenStatusConfig.Enum result = this.configuration.getTokenSecretStartingStatus();
        if (result == null) {
            result = AccessTokenStatusConfig.UNKNOWN;
        }
        return result;
    }

    public void setTokenSecretStartingStatus(AccessTokenStatusConfig.Enum startingStatus) {
        if (startingStatus == null) {
            startingStatus = AccessTokenStatusConfig.UNKNOWN;
        }
        this.configuration.setTokenSecretStartingStatus(startingStatus);
    }

    public AccessTokenStatusConfig.Enum getTokenSecretStatus() {
        AccessTokenStatusConfig.Enum result = this.configuration.getTokenSecretStatus();
        if (result == null) {
            result = AccessTokenStatusConfig.UNKNOWN;
        }
        return result;
    }

    public void setTokenSecretStatus(AccessTokenStatusConfig.Enum newStatus) {
        boolean isStartingStatus;
        AccessTokenStatusConfig.Enum oldStatus;
        if (newStatus == null) {
            newStatus = AccessTokenStatusConfig.UNKNOWN;
        }
        if (newStatus == (oldStatus = this.configuration.getTokenSecretStatus())) {
            return;
        }
        if (newStatus == AccessTokenStatusConfig.UNKNOWN) {
            if (this.configuration.isSetTokenSecretStatus()) {
                this.configuration.unsetTokenSecretStatus();
            }
        } else {
            this.configuration.setTokenSecretStatus(newStatus);
        }
        boolean bl = isStartingStatus = newStatus == AccessTokenStatusConfig.ENTERED_MANUALLY || newStatus == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER || newStatus == AccessTokenStatusConfig.EXPIRED;
        if (isStartingStatus) {
            this.setTokenSecretStartingStatus(newStatus);
        }
        this.pcs.firePropertyChange(TOKEN_SECRET_STATUS_PROPERTY, (Object)oldStatus, (Object)newStatus);
    }

    private boolean doSetAccessToken(String accessToken) {
        String newValue;
        String oldValue = this.configuration.getAccessToken();
        String string = newValue = accessToken == null ? null : accessToken.trim();
        if (!StringUtils.equals((String)oldValue, (String)newValue)) {
            this.configuration.setAccessToken(newValue);
            this.pcs.firePropertyChange(ACCESS_TOKEN_PROPERTY, oldValue, newValue);
            return true;
        }
        return false;
    }

    public String getAuthorizationURI() {
        return this.configuration.getAuthorizationURI();
    }

    public void setAuthorizationURI(String authorizationURI) {
        String newValue;
        String oldValue = this.configuration.getAuthorizationURI();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = this.nullSafeTrim(authorizationURI)))) {
            this.configuration.setAuthorizationURI(newValue);
            this.pcs.firePropertyChange(AUTHORIZATION_URI_PROPERTY, oldValue, newValue);
        }
    }

    private String nullSafeTrim(String inputString) {
        return inputString == null ? null : inputString.trim();
    }

    public String getRedirectURI() {
        return this.configuration.getRedirectURI();
    }

    public void setRedirectURI(String redirectURI) {
        String oldValue = this.configuration.getRedirectURI();
        if (!StringUtils.equals((String)oldValue, (String)redirectURI)) {
            this.configuration.setRedirectURI(redirectURI);
            this.pcs.firePropertyChange(REDIRECT_URI_PROPERTY, oldValue, redirectURI);
        }
    }

    public OAuth1ProfileConfig getConfiguration() {
        return this.configuration;
    }

    public String getAccessTokenURI() {
        return this.configuration.getAccessTokenURI();
    }

    public void setAccessTokenURI(String accessTokenURI) {
        String newValue;
        String oldValue = this.configuration.getAccessTokenURI();
        if (!StringUtils.equals((String)oldValue, (String)(newValue = this.nullSafeTrim(accessTokenURI)))) {
            this.configuration.setAccessTokenURI(newValue);
            this.pcs.firePropertyChange(ACCESS_TOKEN_URI_PROPERTY, oldValue, newValue);
        }
    }

    public AccessTokenStatusConfig.Enum getAccessTokenStatus() {
        return this.getSavedAccessTokenStatusEnum(this.configuration.getAccessTokenStatus());
    }

    public void setAccessTokenStatus(AccessTokenStatusConfig.Enum newStatus) {
        AccessTokenStatusConfig.Enum oldStatus = this.getSavedAccessTokenStatusEnum(this.configuration.getAccessTokenStatus());
        if (newStatus == oldStatus) {
            return;
        }
        this.saveAccessTokenStatusEnum(newStatus, this.configuration);
        if (this.isAStartingStatus(newStatus)) {
            this.setAccessTokenStartingStatus(newStatus);
        }
        this.pcs.firePropertyChange(ACCESS_TOKEN_STATUS_PROPERTY, (Object)oldStatus, (Object)newStatus);
    }

    public AccessTokenStatusConfig.Enum getAccessTokenStartingStatus() {
        return this.getSavedAccessTokenStartingStatusEnum(this.configuration.getAccessTokenStartingStatus());
    }

    private void setAccessTokenStartingStatus(@Nonnull AccessTokenStatusConfig.Enum startingStatus) {
        Preconditions.checkNotNull((Object)((Object)startingStatus));
        this.saveAccessTokenStartingStatusEnum(startingStatus, this.configuration);
    }

    public void resetAccessTokenStatusToStartingStatus() {
        this.setAccessTokenStatus(this.getAccessTokenStartingStatus());
    }

    public AccessTokenPositionConfig.Enum getAccessTokenPosition() {
        return this.getSavedAccessTokenPositionEnum(this.configuration.getAccessTokenPosition());
    }

    public void setAccessTokenPosition(@Nonnull AccessTokenPositionConfig.Enum newAccessTokenPosition) {
        Preconditions.checkNotNull((Object)((Object)newAccessTokenPosition));
        AccessTokenPositionConfig.Enum oldAccessTokenPosition = this.getSavedAccessTokenPositionEnum(this.configuration.getAccessTokenPosition());
        this.saveAccessTokenPositionEnum(newAccessTokenPosition, this.configuration);
        this.pcs.firePropertyChange(ACCESS_TOKEN_POSITION_PROPERTY, (Object)oldAccessTokenPosition, (Object)newAccessTokenPosition);
    }

    public long getAccessTokenIssuedTime() {
        return this.configuration.getAccessTokenIssuedTime();
    }

    public void setAccessTokenIssuedTime(long newIssuedTime) {
        long oldIssuedTime = this.configuration.getAccessTokenIssuedTime();
        if (oldIssuedTime != newIssuedTime) {
            this.configuration.setAccessTokenIssuedTime(newIssuedTime);
            this.pcs.firePropertyChange(ACCESS_TOKEN_ISSUED_TIME, oldIssuedTime, newIssuedTime);
        }
    }

    public String getManualAccessTokenExpirationTime() {
        return this.configuration.getManualAccessTokenExpirationTime();
    }

    public void setManualAccessTokenExpirationTime(@Nonnull String newExpirationTime) {
        String oldExpirationTime = this.configuration.getManualAccessTokenExpirationTime();
        if (!Objects.equal((Object)oldExpirationTime, (Object)newExpirationTime)) {
            this.configuration.setManualAccessTokenExpirationTime(newExpirationTime);
            this.pcs.firePropertyChange(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME, oldExpirationTime, newExpirationTime);
        }
    }

    public boolean useManualAccessTokenExpirationTime() {
        return this.configuration.getUseManualAccessTokenExpirationTime();
    }

    public void setUseManualAccessTokenExpirationTime(boolean useManual) {
        boolean oldValue = this.configuration.getUseManualAccessTokenExpirationTime();
        if (oldValue != useManual) {
            this.configuration.setUseManualAccessTokenExpirationTime(useManual);
            this.pcs.firePropertyChange(USE_MANUAL_ACCESS_TOKEN_EXPIRATION_TIME, oldValue, useManual);
        }
    }

    public TimeUnitConfig.Enum getManualAccessTokenExpirationTimeUnit() {
        if (this.configuration.getManualAccessTokenExpirationTimeUnit() == null) {
            this.configuration.setManualAccessTokenExpirationTimeUnit(TimeUnitConfig.SECONDS);
        }
        return this.configuration.getManualAccessTokenExpirationTimeUnit();
    }

    public void setManualAccessTokenExpirationTimeUnit(TimeUnitConfig.Enum newValue) {
        TimeUnitConfig.Enum oldValue = this.getManualAccessTokenExpirationTimeUnit();
        if (!((Object)((Object)oldValue)).equals((Object)newValue)) {
            this.configuration.setManualAccessTokenExpirationTimeUnit(newValue);
            this.pcs.firePropertyChange(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME_UNIT_PROPERTY, oldValue.toString(), newValue.toString());
        }
    }

    public OAuth1ProfileContainer getContainer() {
        return this.OAuth1ProfileContainer;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.OAuth1ProfileContainer.getProject(), this);
        result.extractAndAddAll(CLIENT_ID_PROPERTY);
        result.extractAndAddAll(CLIENT_SECRET_PROPERTY);
        result.extractAndAddAll(AUTHORIZATION_URI_PROPERTY);
        result.extractAndAddAll(ACCESS_TOKEN_URI_PROPERTY);
        result.extractAndAddAll(REDIRECT_URI_PROPERTY);
        result.extractAndAddAll(ACCESS_TOKEN_PROPERTY);
        result.extractAndAddAll(SCOPE_PROPERTY);
        result.extractAndAddAll(MANUAL_ACCESS_TOKEN_EXPIRATION_TIME);
        result.extractAndAddAll(RESOURCE_OWNER_LOGIN_PROPERTY);
        result.extractAndAddAll(RESOURCE_OWNER_PASSWORD_PROPERTY);
        return result.toArray();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private boolean isAStartingStatus(AccessTokenStatusConfig.Enum newStatus) {
        return newStatus == AccessTokenStatusConfig.ENTERED_MANUALLY || newStatus == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER || newStatus == AccessTokenStatusConfig.EXPIRED;
    }

    private void setDefaultAccessTokenPosition() {
        if (this.getAccessTokenPosition() == null) {
            this.setAccessTokenPosition(AccessTokenPositionConfig.HEADER);
        }
    }

    private void setDefaultAccessTokenStatus() {
        this.setAccessTokenStatus(AccessTokenStatusConfig.UNKNOWN);
    }

    private AccessTokenStatusConfig.Enum getSavedAccessTokenStartingStatusEnum(AccessTokenStatusConfig.Enum persistedEnum) {
        return this.getSavedAccessTokenStatusEnum(persistedEnum);
    }

    private AccessTokenStatusConfig.Enum getSavedAccessTokenStatusEnum(AccessTokenStatusConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return AccessTokenStatusConfig.UNKNOWN;
        }
        return persistedEnum;
    }

    private AccessTokenPositionConfig.Enum getSavedAccessTokenPositionEnum(AccessTokenPositionConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return null;
        }
        return persistedEnum;
    }

    private RefreshAccessTokenMethods getSavedRefreshAccessTokenMethodsEnum(RefreshAccessTokenMethodConfig.Enum persistedEnum) {
        if (persistedEnum == null) {
            return null;
        }
        return RefreshAccessTokenMethods.valueOf(persistedEnum.toString());
    }

    private void saveAccessTokenStatusEnum(AccessTokenStatusConfig.Enum enumToBePersisted, OAuth1ProfileConfig configuration) {
        configuration.setAccessTokenStatus(enumToBePersisted);
    }

    private void saveAccessTokenStartingStatusEnum(AccessTokenStatusConfig.Enum enumToBePersisted, OAuth1ProfileConfig configuration) {
        configuration.setAccessTokenStartingStatus(enumToBePersisted);
    }

    private void saveAccessTokenPositionEnum(AccessTokenPositionConfig.Enum enumToBePersisted, OAuth1ProfileConfig configuration) {
        configuration.setAccessTokenPosition(enumToBePersisted);
    }

    public void applyRetrievedTokenSecret(String tokenSecret) {
        this.doSetTokenSecret(tokenSecret);
        this.setTokenSecretStatus(AccessTokenStatusConfig.RETRIEVED_FROM_SERVER);
    }

    private boolean doSetTokenSecret(String tokenSecret) {
        String newValue;
        String oldValue = this.configuration.getTokenSecret();
        String string = newValue = tokenSecret == null ? null : tokenSecret.trim();
        if (!StringUtils.equals((String)oldValue, (String)newValue)) {
            this.configuration.setTokenSecret(newValue);
            this.pcs.firePropertyChange(TOKEN_SECRET_PROPERTY, oldValue, newValue);
            return true;
        }
        return false;
    }

    public static enum RefreshAccessTokenMethods {
        AUTOMATIC("Automatic"),
        MANUAL("Manual");

        private final String description;

        private RefreshAccessTokenMethods(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum AccessTokenPosition {
        QUERY("Query"),
        HEADER("Header"),
        BODY("Body");

        private String description;

        private AccessTokenPosition(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum AccessTokenStatus {
        UNKNOWN("Unknown"),
        ENTERED_MANUALLY("Entered Manually"),
        WAITING_FOR_AUTHORIZATION("Waiting for Authorization"),
        RECEIVED_AUTHORIZATION_CODE("Received authorization code"),
        RETRIEVED_FROM_SERVER("Retrieved from server"),
        RETRIEVAL_CANCELED("Retrieval canceled"),
        EXPIRED("Expired");

        private String description;

        private AccessTokenStatus(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

