/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.GenerateWsdlTestSuiteAction;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;

public class NewWsdlProjectAction
extends AbstractSoapUIAction<WorkspaceImpl> {
    public static final String SOAPUI_ACTION_ID = "NewWsdlProjectAction";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(NewWsdlProjectAction.class);

    public NewWsdlProjectAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setValue(Form.CREATEREQUEST, Boolean.toString(true));
            this.dialog.getFormField(Form.INITIALWSDL).addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    String value = newValue.toLowerCase().trim();
                    NewWsdlProjectAction.this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(value.length() > 0 && !newValue.endsWith(".wadl"));
                    NewWsdlProjectAction.this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(newValue.trim().length() > 0);
                    NewWsdlProjectAction.this.initProjectName(newValue);
                }
            });
        } else {
            this.dialog.setValue(Form.INITIALWSDL, "");
            this.dialog.setValue(Form.PROJECTNAME, "");
            this.dialog.getFormField(Form.CREATEREQUEST).setEnabled(false);
            this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(false);
        }
        if (param instanceof String) {
            this.dialog.setValue(Form.INITIALWSDL, param.toString());
            this.initProjectName(param.toString());
        }
        while (this.dialog.show()) {
            WsdlProject project = null;
            try {
                String projectName = this.dialog.getValue(Form.PROJECTNAME).trim();
                if (projectName.length() == 0) {
                    UISupport.showErrorMessage(messages.get("MissingProjectNameError"));
                    continue;
                }
                project = workspace.createProject(projectName, null);
                if (project == null) continue;
                UISupport.select(project);
                String url = this.dialog.getValue(Form.INITIALWSDL).trim();
                if (this.dialog.getBooleanValue(Form.RELATIVEPATHS)) {
                    String folder = workspace.getProjectRoot();
                    if (PathUtils.isFilePath(url) && PathUtils.isAbsolutePath(url)) {
                        folder = new File(url).getParent();
                    }
                    if (project.save(folder) != SaveStatus.SUCCESS) {
                        UISupport.showErrorMessage("Project was not saved, paths will not be stored relatively until configured.");
                    } else {
                        project.setResourceRoot("${projectDir}");
                    }
                }
                if (url.length() > 0) {
                    if (new File(url).exists()) {
                        url = new File(url).toURI().toURL().toString();
                    }
                    this.importWsdl(project, url);
                }
                if (param == null || !(param instanceof SoapUIActions)) break;
                Analytics.trackAction((SoapUIActions)((Object)param));
                break;
            }
            catch (InvalidDefinitionException ex) {
                ex.show();
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
                if (project == null) continue;
                workspace.removeProject(project);
            }
        }
    }

    public void initProjectName(String newValue) {
        if (StringUtils.isNullOrEmpty(this.dialog.getValue(Form.PROJECTNAME)) && StringUtils.hasContent(newValue)) {
            int ix = newValue.lastIndexOf(46);
            if (ix > 0) {
                newValue = newValue.substring(0, ix);
            }
            if ((ix = newValue.lastIndexOf(47)) == -1) {
                ix = newValue.lastIndexOf(92);
            }
            if (ix != -1) {
                this.dialog.setValue(Form.PROJECTNAME, newValue.substring(ix + 1));
            }
        }
    }

    private void importWsdl(WsdlProject project, String url) throws SoapUIException {
        WsdlInterface[] results;
        for (WsdlInterface iface : results = WsdlInterfaceFactory.importWsdl(project, url, this.dialog.getValue(Form.CREATEREQUEST).equals("true"))) {
            UISupport.select(iface);
            if (!this.dialog.getBooleanValue(Form.GENERATETESTSUITE)) continue;
            GenerateWsdlTestSuiteAction generateTestSuiteAction = new GenerateWsdlTestSuiteAction();
            generateTestSuiteAction.generateTestSuite(iface, true);
        }
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="/Working-with-Projects/new-project.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ProjectName.Description", type=AField.AFieldType.STRING)
        public static final String PROJECTNAME = messages.get("Form.ProjectName.Label");
        @AField(description="Form.InitialWsdl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = messages.get("Form.InitialWsdl.Label");
        @AField(description="Form.CreateRequests.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String CREATEREQUEST = messages.get("Form.CreateRequests.Label");
        @AField(description="Form.GenerateTestSuite.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATETESTSUITE = messages.get("Form.GenerateTestSuite.Label");
        @AField(description="Form.RelativePaths.Description", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String RELATIVEPATHS = messages.get("Form.RelativePaths.Label");
    }
}

